//
// BLOBStream.h
//
// $Id: //poco/1.4/Data/include/Poco/Data/BLOBStream.h#1 $
//
// Library: Data
// Package: DataCore
// Module:  BLOBStream
//
// Definition of the BLOBStream class.
//
// Copyright (c) 2004-2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef Data_BLOBStream_INCLUDED
#define Data_BLOBStream_INCLUDED


#include "Poco/Foundation.h"
#include "Poco/UnbufferedStreamBuf.h"
#include "Poco/Data/BLOB.h"
#include <istream>
#include <ostream>


namespace Poco {
namespace Data {


class Data_API BLOBStreamBuf: public UnbufferedStreamBuf
	/// This is the streambuf class used for reading from and writing to a BLOB.
{
public:	
	BLOBStreamBuf(BLOB& blob);
		/// Creates BLOBStreamBuf.

	~BLOBStreamBuf();
		/// Destroys BLOBStreamBuf.

protected:
	int_type readFromDevice();
	int_type writeToDevice(char c);

private:
	BLOB&          _blob;
	BLOB::Iterator _it;
};


class Data_API BLOBIOS: public virtual std::ios
	/// The base class for BLOBInputStream and
	/// BLOBOutputStream.
	///
	/// This class is needed to ensure the correct initialization
	/// order of the stream buffer and base classes.
{
public:
	BLOBIOS(BLOB& blob, openmode mode);
		/// Creates the BLOBIOS with the given BLOB.
		
	~BLOBIOS();
		/// Destroys the BLOBIOS.
		
	BLOBStreamBuf* rdbuf();
		/// Returns a pointer to the internal BLOBStreamBuf.
		
protected:
	BLOBStreamBuf _buf;
};


class Data_API BLOBOutputStream: public BLOBIOS, public std::ostream
	/// An output stream for writing to a BLOB.
{
public:
	BLOBOutputStream(BLOB& blob);
		/// Creates the BLOBOutputStream with the given BLOB.

	~BLOBOutputStream();
		/// Destroys the BLOBOutputStream.
};


class Data_API BLOBInputStream: public BLOBIOS, public std::istream
	/// An input stream for reading from a BLOB.
{
public:
	BLOBInputStream(BLOB& blob);
		/// Creates the BLOBInputStream with the given BLOB.

	~BLOBInputStream();
		/// Destroys the BLOBInputStream.
};


} } // namespace Poco::Data


#endif // Data_BLOBStream_INCLUDED
