/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.ArgumentListProcessor;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Environment;
import org.armedbear.lisp.Function;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.SpecialBindingsMark;
import org.armedbear.lisp.Symbol;

public class Closure
extends Function {
    public static final int REQUIRED = 0;
    public static final int OPTIONAL = 1;
    public static final int KEYWORD = 2;
    public static final int REST = 3;
    public static final int AUX = 4;
    private final LispObject body;
    private final LispObject executionBody;
    private final Environment environment;
    private final Symbol[] freeSpecials;
    private final ArgumentListProcessor arglist;

    public Closure(ArgumentListProcessor arglist2) {
        this.body = null;
        this.executionBody = null;
        this.environment = null;
        this.arglist = arglist2;
        this.freeSpecials = new Symbol[0];
    }

    public Closure(LispObject lambdaExpression, Environment env) {
        this(null, lambdaExpression, env);
    }

    public Closure(LispObject name, LispObject lambdaExpression, Environment env) {
        super(name, lambdaExpression.cadr());
        LispObject lambdaList = lambdaExpression.cadr();
        this.setLambdaList(lambdaList);
        if (lambdaList != Lisp.NIL && !(lambdaList instanceof Cons)) {
            Lisp.program_error("The lambda list " + lambdaList.princToString() + " is invalid.");
        }
        this.body = lambdaExpression.cddr();
        LispObject bodyAndDecls = Lisp.parseBody(this.body, false);
        this.executionBody = bodyAndDecls.car();
        LispObject specials = Lisp.parseSpecials(bodyAndDecls.NTH(1));
        this.environment = env;
        this.arglist = new ArgumentListProcessor(this, lambdaList, specials, lambdaExpression.car() == Symbol.MACRO_FUNCTION ? ArgumentListProcessor.LambdaListType.MACRO : ArgumentListProcessor.LambdaListType.ORDINARY);
        this.freeSpecials = this.arglist.freeSpecials(specials);
    }

    public LispObject typep(LispObject typeSpecifier) {
        if (typeSpecifier == Symbol.COMPILED_FUNCTION) {
            return Lisp.NIL;
        }
        return super.typep(typeSpecifier);
    }

    public final LispObject getVariableList() {
        Symbol[] variables = this.arglist.getVariables();
        LispObject result = Lisp.NIL;
        int i = variables.length;
        while (i-- > 0) {
            result = new Cons(variables[i], result);
        }
        return result;
    }

    public final LispObject getBody() {
        return this.body;
    }

    public final Environment getEnvironment() {
        return this.environment;
    }

    public LispObject execute() {
        return this.execute(new LispObject[0]);
    }

    public LispObject execute(LispObject arg) {
        return this.execute(new LispObject[]{arg});
    }

    public LispObject execute(LispObject first, LispObject second) {
        return this.execute(new LispObject[]{first, second});
    }

    public LispObject execute(LispObject first, LispObject second, LispObject third) {
        return this.execute(new LispObject[]{first, second, third});
    }

    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth) {
        return this.execute(new LispObject[]{first, second, third, fourth});
    }

    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth) {
        return this.execute(new LispObject[]{first, second, third, fourth, fifth});
    }

    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth, LispObject sixth) {
        return this.execute(new LispObject[]{first, second, third, fourth, fifth, sixth});
    }

    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth, LispObject sixth, LispObject seventh) {
        return this.execute(new LispObject[]{first, second, third, fourth, fifth, sixth, seventh});
    }

    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth, LispObject sixth, LispObject seventh, LispObject eighth) {
        return this.execute(new LispObject[]{first, second, third, fourth, fifth, sixth, seventh, eighth});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LispObject execute(LispObject[] args) {
        LispThread thread = LispThread.currentThread();
        SpecialBindingsMark mark = thread.markSpecialBindings();
        Environment ext = new Environment(this.environment);
        args = this.arglist.match(args, this.environment, ext, thread);
        this.arglist.bindVars(args, ext, thread);
        for (Symbol special : this.freeSpecials) {
            ext.declareSpecial(special);
        }
        try {
            LispObject lispObject = Lisp.progn(this.executionBody, ext, thread);
            return lispObject;
        }
        finally {
            thread.resetSpecialBindings(mark);
        }
    }

    protected final LispObject[] processArgs(LispObject[] args, LispThread thread) {
        return this.arglist.match(args, this.environment, this.environment, thread);
    }
}

