/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Function;
import org.armedbear.lisp.JavaObject;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.SimpleVector;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.WrongNumberOfArgumentsException;

public final class JHandler {
    static final Map<Object, Map<String, Entry>> table = new WeakHashMap<Object, Map<String, Entry>>();
    private static final Primitive _JREGISTER_HANDLER = new Primitive("%jregister-handler", Lisp.PACKAGE_JAVA){

        public LispObject execute(LispObject[] args) {
            if (args.length != 5) {
                return Lisp.error(new WrongNumberOfArgumentsException(this, 5));
            }
            HashMap<String, Entry> entryTable = null;
            Object object = args[0].javaInstance();
            String event = ((Symbol)args[1]).getName();
            if (!table.containsKey(object)) {
                entryTable = new HashMap();
                table.put(object, entryTable);
            } else {
                entryTable = table.get(object);
            }
            Entry entry = new Entry((Function)args[2], args[3], event, entryTable);
            if (args[4] != Lisp.NIL) {
                entry.addCount(((Fixnum)args[4]).value);
            }
            entryTable.put(event, entry);
            return Lisp.T;
        }
    };

    public static void callLisp(String s, Object o) {
        JHandler.callLisp(s, o, "");
    }

    public static void callLisp(String s, Object o, String s1) {
        JHandler.callLisp(s, o, s1, new int[0]);
    }

    public static void callLisp(String s, Object o, String s1, int[] ai) {
        JHandler.callLisp(s, o, new String[]{s1}, ai);
    }

    public static void callLisp(String s, Object o, String[] as) {
        JHandler.callLisp(s, o, as, new int[0]);
    }

    public static void callLisp(String s, Object o, String[] as, int[] ai) {
        Map<String, Entry> entryTable;
        if (table.containsKey(o) && (entryTable = table.get(o)).containsKey(s)) {
            Entry entry = entryTable.get(s);
            Function f = entry.getHandler();
            LispObject data = entry.getData();
            Fixnum count = entry.getCount();
            LispObject[] lispAi = new Fixnum[ai.length];
            for (int i = 0; i < ai.length; ++i) {
                lispAi[i] = Fixnum.getInstance(ai[i]);
            }
            SimpleVector lispAiVector = new SimpleVector(lispAi);
            LispObject[] lispAs = new SimpleString[as.length];
            for (int i = 0; i < as.length; ++i) {
                lispAs[i] = new SimpleString(as[i]);
            }
            SimpleVector lispAsVector = new SimpleVector(lispAs);
            LispObject[] args = new LispObject[]{data, new JavaObject(o), lispAiVector, lispAsVector, Lisp.internKeyword(s), count};
            f.execute(args);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry {
        Function handler;
        LispObject data;
        int count = -1;
        Map<String, Entry> entryTable;
        String event;

        public Entry(Function handler, LispObject data, String event, Map<String, Entry> entryTable) {
            this.entryTable = entryTable;
            this.event = event;
            this.handler = handler;
            this.data = data;
        }

        public Function getHandler() {
            return this.handler;
        }

        public void addData(LispObject data) {
            this.data = data;
        }

        public LispObject getData() {
            return this.data;
        }

        public void addCount(int count) {
            this.count = count;
        }

        public Fixnum getCount() {
            if (this.count == 0) {
                this.entryTable.remove(this.event);
            }
            return Fixnum.getInstance(this.count--);
        }
    }
}

