/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.AbstractArray;
import org.armedbear.lisp.AbstractBitVector;
import org.armedbear.lisp.AbstractVector;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.ComplexBitVector;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.Symbol;

public final class SimpleBitVector
extends AbstractBitVector {
    private static final Primitive _SIMPLE_BIT_VECTOR_BIT_AND = new Primitive("%simple-bit-vector-bit-and", Lisp.PACKAGE_SYS, false, "bit-vector1 bit-vector2 result-bit-vector"){

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            return ((SimpleBitVector)first).and((SimpleBitVector)second, (SimpleBitVector)third);
        }
    };
    private static final Primitive _SIMPLE_BIT_VECTOR_BIT_IOR = new Primitive("%simple-bit-vector-bit-ior", Lisp.PACKAGE_SYS, false, "bit-vector1 bit-vector2 result-bit-vector"){

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            return ((SimpleBitVector)first).ior((SimpleBitVector)second, (SimpleBitVector)third);
        }
    };
    private static final Primitive _SIMPLE_BIT_VECTOR_BIT_XOR = new Primitive("%simple-bit-vector-bit-xor", Lisp.PACKAGE_SYS, false, "bit-vector1 bit-vector2 result-bit-vector"){

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            return ((SimpleBitVector)first).xor((SimpleBitVector)second, (SimpleBitVector)third);
        }
    };
    private static final Primitive _SIMPLE_BIT_VECTOR_BIT_EQV = new Primitive("%simple-bit-vector-bit-eqv", Lisp.PACKAGE_SYS, false, "bit-vector1 bit-vector2 result-bit-vector"){

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            return ((SimpleBitVector)first).eqv((SimpleBitVector)second, (SimpleBitVector)third);
        }
    };
    private static final Primitive _SIMPLE_BIT_VECTOR_BIT_NAND = new Primitive("%simple-bit-vector-bit-nand", Lisp.PACKAGE_SYS, false, "bit-vector1 bit-vector2 result-bit-vector"){

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            return ((SimpleBitVector)first).nand((SimpleBitVector)second, (SimpleBitVector)third);
        }
    };
    private static final Primitive _SIMPLE_BIT_VECTOR_BIT_NOR = new Primitive("%simple-bit-vector-bit-nor", Lisp.PACKAGE_SYS, false, "bit-vector1 bit-vector2 result-bit-vector"){

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            return ((SimpleBitVector)first).nor((SimpleBitVector)second, (SimpleBitVector)third);
        }
    };
    private static final Primitive _SIMPLE_BIT_VECTOR_BIT_ANDC1 = new Primitive("%simple-bit-vector-bit-andc1", Lisp.PACKAGE_SYS, false, "bit-vector1 bit-vector2 result-bit-vector"){

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            return ((SimpleBitVector)first).andc1((SimpleBitVector)second, (SimpleBitVector)third);
        }
    };
    private static final Primitive _SIMPLE_BIT_VECTOR_BIT_ANDC2 = new Primitive("%simple-bit-vector-bit-andc2", Lisp.PACKAGE_SYS, false, "bit-vector1 bit-vector2 result-bit-vector"){

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            return ((SimpleBitVector)first).andc2((SimpleBitVector)second, (SimpleBitVector)third);
        }
    };
    private static final Primitive _SIMPLE_BIT_VECTOR_BIT_ORC1 = new Primitive("%simple-bit-vector-bit-orc1", Lisp.PACKAGE_SYS, false, "bit-vector1 bit-vector2 result-bit-vector"){

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            return ((SimpleBitVector)first).orc1((SimpleBitVector)second, (SimpleBitVector)third);
        }
    };
    private static final Primitive _SIMPLE_BIT_VECTOR_BIT_ORC2 = new Primitive("%simple-bit-vector-bit-orc2", Lisp.PACKAGE_SYS, false, "bit-vector1 bit-vector2 result-bit-vector"){

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            return ((SimpleBitVector)first).orc2((SimpleBitVector)second, (SimpleBitVector)third);
        }
    };
    private static final Primitive _SIMPLE_BIT_VECTOR_BIT_NOT = new Primitive("%simple-bit-vector-bit-not", Lisp.PACKAGE_SYS, false, "bit-vector result-bit-vector"){

        public LispObject execute(LispObject first, LispObject second) {
            SimpleBitVector v = (SimpleBitVector)first;
            SimpleBitVector result = (SimpleBitVector)second;
            int i = v.bits.length;
            while (i-- > 0) {
                result.bits[i] = v.bits[i] ^ 0xFFFFFFFFFFFFFFFFL;
            }
            return result;
        }
    };

    public SimpleBitVector(int capacity) {
        this.capacity = capacity;
        int size = capacity >>> 6;
        if ((capacity & 0x3F) != 0) {
            ++size;
        }
        this.bits = new long[size];
    }

    public SimpleBitVector(String s) {
        this(s.length());
        int i = this.capacity;
        while (i-- > 0) {
            char c = s.charAt(i);
            if (c == '0') continue;
            if (c == '1') {
                this.setBit(i);
                continue;
            }
            Debug.assertTrue(false);
        }
    }

    public LispObject typeOf() {
        return Lisp.list(Symbol.SIMPLE_BIT_VECTOR, Fixnum.getInstance(this.capacity));
    }

    public LispObject classOf() {
        return BuiltInClass.SIMPLE_BIT_VECTOR;
    }

    public LispObject typep(LispObject type) {
        if (type == Symbol.SIMPLE_BIT_VECTOR) {
            return Lisp.T;
        }
        if (type == Symbol.SIMPLE_ARRAY) {
            return Lisp.T;
        }
        if (type == BuiltInClass.SIMPLE_BIT_VECTOR) {
            return Lisp.T;
        }
        if (type == BuiltInClass.SIMPLE_ARRAY) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    public boolean hasFillPointer() {
        return false;
    }

    public boolean isAdjustable() {
        return false;
    }

    public boolean isSimpleVector() {
        return true;
    }

    public int length() {
        return this.capacity;
    }

    public LispObject elt(int index) {
        int offset;
        if (index < 0 || index >= this.length()) {
            this.badIndex(index, this.length());
        }
        return (this.bits[offset = index >> 6] & 1L << (index & 0x3F)) != 0L ? Fixnum.ONE : Fixnum.ZERO;
    }

    public LispObject AREF(int index) {
        int offset;
        if (index < 0 || index >= this.capacity) {
            this.badIndex(index, this.capacity);
        }
        return (this.bits[offset = index >> 6] & 1L << (index & 0x3F)) != 0L ? Fixnum.ONE : Fixnum.ZERO;
    }

    public void aset(int index, LispObject newValue) {
        if (index < 0 || index >= this.capacity) {
            this.badIndex(index, this.capacity);
        }
        int offset = index >> 6;
        if (newValue instanceof Fixnum) {
            switch (((Fixnum)newValue).value) {
                case 0: {
                    int n = offset;
                    this.bits[n] = this.bits[n] & (1L << (index & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
                    return;
                }
                case 1: {
                    int n = offset;
                    this.bits[n] = this.bits[n] | 1L << (index & 0x3F);
                    return;
                }
            }
        }
        Lisp.type_error(newValue, Symbol.BIT);
    }

    protected int getBit(int index) {
        int offset = index >> 6;
        return (this.bits[offset] & 1L << (index & 0x3F)) != 0L ? 1 : 0;
    }

    protected void setBit(int index) {
        int offset;
        int n = offset = index >> 6;
        this.bits[n] = this.bits[n] | 1L << (index & 0x3F);
    }

    protected void clearBit(int index) {
        int offset;
        int n = offset = index >> 6;
        this.bits[n] = this.bits[n] & (1L << (index & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void shrink(int n) {
        if (n < this.capacity) {
            int size = n >>> 6;
            if ((n & 0x3F) != 0) {
                ++size;
            }
            if (size < this.bits.length) {
                long[] newbits = new long[size];
                System.arraycopy(this.bits, 0, newbits, 0, size);
                this.bits = newbits;
            }
            this.capacity = n;
            return;
        }
        if (n == this.capacity) {
            return;
        }
        Lisp.error(new LispError());
    }

    public AbstractVector adjustArray(int newCapacity, LispObject initialElement, LispObject initialContents) {
        if (initialContents != null) {
            SimpleBitVector v = new SimpleBitVector(newCapacity);
            if (initialContents.listp()) {
                LispObject list = initialContents;
                for (int i = 0; i < newCapacity; ++i) {
                    v.aset(i, list.car());
                    list = list.cdr();
                }
            } else if (initialContents.vectorp()) {
                for (int i = 0; i < newCapacity; ++i) {
                    v.aset(i, initialContents.elt(i));
                }
            } else {
                Lisp.type_error(initialContents, Symbol.SEQUENCE);
            }
            return v;
        }
        if (this.capacity != newCapacity) {
            int limit;
            SimpleBitVector v = new SimpleBitVector(newCapacity);
            int i = limit = Math.min(this.capacity, newCapacity);
            while (i-- > 0) {
                if (this.getBit(i) == 1) {
                    v.setBit(i);
                    continue;
                }
                v.clearBit(i);
            }
            if (initialElement != null && this.capacity < newCapacity) {
                int n = Fixnum.getValue(initialElement);
                if (n == 1) {
                    for (int i2 = this.capacity; i2 < newCapacity; ++i2) {
                        v.setBit(i2);
                    }
                } else {
                    for (int i3 = this.capacity; i3 < newCapacity; ++i3) {
                        v.clearBit(i3);
                    }
                }
            }
            return v;
        }
        return this;
    }

    public AbstractVector adjustArray(int newCapacity, AbstractArray displacedTo, int displacement) {
        return new ComplexBitVector(newCapacity, displacedTo, displacement);
    }

    SimpleBitVector and(SimpleBitVector v, SimpleBitVector result) {
        if (result == null) {
            result = new SimpleBitVector(this.capacity);
        }
        int i = this.bits.length;
        while (i-- > 0) {
            result.bits[i] = this.bits[i] & v.bits[i];
        }
        return result;
    }

    SimpleBitVector ior(SimpleBitVector v, SimpleBitVector result) {
        if (result == null) {
            result = new SimpleBitVector(this.capacity);
        }
        int i = this.bits.length;
        while (i-- > 0) {
            result.bits[i] = this.bits[i] | v.bits[i];
        }
        return result;
    }

    SimpleBitVector xor(SimpleBitVector v, SimpleBitVector result) {
        if (result == null) {
            result = new SimpleBitVector(this.capacity);
        }
        int i = this.bits.length;
        while (i-- > 0) {
            result.bits[i] = this.bits[i] ^ v.bits[i];
        }
        return result;
    }

    SimpleBitVector eqv(SimpleBitVector v, SimpleBitVector result) {
        if (result == null) {
            result = new SimpleBitVector(this.capacity);
        }
        int i = this.bits.length;
        while (i-- > 0) {
            result.bits[i] = this.bits[i] ^ v.bits[i] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return result;
    }

    SimpleBitVector nand(SimpleBitVector v, SimpleBitVector result) {
        if (result == null) {
            result = new SimpleBitVector(this.capacity);
        }
        int i = this.bits.length;
        while (i-- > 0) {
            result.bits[i] = this.bits[i] & v.bits[i] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return result;
    }

    SimpleBitVector nor(SimpleBitVector v, SimpleBitVector result) {
        if (result == null) {
            result = new SimpleBitVector(this.capacity);
        }
        int i = this.bits.length;
        while (i-- > 0) {
            result.bits[i] = (this.bits[i] | v.bits[i]) ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return result;
    }

    SimpleBitVector andc1(SimpleBitVector v, SimpleBitVector result) {
        if (result == null) {
            result = new SimpleBitVector(this.capacity);
        }
        int i = this.bits.length;
        while (i-- > 0) {
            result.bits[i] = (this.bits[i] ^ 0xFFFFFFFFFFFFFFFFL) & v.bits[i];
        }
        return result;
    }

    SimpleBitVector andc2(SimpleBitVector v, SimpleBitVector result) {
        if (result == null) {
            result = new SimpleBitVector(this.capacity);
        }
        int i = this.bits.length;
        while (i-- > 0) {
            result.bits[i] = this.bits[i] & (v.bits[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
        return result;
    }

    SimpleBitVector orc1(SimpleBitVector v, SimpleBitVector result) {
        if (result == null) {
            result = new SimpleBitVector(this.capacity);
        }
        int i = this.bits.length;
        while (i-- > 0) {
            result.bits[i] = this.bits[i] ^ 0xFFFFFFFFFFFFFFFFL | v.bits[i];
        }
        return result;
    }

    SimpleBitVector orc2(SimpleBitVector v, SimpleBitVector result) {
        if (result == null) {
            result = new SimpleBitVector(this.capacity);
        }
        int i = this.bits.length;
        while (i-- > 0) {
            result.bits[i] = this.bits[i] | v.bits[i] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return result;
    }
}

