/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.shiro.authz;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.shiro.authz.Action;
import org.apache.activemq.shiro.authz.ActionPermissionResolver;
import org.apache.activemq.shiro.authz.ActiveMQWildcardPermission;
import org.apache.activemq.shiro.authz.DestinationAction;
import org.apache.shiro.authz.Permission;

public class DestinationActionPermissionResolver
implements ActionPermissionResolver {
    private String permissionStringPrefix;
    private boolean permissionStringCaseSensitive = true;

    public String getPermissionStringPrefix() {
        return this.permissionStringPrefix;
    }

    public void setPermissionStringPrefix(String permissionStringPrefix) {
        this.permissionStringPrefix = permissionStringPrefix;
    }

    public boolean isPermissionStringCaseSensitive() {
        return this.permissionStringCaseSensitive;
    }

    public void setPermissionStringCaseSensitive(boolean permissionStringCaseSensitive) {
        this.permissionStringCaseSensitive = permissionStringCaseSensitive;
    }

    @Override
    public Collection<Permission> getPermissions(Action action) {
        if (!(action instanceof DestinationAction)) {
            throw new IllegalArgumentException("Action argument must be a " + DestinationAction.class.getName() + " instance.");
        }
        DestinationAction da = (DestinationAction)action;
        return this.getPermissions(da);
    }

    protected Collection<Permission> getPermissions(DestinationAction da) {
        ActiveMQDestination dest = da.getDestination();
        String verb = da.getVerb();
        return this.createPermissions(dest, verb);
    }

    protected Collection<Permission> createPermissions(ActiveMQDestination dest, String verb) {
        HashSet<Permission> set;
        if (dest.isComposite()) {
            ActiveMQDestination[] composites = dest.getCompositeDestinations();
            set = new LinkedHashSet(composites.length);
            for (ActiveMQDestination d : composites) {
                Collection<Permission> perms = this.createPermissions(d, verb);
                set.addAll(perms);
            }
        } else {
            set = new HashSet<Permission>(1);
            String permString = this.createPermissionString(dest, verb);
            Permission perm = this.createPermission(permString);
            set.add(perm);
        }
        return set;
    }

    protected String createPermissionString(ActiveMQDestination dest, String verb) {
        if (dest.isComposite()) {
            throw new IllegalArgumentException("Use createPermissionStrings for composite destinations.");
        }
        StringBuilder sb = new StringBuilder();
        if (this.permissionStringPrefix != null) {
            sb.append(this.permissionStringPrefix);
            if (!this.permissionStringPrefix.endsWith(":")) {
                sb.append(":");
            }
        }
        if (dest.isTemporary()) {
            sb.append("temp-");
        }
        if (dest.isTopic()) {
            sb.append("topic:");
        } else {
            sb.append("queue:");
        }
        sb.append(dest.getPhysicalName());
        sb.append(':');
        sb.append(verb);
        return sb.toString();
    }

    protected Permission createPermission(String permissionString) {
        return new ActiveMQWildcardPermission(permissionString, this.isPermissionStringCaseSensitive());
    }
}

