/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.spring31.xml.encryption;

import java.beans.Statement;
import java.security.Provider;
import org.jasypt.encryption.pbe.PBEBigDecimalEncryptor;
import org.jasypt.encryption.pbe.PBEBigIntegerEncryptor;
import org.jasypt.encryption.pbe.PBEByteEncryptor;
import org.jasypt.encryption.pbe.PBEStringEncryptor;
import org.jasypt.encryption.pbe.PooledPBEBigDecimalEncryptor;
import org.jasypt.encryption.pbe.PooledPBEBigIntegerEncryptor;
import org.jasypt.encryption.pbe.PooledPBEByteEncryptor;
import org.jasypt.encryption.pbe.PooledPBEStringEncryptor;
import org.jasypt.encryption.pbe.StandardPBEBigDecimalEncryptor;
import org.jasypt.encryption.pbe.StandardPBEBigIntegerEncryptor;
import org.jasypt.encryption.pbe.StandardPBEByteEncryptor;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.jasypt.encryption.pbe.config.PBEConfig;
import org.jasypt.salt.SaltGenerator;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EncryptorFactoryBean
implements FactoryBean<Object>,
InitializingBean {
    static final int ENCRYPTOR_TYPE_BYTE = 0;
    static final int ENCRYPTOR_TYPE_STRING = 1;
    static final int ENCRYPTOR_TYPE_BIG_DECIMAL = 2;
    static final int ENCRYPTOR_TYPE_BIG_INTEGER = 3;
    private final int encryptorType;
    private boolean singleton = true;
    private Object singletonInstance = null;
    private boolean algorithmSet = false;
    private String algorithm = null;
    private boolean configSet = false;
    private PBEConfig config = null;
    private boolean keyObtentionIterationsSet = false;
    private Integer keyObtentionIterations = null;
    private boolean passwordSet = false;
    private String password = null;
    private boolean poolSizeSet = false;
    private Integer poolSize = null;
    private boolean providerSet = false;
    private Provider provider = null;
    private boolean providerNameSet = false;
    private String providerName = null;
    private boolean saltGeneratorSet = false;
    private SaltGenerator saltGenerator = null;
    private boolean stringOutputTypeSet = false;
    private String stringOutputType = null;

    public EncryptorFactoryBean(int encryptorType) {
        this.encryptorType = encryptorType;
    }

    public final void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public final boolean isSingleton() {
        return this.singleton;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
        this.algorithmSet = true;
    }

    public void setConfig(PBEConfig config) {
        this.config = config;
        this.configSet = true;
    }

    public void setKeyObtentionIterations(Integer keyObtentionIterations) {
        this.keyObtentionIterations = keyObtentionIterations;
        this.keyObtentionIterationsSet = true;
    }

    public void setPassword(String password) {
        this.password = password;
        this.passwordSet = true;
    }

    public void setPoolSize(Integer poolSize) {
        this.poolSize = poolSize;
        this.poolSizeSet = true;
    }

    public void setProvider(Provider provider) {
        this.provider = provider;
        this.providerSet = true;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
        this.providerNameSet = true;
    }

    public void setSaltGenerator(SaltGenerator saltGenerator) {
        this.saltGenerator = saltGenerator;
        this.saltGeneratorSet = true;
    }

    public void setStringOutputType(String stringOutputType) {
        this.stringOutputType = stringOutputType;
        this.stringOutputTypeSet = true;
    }

    public final void afterPropertiesSet() throws Exception {
        if (this.singleton) {
            this.singletonInstance = this.computeObject();
        }
    }

    public Object getObject() throws Exception {
        if (this.singleton) {
            return this.singletonInstance;
        }
        return this.computeObject();
    }

    private Object computeObject() throws Exception {
        Statement st;
        PooledPBEByteEncryptor encryptor = null;
        if (this.isPooled()) {
            if (this.encryptorType == 0) {
                encryptor = new PooledPBEByteEncryptor();
            } else if (this.encryptorType == 1) {
                encryptor = new PooledPBEStringEncryptor();
            } else if (this.encryptorType == 2) {
                encryptor = new PooledPBEBigDecimalEncryptor();
            } else if (this.encryptorType == 3) {
                encryptor = new PooledPBEBigIntegerEncryptor();
            } else {
                throw new IllegalArgumentException("Unknown encryptor type: " + this.encryptorType);
            }
            if (this.poolSizeSet && this.poolSize != null) {
                st = new Statement(encryptor, "setPoolSize", new Object[]{this.poolSize});
                st.execute();
            }
        } else if (this.encryptorType == 0) {
            encryptor = new StandardPBEByteEncryptor();
        } else if (this.encryptorType == 1) {
            encryptor = new StandardPBEStringEncryptor();
        } else if (this.encryptorType == 2) {
            encryptor = new StandardPBEBigDecimalEncryptor();
        } else if (this.encryptorType == 3) {
            encryptor = new StandardPBEBigIntegerEncryptor();
        } else {
            throw new IllegalArgumentException("Unknown encryptor type: " + this.encryptorType);
        }
        if (this.algorithmSet) {
            st = new Statement(encryptor, "setAlgorithm", new Object[]{this.algorithm});
            st.execute();
        }
        if (this.configSet) {
            st = new Statement(encryptor, "setConfig", new Object[]{this.config});
            st.execute();
        }
        if (this.keyObtentionIterationsSet && this.keyObtentionIterations != null) {
            st = new Statement(encryptor, "setKeyObtentionIterations", new Object[]{this.keyObtentionIterations});
            st.execute();
        }
        if (this.passwordSet) {
            st = new Statement(encryptor, "setPassword", new Object[]{this.password});
            st.execute();
        }
        if (this.providerSet) {
            st = new Statement(encryptor, "setProvider", new Object[]{this.provider});
            st.execute();
        }
        if (this.providerNameSet) {
            st = new Statement(encryptor, "setProviderName", new Object[]{this.providerName});
            st.execute();
        }
        if (this.saltGeneratorSet) {
            st = new Statement(encryptor, "setSaltGenerator", new Object[]{this.saltGenerator});
            st.execute();
        }
        if (this.stringOutputTypeSet && encryptor instanceof PBEStringEncryptor) {
            st = new Statement(encryptor, "setStringOutputType", new Object[]{this.stringOutputType});
            st.execute();
        }
        return encryptor;
    }

    public Class<?> getObjectType() {
        if (this.encryptorType == 0) {
            return PBEByteEncryptor.class;
        }
        if (this.encryptorType == 1) {
            return PBEStringEncryptor.class;
        }
        if (this.encryptorType == 2) {
            return PBEBigDecimalEncryptor.class;
        }
        if (this.encryptorType == 3) {
            return PBEBigIntegerEncryptor.class;
        }
        throw new IllegalArgumentException("Unknown encryptor type: " + this.encryptorType);
    }

    private boolean isPooled() {
        if (this.poolSizeSet && this.poolSize != null) {
            return true;
        }
        if (this.configSet && this.config != null) {
            return this.config.getPoolSize() != null;
        }
        return false;
    }
}

