/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.resource;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import javax.activation.FileTypeMap;
import javax.activation.MimetypesFileTypeMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.HttpRequestHandler;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.resource.DefaultResourceResolverChain;
import org.springframework.web.servlet.resource.DefaultResourceTransformerChain;
import org.springframework.web.servlet.resource.EncodedResource;
import org.springframework.web.servlet.resource.PathResourceResolver;
import org.springframework.web.servlet.resource.ResourceResolver;
import org.springframework.web.servlet.resource.ResourceTransformer;
import org.springframework.web.servlet.support.WebContentGenerator;

public class ResourceHttpRequestHandler
extends WebContentGenerator
implements HttpRequestHandler,
InitializingBean {
    private static final String CONTENT_ENCODING = "Content-Encoding";
    private static final Log logger = LogFactory.getLog(ResourceHttpRequestHandler.class);
    private static final boolean jafPresent = ClassUtils.isPresent((String)"javax.activation.FileTypeMap", (ClassLoader)ResourceHttpRequestHandler.class.getClassLoader());
    private final List<Resource> locations = new ArrayList<Resource>(4);
    private final List<ResourceResolver> resourceResolvers = new ArrayList<ResourceResolver>(4);
    private final List<ResourceTransformer> resourceTransformers = new ArrayList<ResourceTransformer>(4);

    public ResourceHttpRequestHandler() {
        super("GET", "HEAD");
        this.resourceResolvers.add(new PathResourceResolver());
    }

    public void setLocations(List<Resource> locations) {
        Assert.notNull(locations, (String)"Locations list must not be null");
        this.locations.clear();
        this.locations.addAll(locations);
    }

    public List<Resource> getLocations() {
        return this.locations;
    }

    public void setResourceResolvers(List<ResourceResolver> resourceResolvers) {
        this.resourceResolvers.clear();
        if (resourceResolvers != null) {
            this.resourceResolvers.addAll(resourceResolvers);
        }
    }

    public List<ResourceResolver> getResourceResolvers() {
        return this.resourceResolvers;
    }

    public void setResourceTransformers(List<ResourceTransformer> resourceTransformers) {
        this.resourceTransformers.clear();
        if (resourceTransformers != null) {
            this.resourceTransformers.addAll(resourceTransformers);
        }
    }

    public List<ResourceTransformer> getResourceTransformers() {
        return this.resourceTransformers;
    }

    public void afterPropertiesSet() throws Exception {
        if (logger.isWarnEnabled() && CollectionUtils.isEmpty(this.locations)) {
            logger.warn((Object)"Locations list is empty. No resources will be served unless a custom ResourceResolver is configured as an alternative to PathResourceResolver.");
        }
        this.initAllowedLocations();
    }

    protected void initAllowedLocations() {
        if (CollectionUtils.isEmpty(this.locations)) {
            return;
        }
        for (int i = this.getResourceResolvers().size() - 1; i >= 0; --i) {
            if (!(this.getResourceResolvers().get(i) instanceof PathResourceResolver)) continue;
            PathResourceResolver pathResolver = (PathResourceResolver)this.getResourceResolvers().get(i);
            if (!ObjectUtils.isEmpty((Object[])pathResolver.getAllowedLocations())) break;
            pathResolver.setAllowedLocations(this.getLocations().toArray(new Resource[this.getLocations().size()]));
            break;
        }
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.checkAndPrepare(request, response, true);
        Resource resource = this.getResource(request);
        if (resource == null) {
            logger.trace((Object)"No matching resource found - returning 404");
            response.sendError(404);
            return;
        }
        MediaType mediaType = this.getMediaType(resource);
        if (mediaType != null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Determined media type '" + mediaType + "' for " + resource));
            }
        } else if (logger.isTraceEnabled()) {
            logger.trace((Object)("No media type found for " + resource + " - not sending a content-type header"));
        }
        if (new ServletWebRequest(request, response).checkNotModified(resource.lastModified())) {
            logger.trace((Object)"Resource not modified - returning 304");
            return;
        }
        this.setHeaders(response, resource, mediaType);
        if ("HEAD".equals(request.getMethod())) {
            logger.trace((Object)"HEAD request - skipping content");
            return;
        }
        this.writeContent(response, resource);
    }

    protected Resource getResource(HttpServletRequest request) throws IOException {
        DefaultResourceResolverChain resolveChain;
        Resource resource;
        String path = (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        if (path == null) {
            throw new IllegalStateException("Required request attribute '" + HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE + "' is not set");
        }
        if (!StringUtils.hasText((String)(path = this.processPath(path))) || this.isInvalidPath(path)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Ignoring invalid resource path [" + path + "]"));
            }
            return null;
        }
        if (path.contains("%")) {
            try {
                if (this.isInvalidPath(URLDecoder.decode(path, "UTF-8"))) {
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Ignoring invalid resource path with escape sequences [" + path + "]."));
                    }
                    return null;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if ((resource = (resolveChain = new DefaultResourceResolverChain(this.getResourceResolvers())).resolveResource(request, path, this.getLocations())) == null || this.getResourceTransformers().isEmpty()) {
            return resource;
        }
        DefaultResourceTransformerChain transformChain = new DefaultResourceTransformerChain(resolveChain, this.getResourceTransformers());
        resource = transformChain.transform(request, resource);
        return resource;
    }

    protected String processPath(String path) {
        boolean slash = false;
        for (int i = 0; i < path.length(); ++i) {
            if (path.charAt(i) == '/') {
                slash = true;
                continue;
            }
            if (path.charAt(i) <= ' ' || path.charAt(i) == '\u007f') continue;
            if (i == 0 || i == 1 && slash) {
                return path;
            }
            String string = path = slash ? "/" + path.substring(i) : path.substring(i);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Path after trimming leading '/' and control characters: " + path));
            }
            return path;
        }
        return slash ? "/" : "";
    }

    protected boolean isInvalidPath(String path) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Applying \"invalid path\" checks to path: " + path));
        }
        if (path.contains("WEB-INF") || path.contains("META-INF")) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Path contains \"WEB-INF\" or \"META-INF\".");
            }
            return true;
        }
        if (path.contains(":/")) {
            String relativePath;
            String string = relativePath = path.charAt(0) == '/' ? path.substring(1) : path;
            if (ResourceUtils.isUrl((String)relativePath) || relativePath.startsWith("url:")) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"Path represents URL or has \"url:\" prefix.");
                }
                return true;
            }
        }
        if (path.contains("../") && (path = StringUtils.cleanPath((String)path)).contains("../")) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Path contains \"../\" after call to StringUtils#cleanPath.");
            }
            return true;
        }
        return false;
    }

    protected MediaType getMediaType(Resource resource) {
        MediaType jafMediaType;
        MediaType mediaType = null;
        String mimeType = this.getServletContext().getMimeType(resource.getFilename());
        if (StringUtils.hasText((String)mimeType)) {
            mediaType = MediaType.parseMediaType((String)mimeType);
        }
        if (jafPresent && (mediaType == null || MediaType.APPLICATION_OCTET_STREAM.equals((Object)mediaType)) && (jafMediaType = ActivationMediaTypeFactory.getMediaType(resource.getFilename())) != null && !MediaType.APPLICATION_OCTET_STREAM.equals((Object)jafMediaType)) {
            mediaType = jafMediaType;
        }
        return mediaType;
    }

    protected void setHeaders(HttpServletResponse response, Resource resource, MediaType mediaType) throws IOException {
        long length = resource.contentLength();
        if (length > Integer.MAX_VALUE) {
            throw new IOException("Resource content too long (beyond Integer.MAX_VALUE): " + resource);
        }
        response.setContentLength((int)length);
        if (mediaType != null) {
            response.setContentType(mediaType.toString());
        }
        if (resource instanceof EncodedResource) {
            response.setHeader(CONTENT_ENCODING, ((EncodedResource)resource).getContentEncoding());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeContent(HttpServletResponse response, Resource resource) throws IOException {
        try {
            InputStream in = resource.getInputStream();
            try {
                StreamUtils.copy((InputStream)in, (OutputStream)response.getOutputStream());
            }
            catch (NullPointerException nullPointerException) {
            }
            finally {
                try {
                    in.close();
                }
                catch (Throwable throwable) {}
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public String toString() {
        return "ResourceHttpRequestHandler [locations=" + this.getLocations() + ", resolvers=" + this.getResourceResolvers() + "]";
    }

    private static class ActivationMediaTypeFactory {
        private static final FileTypeMap fileTypeMap = ActivationMediaTypeFactory.loadFileTypeMapFromContextSupportModule();

        private ActivationMediaTypeFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static FileTypeMap loadFileTypeMapFromContextSupportModule() {
            ClassPathResource mappingLocation = new ClassPathResource("org/springframework/mail/javamail/mime.types");
            if (mappingLocation.exists()) {
                InputStream inputStream = null;
                try {
                    inputStream = mappingLocation.getInputStream();
                    MimetypesFileTypeMap mimetypesFileTypeMap = new MimetypesFileTypeMap(inputStream);
                    return mimetypesFileTypeMap;
                }
                catch (IOException iOException) {
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            return FileTypeMap.getDefaultFileTypeMap();
        }

        public static MediaType getMediaType(String filename) {
            String mediaType = fileTypeMap.getContentType(filename);
            return StringUtils.hasText((String)mediaType) ? MediaType.parseMediaType((String)mediaType) : null;
        }
    }
}

