<?php
/**
 * @file
 * Template for a VEVENT file.
 */

/**
 * $event
 *   An array with the following information about each event:
 *
 *   $event['uid'] - a unique id for the event (usually the url).
 *   $event['summary'] - the name of the event.
 *   $event['start'] - the formatted start date of the event.
 *   $event['end'] - the formatted end date of the event.
 *   $event['rrule'] - the RRULE of the event, if any.
 *   $event['timezone'] - the formatted timezone name of the event, if any.
 *   $event['url'] - the url for the event.
 *   $event['location'] - the name of the event location, or a vvenue location id.
 *   $event['description'] - a description of the event.
 *   $event['alarm'] - an optional array of alarm values.
 *    @see date-valarm.tpl.php.
 *
 * If you are editing this file, remember that all output lines generated by it
 * must end with DOS-style \r\n line endings, and not Unix-style \n, in order to
 * comply with the iCal spec: http://tools.ietf.org/html/rfc5545#section-3.1.
 */
print "BEGIN:VEVENT\r\n";
print "UID:" . $event['uid'] . "\r\n";
print "SUMMARY:" . $event['summary'] . "\r\n";
print "DTSTAMP:" . $site_timezone_utc . "Z\r\n";
print "DTSTART;" . $event['timezone'] . $event['start'] . "\r\n";
if (!empty($event['end'])):
  print "DTEND;" . $event['timezone'] . $event['end'] . "\r\n";
endif;
if (!empty($event['rrule'])):
  print $event['rrule'] . "\r\n";
endif;
if (!empty($event['url'])):
  print "URL;VALUE=URI:" . $event['url'] . "\r\n";
endif;
if (!empty($event['location'])):
  print "LOCATION:" . $event['location'] . "\r\n";
endif;
if (!empty($event['description'])):
  print "DESCRIPTION:" . $event['description'] . "\r\n";
endif;
print "END:VEVENT\r\n";
