/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.ba.BasicBlock;
import org.apache.bcel.generic.InstructionHandle;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Location
implements Comparable<Location> {
    private final InstructionHandle handle;
    private final BasicBlock basicBlock;

    public Location(@NonNull InstructionHandle handle, @NonNull BasicBlock basicBlock) {
        if (handle == null) {
            throw new NullPointerException("handle cannot be null");
        }
        if (basicBlock == null) {
            throw new NullPointerException("basicBlock cannot be null");
        }
        this.handle = handle;
        this.basicBlock = basicBlock;
    }

    public static Location getFirstLocation(@NonNull BasicBlock basicBlock) {
        InstructionHandle location = basicBlock.getFirstInstruction();
        if (location == null) {
            return null;
        }
        return new Location(location, basicBlock);
    }

    public static Location getLastLocation(@NonNull BasicBlock basicBlock) {
        InstructionHandle lastInstruction = basicBlock.getLastInstruction();
        if (lastInstruction == null) {
            return null;
        }
        return new Location(lastInstruction, basicBlock);
    }

    public InstructionHandle getHandle() {
        return this.handle;
    }

    public BasicBlock getBasicBlock() {
        return this.basicBlock;
    }

    public boolean isFirstInstructionInBasicBlock() {
        return !this.basicBlock.isEmpty() && this.handle == this.basicBlock.getFirstInstruction();
    }

    public boolean isLastInstructionInBasicBlock() {
        return !this.basicBlock.isEmpty() && this.handle == this.basicBlock.getLastInstruction();
    }

    @Override
    public int compareTo(Location other) {
        int cmp = this.basicBlock.getId() - other.basicBlock.getId();
        int pos = this.handle.getPosition() - other.handle.getPosition();
        if (pos != 0) {
            return pos;
        }
        return cmp;
    }

    public int hashCode() {
        return System.identityHashCode(this.basicBlock) + this.handle.getPosition();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Location)) {
            return false;
        }
        Location other = (Location)o;
        return this.basicBlock == other.basicBlock && this.handle == other.handle;
    }

    public String toString() {
        return new StringBuffer().append(this.handle.toString()).append(" in basic block ").append(this.basicBlock.getId()).toString();
    }

    @Override
    public /* synthetic */ int compareTo(Object x0) {
        return this.compareTo((Location)x0);
    }
}

