/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.engine;

import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.FieldDescriptor;
import edu.umd.cs.findbugs.classfile.ICodeBaseEntry;
import edu.umd.cs.findbugs.classfile.InvalidClassFileFormatException;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.classfile.analysis.ClassInfo;
import edu.umd.cs.findbugs.classfile.analysis.ClassNameAndSuperclassInfo;
import edu.umd.cs.findbugs.util.ClassName;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.TreeSet;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassParser {
    private DataInputStream in;
    private ClassDescriptor expectedClassDescriptor;
    private ICodeBaseEntry codeBaseEntry;
    private Constant[] constantPool;
    private static final String[] CONSTANT_FORMAT_MAP = new String[]{null, "8", null, "I", "F", "L", "D", "i", "i", "ii", "ii", "ii", "ii"};

    public ClassParser(DataInputStream in, ClassDescriptor expectedClassDescriptor, ICodeBaseEntry codeBaseEntry) {
        this.in = in;
        this.expectedClassDescriptor = expectedClassDescriptor;
        this.codeBaseEntry = codeBaseEntry;
    }

    public void parse(ClassNameAndSuperclassInfo classInfo) throws InvalidClassFileFormatException {
        try {
            int magic = this.in.readInt();
            int major_version = this.in.readUnsignedShort();
            int minor_version = this.in.readUnsignedShort();
            int constant_pool_count = this.in.readUnsignedShort();
            this.constantPool = new Constant[constant_pool_count];
            for (int i = 1; i < this.constantPool.length; ++i) {
                this.constantPool[i] = this.readConstant();
                if (this.constantPool[i].tag != 6 && this.constantPool[i].tag != 5) continue;
                ++i;
            }
            int access_flags = this.in.readUnsignedShort();
            int this_class = this.in.readUnsignedShort();
            ClassDescriptor thisClassDescriptor = this.getClassDescriptor(this_class);
            int super_class = this.in.readUnsignedShort();
            ClassDescriptor superClassDescriptor = this.getClassDescriptor(super_class);
            int interfaces_count = this.in.readUnsignedShort();
            if (interfaces_count < 0) {
                throw new InvalidClassFileFormatException(this.expectedClassDescriptor, this.codeBaseEntry);
            }
            ClassDescriptor[] interfaceDescriptorList = new ClassDescriptor[interfaces_count];
            for (int i = 0; i < interfaceDescriptorList.length; ++i) {
                interfaceDescriptorList[i] = this.getClassDescriptor(this.in.readUnsignedShort());
            }
            classInfo.setClassDescriptor(thisClassDescriptor);
            classInfo.setSuperclassDescriptor(superClassDescriptor);
            classInfo.setInterfaceDescriptorList(interfaceDescriptorList);
            classInfo.setCodeBaseEntry(this.codeBaseEntry);
            classInfo.setAccessFlags(access_flags);
        }
        catch (IOException e) {
            throw new InvalidClassFileFormatException(this.expectedClassDescriptor, this.codeBaseEntry, e);
        }
    }

    public void parse(ClassInfo classInfo) throws InvalidClassFileFormatException {
        this.parse((ClassNameAndSuperclassInfo)classInfo);
        try {
            int fields_count = this.in.readUnsignedShort();
            if (fields_count < 0) {
                throw new InvalidClassFileFormatException(this.expectedClassDescriptor, this.codeBaseEntry);
            }
            FieldDescriptor[] fieldDescriptorList = new FieldDescriptor[fields_count];
            for (int i = 0; i < fields_count; ++i) {
                fieldDescriptorList[i] = this.readField(classInfo.getClassDescriptor());
            }
            int methods_count = this.in.readUnsignedShort();
            if (methods_count < 0) {
                throw new InvalidClassFileFormatException(this.expectedClassDescriptor, this.codeBaseEntry);
            }
            MethodDescriptor[] methodDescriptorList = new MethodDescriptor[methods_count];
            for (int i = 0; i < methods_count; ++i) {
                methodDescriptorList[i] = this.readMethod(classInfo.getClassDescriptor());
            }
            ClassDescriptor[] referencedClassDescriptorList = this.extractReferencedClasses();
            classInfo.setFieldDescriptorList(fieldDescriptorList);
            classInfo.setMethodDescriptorList(methodDescriptorList);
            classInfo.setReferencedClassDescriptorList(referencedClassDescriptorList);
        }
        catch (IOException e) {
            throw new InvalidClassFileFormatException(this.expectedClassDescriptor, this.codeBaseEntry, e);
        }
    }

    private ClassDescriptor[] extractReferencedClasses() throws InvalidClassFileFormatException {
        TreeSet<ClassDescriptor> referencedClassSet = new TreeSet<ClassDescriptor>();
        for (Constant constant : this.constantPool) {
            String className;
            if (constant == null) continue;
            if (constant.tag == 7) {
                className = this.getUtf8String((Integer)constant.data[0]);
                if (className.indexOf(91) >= 0) {
                    this.extractReferencedClassesFromSignature(referencedClassSet, className);
                    continue;
                }
                if (!ClassName.isValidClassName(className)) continue;
                referencedClassSet.add(new ClassDescriptor(className));
                continue;
            }
            if (constant.tag != 10 && constant.tag != 9 && constant.tag != 11) continue;
            className = this.getClassName((Integer)constant.data[0]);
            this.extractReferencedClassesFromSignature(referencedClassSet, className);
            String signature = this.getSignatureFromNameAndType((Integer)constant.data[1]);
            this.extractReferencedClassesFromSignature(referencedClassSet, signature);
        }
        ClassDescriptor[] referencedClassDescriptorList = referencedClassSet.toArray(new ClassDescriptor[referencedClassSet.size()]);
        return referencedClassDescriptorList;
    }

    private void extractReferencedClassesFromSignature(TreeSet<ClassDescriptor> referencedClassSet, String signature) {
        int end;
        int start;
        while (signature.length() > 0 && (start = signature.indexOf(76)) >= 0 && (end = (signature = signature.substring(start)).indexOf(59)) >= 0) {
            String className = signature.substring(1, end);
            if (ClassName.isValidClassName(className)) {
                referencedClassSet.add(new ClassDescriptor(className));
            }
            signature = signature.substring(end + 1);
        }
    }

    private Constant readConstant() throws InvalidClassFileFormatException, IOException {
        int tag = this.in.readUnsignedByte();
        if (tag < 0 || tag >= CONSTANT_FORMAT_MAP.length || CONSTANT_FORMAT_MAP[tag] == null) {
            throw new InvalidClassFileFormatException(this.expectedClassDescriptor, this.codeBaseEntry);
        }
        String format = CONSTANT_FORMAT_MAP[tag];
        Object[] data = new Object[format.length()];
        block8: for (int i = 0; i < format.length(); ++i) {
            char spec = format.charAt(i);
            switch (spec) {
                case '8': {
                    data[i] = this.in.readUTF();
                    continue block8;
                }
                case 'I': {
                    data[i] = new Integer(this.in.readInt());
                    continue block8;
                }
                case 'F': {
                    data[i] = new Float(this.in.readFloat());
                    continue block8;
                }
                case 'L': {
                    data[i] = new Long(this.in.readLong());
                    continue block8;
                }
                case 'D': {
                    data[i] = new Double(this.in.readDouble());
                    continue block8;
                }
                case 'i': {
                    data[i] = new Integer(this.in.readUnsignedShort());
                    continue block8;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return new Constant(tag, data);
    }

    private String getClassName(int index) throws InvalidClassFileFormatException {
        if (index == 0) {
            return null;
        }
        this.checkConstantPoolIndex(index);
        Constant constant = this.constantPool[index];
        this.checkConstantTag(constant, 7);
        int refIndex = (Integer)constant.data[0];
        String stringValue = this.getUtf8String(refIndex);
        return stringValue;
    }

    private ClassDescriptor getClassDescriptor(int index) throws InvalidClassFileFormatException {
        String className = this.getClassName(index);
        return className != null ? new ClassDescriptor(className) : null;
    }

    private String getUtf8String(int refIndex) throws InvalidClassFileFormatException {
        this.checkConstantPoolIndex(refIndex);
        Constant refConstant = this.constantPool[refIndex];
        this.checkConstantTag(refConstant, 1);
        return (String)refConstant.data[0];
    }

    private void checkConstantPoolIndex(int index) throws InvalidClassFileFormatException {
        if (index < 0 || index >= this.constantPool.length || this.constantPool[index] == null) {
            throw new InvalidClassFileFormatException(this.expectedClassDescriptor, this.codeBaseEntry);
        }
    }

    private void checkConstantTag(Constant constant, int expectedTag) throws InvalidClassFileFormatException {
        if (constant.tag != expectedTag) {
            throw new InvalidClassFileFormatException(this.expectedClassDescriptor, this.codeBaseEntry);
        }
    }

    private FieldDescriptor readField(ClassDescriptor thisClassDescriptor) throws IOException, InvalidClassFileFormatException {
        return this.readFieldOrMethod(thisClassDescriptor, new FieldOrMethodDescriptorCreator<FieldDescriptor>(){

            @Override
            public FieldDescriptor create(String className, String name, String signature, int accessFlags) {
                return new FieldDescriptor(className, name, signature, (accessFlags & 8) != 0);
            }

            @Override
            public /* synthetic */ Object create(String x0, String x1, String x2, int x3) {
                return this.create(x0, x1, x2, x3);
            }
        });
    }

    private MethodDescriptor readMethod(ClassDescriptor thisClassDescriptor) throws InvalidClassFileFormatException, IOException {
        return this.readFieldOrMethod(thisClassDescriptor, new FieldOrMethodDescriptorCreator<MethodDescriptor>(){

            @Override
            public MethodDescriptor create(String className, String name, String signature, int accessFlags) {
                return new MethodDescriptor(className, name, signature, (accessFlags & 8) != 0);
            }

            @Override
            public /* synthetic */ Object create(String x0, String x1, String x2, int x3) {
                return this.create(x0, x1, x2, x3);
            }
        });
    }

    private <E> E readFieldOrMethod(ClassDescriptor thisClassDescriptor, FieldOrMethodDescriptorCreator<E> creator) throws IOException, InvalidClassFileFormatException {
        int access_flags = this.in.readUnsignedShort();
        int name_index = this.in.readUnsignedShort();
        int descriptor_index = this.in.readUnsignedShort();
        int attributes_count = this.in.readUnsignedShort();
        String name = this.getUtf8String(name_index);
        String signature = this.getUtf8String(descriptor_index);
        if (attributes_count < 0) {
            throw new InvalidClassFileFormatException(this.expectedClassDescriptor, this.codeBaseEntry);
        }
        for (int i = 0; i < attributes_count; ++i) {
            this.readAttribute();
        }
        return creator.create(thisClassDescriptor.getClassName(), name, signature, access_flags);
    }

    private void readAttribute() throws IOException, InvalidClassFileFormatException {
        int attribute_name_index = this.in.readUnsignedShort();
        int attribute_length = this.in.readInt();
        if (attribute_length < 0) {
            throw new InvalidClassFileFormatException(this.expectedClassDescriptor, this.codeBaseEntry);
        }
        byte[] buf = new byte[attribute_length];
        this.in.readFully(buf);
    }

    private String getSignatureFromNameAndType(int index) throws InvalidClassFileFormatException {
        this.checkConstantPoolIndex(index);
        Constant constant = this.constantPool[index];
        this.checkConstantTag(constant, 12);
        return this.getUtf8String((Integer)constant.data[1]);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface FieldOrMethodDescriptorCreator<E> {
        public E create(String var1, String var2, String var3, int var4);
    }

    static class Constant {
        int tag;
        Object[] data;

        Constant(int tag, Object[] data) {
            this.tag = tag;
            this.data = data;
        }
    }
}

