/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.version;

import fr.jayasoft.ivy.Ivy;
import fr.jayasoft.ivy.ModuleRevisionId;
import fr.jayasoft.ivy.matcher.Matcher;
import fr.jayasoft.ivy.matcher.PatternMatcher;
import fr.jayasoft.ivy.util.IvyPatternHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

public class Match {
    private String _revision;
    private String _pattern;
    private String _args;
    private String _matcher;

    public String getArgs() {
        return this._args;
    }

    public void setArgs(String args) {
        this._args = args;
    }

    public String getMatcher() {
        return this._matcher;
    }

    public void setMatcher(String matcher) {
        this._matcher = matcher;
    }

    public String getPattern() {
        return this._pattern;
    }

    public void setPattern(String pattern) {
        this._pattern = pattern;
    }

    public String getRevision() {
        return this._revision;
    }

    public void setRevision(String revision) {
        this._revision = revision;
    }

    public Matcher getPatternMatcher(ModuleRevisionId askedMrid) {
        String[] argValues;
        String revision = askedMrid.getRevision();
        String[] args = Match.split(this.getArgs());
        if (args.length != (argValues = this.getRevisionArgs(revision)).length) {
            return new NoMatchMatcher();
        }
        HashMap<String, String> variables = new HashMap<String, String>();
        for (int i = 0; i < args.length; ++i) {
            variables.put(args[i], argValues[i]);
        }
        String pattern = this.getPattern();
        pattern = IvyPatternHelper.substituteVariables(pattern, variables);
        PatternMatcher pMatcher = Ivy.getCurrent().getMatcher(this._matcher);
        return pMatcher.getMatcher(pattern);
    }

    private String[] getRevisionArgs(String revision) {
        int bracketStartIndex = revision.indexOf(40);
        if (bracketStartIndex == -1) {
            return new String[0];
        }
        int bracketEndIndex = revision.indexOf(41);
        if (bracketEndIndex <= bracketStartIndex + 1) {
            return new String[0];
        }
        String args = revision.substring(bracketStartIndex + 1, bracketEndIndex);
        return Match.split(args);
    }

    private static String[] split(String string) {
        if (string == null) {
            return new String[0];
        }
        StringTokenizer tokenizer = new StringTokenizer(string, ", ");
        ArrayList<String> tokens = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextToken());
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    private static class NoMatchMatcher
    implements Matcher {
        private NoMatchMatcher() {
        }

        public boolean isExact() {
            return false;
        }

        public boolean matches(String str) {
            return false;
        }
    }
}

