/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.ui.text;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.DefaultPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditorPreferences;
import org.rubypeople.rdt.internal.ui.text.RubyColorManager;
import org.rubypeople.rdt.internal.ui.text.RubyCommentScanner;
import org.rubypeople.rdt.internal.ui.text.RubyPartitionScanner;
import org.rubypeople.rdt.internal.ui.text.ruby.AbstractRubyScanner;
import org.rubypeople.rdt.internal.ui.text.ruby.RubyCodeScanner;
import org.rubypeople.rdt.internal.ui.text.ruby.SingleTokenRubyCodeScanner;
import org.rubypeople.rdt.ui.text.IColorManager;

public class RubyTextTools {
    protected static String[] keywords;
    protected RubyColorManager fColorManager;
    protected RubyPartitionScanner partitionScanner;
    protected AbstractRubyScanner fCodeScanner;
    protected AbstractRubyScanner fMultilineCommentScanner;
    protected AbstractRubyScanner fSinglelineCommentScanner;
    protected AbstractRubyScanner stringScanner;
    private IPreferenceStore fPreferenceStore;
    private Preferences fCorePreferenceStore;
    private PreferenceListener fPreferenceListener = new PreferenceListener();
    private SingleTokenRubyCodeScanner fRegexpScanner;
    private SingleTokenRubyCodeScanner fCommandScanner;

    public RubyTextTools(IPreferenceStore iPreferenceStore, Preferences preferences) {
        this(iPreferenceStore, preferences, true);
    }

    public RubyTextTools(IPreferenceStore iPreferenceStore, Preferences preferences, boolean bl) {
        this.fColorManager = new RubyColorManager(bl);
        this.partitionScanner = new RubyPartitionScanner();
        this.fCodeScanner = new RubyCodeScanner(this.fColorManager, iPreferenceStore);
        this.fMultilineCommentScanner = new RubyCommentScanner(this.fColorManager, iPreferenceStore, preferences, "color_ruby_multiline_comment");
        this.fSinglelineCommentScanner = new RubyCommentScanner(this.fColorManager, iPreferenceStore, preferences, "color_ruby_singleline_comment");
        this.stringScanner = new SingleTokenRubyCodeScanner(this.fColorManager, iPreferenceStore, "color_ruby_string");
        this.fRegexpScanner = new SingleTokenRubyCodeScanner(this.fColorManager, iPreferenceStore, "color_ruby_regexp");
        this.fCommandScanner = new SingleTokenRubyCodeScanner(this.fColorManager, iPreferenceStore, "color_ruby_command");
        this.fPreferenceStore = iPreferenceStore;
        this.fPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
        this.fCorePreferenceStore = preferences;
        if (this.fCorePreferenceStore != null) {
            this.fCorePreferenceStore.addPropertyChangeListener((Preferences.IPropertyChangeListener)this.fPreferenceListener);
        }
    }

    protected void adaptToPreferenceChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.fCodeScanner.affectsBehavior(propertyChangeEvent)) {
            this.fCodeScanner.adaptToPreferenceChange(propertyChangeEvent);
        }
        if (this.fMultilineCommentScanner.affectsBehavior(propertyChangeEvent)) {
            this.fMultilineCommentScanner.adaptToPreferenceChange(propertyChangeEvent);
        }
        if (this.fSinglelineCommentScanner.affectsBehavior(propertyChangeEvent)) {
            this.fSinglelineCommentScanner.adaptToPreferenceChange(propertyChangeEvent);
        }
        if (this.stringScanner.affectsBehavior(propertyChangeEvent)) {
            this.stringScanner.adaptToPreferenceChange(propertyChangeEvent);
        }
        if (this.fRegexpScanner.affectsBehavior(propertyChangeEvent)) {
            this.fRegexpScanner.adaptToPreferenceChange(propertyChangeEvent);
        }
        if (this.fCommandScanner.affectsBehavior(propertyChangeEvent)) {
            this.fCommandScanner.adaptToPreferenceChange(propertyChangeEvent);
        }
    }

    public IDocumentPartitioner createDocumentPartitioner() {
        return new DefaultPartitioner(this.getPartitionScanner(), RubyPartitionScanner.LEGAL_CONTENT_TYPES);
    }

    protected IPartitionTokenScanner getPartitionScanner() {
        return this.partitionScanner;
    }

    public AbstractRubyScanner getCodeScanner() {
        return this.fCodeScanner;
    }

    public ITokenScanner getMultilineCommentScanner() {
        return this.fMultilineCommentScanner;
    }

    public ITokenScanner getSinglelineCommentScanner() {
        return this.fSinglelineCommentScanner;
    }

    public ITokenScanner getStringScanner() {
        return this.stringScanner;
    }

    public IPreferenceStore getPreferenceStore() {
        return RubyPlugin.getDefault().getPreferenceStore();
    }

    public static String[] getKeyWords() {
        if (keywords == null) {
            String string = RubyEditorPreferences.getString("keywords");
            ArrayList<String> arrayList = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            keywords = new String[arrayList.size()];
            arrayList.toArray(keywords);
        }
        return keywords;
    }

    public boolean affectsTextPresentation(PropertyChangeEvent propertyChangeEvent) {
        return this.fCodeScanner.affectsBehavior(propertyChangeEvent) || this.fMultilineCommentScanner.affectsBehavior(propertyChangeEvent) || this.fSinglelineCommentScanner.affectsBehavior(propertyChangeEvent) || this.stringScanner.affectsBehavior(propertyChangeEvent) || this.fRegexpScanner.affectsBehavior(propertyChangeEvent) || this.fCommandScanner.affectsBehavior(propertyChangeEvent);
    }

    public void setupRubyDocumentPartitioner(IDocument iDocument, String string) {
        IDocumentPartitioner iDocumentPartitioner = this.createDocumentPartitioner();
        if (iDocument instanceof IDocumentExtension3) {
            IDocumentExtension3 iDocumentExtension3 = (IDocumentExtension3)iDocument;
            iDocumentExtension3.setDocumentPartitioner(string, iDocumentPartitioner);
        } else {
            iDocument.setDocumentPartitioner(iDocumentPartitioner);
        }
        iDocumentPartitioner.connect(iDocument);
    }

    public void dispose() {
        this.fCodeScanner = null;
        this.fMultilineCommentScanner = null;
        this.fSinglelineCommentScanner = null;
        this.stringScanner = null;
        this.fRegexpScanner = null;
        this.fCommandScanner = null;
        this.partitionScanner = null;
        if (this.fColorManager != null) {
            this.fColorManager.dispose();
            this.fColorManager = null;
        }
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.removePropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
            this.fPreferenceStore = null;
            if (this.fCorePreferenceStore != null) {
                this.fCorePreferenceStore.removePropertyChangeListener((Preferences.IPropertyChangeListener)this.fPreferenceListener);
                this.fCorePreferenceStore = null;
            }
            this.fPreferenceListener = null;
        }
    }

    public ITokenScanner getRegexpScanner() {
        return this.fRegexpScanner;
    }

    public ITokenScanner getCommandScanner() {
        return this.fCommandScanner;
    }

    public IColorManager getColorManager() {
        return this.fColorManager;
    }

    public Preferences getCorePreferenceStore() {
        return this.fCorePreferenceStore;
    }

    public void setupRubyDocumentPartitioner(IDocument iDocument) {
        this.setupRubyDocumentPartitioner(iDocument, "__dftl_partitioning");
    }

    private class PreferenceListener
    implements IPropertyChangeListener,
    Preferences.IPropertyChangeListener {
        PreferenceListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            RubyTextTools.this.adaptToPreferenceChange(propertyChangeEvent);
        }

        public void propertyChange(Preferences.PropertyChangeEvent propertyChangeEvent) {
            RubyTextTools.this.adaptToPreferenceChange(new PropertyChangeEvent(propertyChangeEvent.getSource(), propertyChangeEvent.getProperty(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue()));
        }
    }
}

