/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards;

import java.text.ParseException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.tigris.subversion.subclipse.core.ISVNRemoteFolder;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.history.ILogEntry;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.dialogs.HistoryDialog;
import org.tigris.subversion.subclipse.ui.wizards.CheckoutWizard;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class CheckoutWizardCheckoutAsMultiplePage
extends WizardPage {
    private Label textLabel;
    private Button projectsButton;
    private Button existingButton;
    private Text revisionText;
    private Button headButton;
    private Button revisionButton;
    private static final int REVISION_WIDTH_HINT = 40;

    public CheckoutWizardCheckoutAsMultiplePage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        CheckoutWizard wizard = (CheckoutWizard)this.getWizard();
        Composite outerContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        outerContainer.setLayout((Layout)layout);
        outerContainer.setLayoutData((Object)new GridData(768));
        this.textLabel = new Label(outerContainer, 0);
        GridData data = new GridData();
        data.widthHint = 300;
        this.textLabel.setLayoutData((Object)data);
        if (wizard.getRemoteFolders() != null) {
            this.textLabel.setText(Policy.bind("CheckoutWizardCheckoutAsPage.multiple", Integer.toString(wizard.getRemoteFolders().length)));
        }
        this.projectsButton = new Button(outerContainer, 16);
        this.projectsButton.setText(Policy.bind("CheckoutWizardCheckoutAsPage.projects"));
        this.existingButton = new Button(outerContainer, 16);
        this.existingButton.setText(Policy.bind("CheckoutWizardCheckoutAsPage.existing"));
        this.existingButton.setEnabled(false);
        this.existingButton.setVisible(false);
        this.projectsButton.setSelection(true);
        Group revisionGroup = new Group(outerContainer, 0);
        revisionGroup.setText(Policy.bind("CheckoutWizardProjectPage.revision"));
        GridLayout revisionLayout = new GridLayout();
        revisionLayout.numColumns = 3;
        revisionGroup.setLayout((Layout)revisionLayout);
        data = new GridData(1808);
        revisionGroup.setLayoutData((Object)data);
        this.headButton = new Button((Composite)revisionGroup, 16);
        this.headButton.setText(Policy.bind("SwitchDialog.head"));
        data = new GridData();
        data.horizontalSpan = 3;
        this.headButton.setLayoutData((Object)data);
        this.revisionButton = new Button((Composite)revisionGroup, 16);
        this.revisionButton.setText(Policy.bind("SwitchDialog.revision"));
        this.headButton.setSelection(true);
        this.revisionText = new Text((Composite)revisionGroup, 2048);
        data = new GridData();
        data.widthHint = 40;
        this.revisionText.setLayoutData((Object)data);
        this.revisionText.setEnabled(false);
        Button logButton = new Button((Composite)revisionGroup, 8);
        logButton.setText(Policy.bind("MergeDialog.showLog"));
        logButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckoutWizardCheckoutAsMultiplePage.this.showLog();
            }
        });
        SelectionAdapter revisionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckoutWizardCheckoutAsMultiplePage.this.revisionText.setEnabled(CheckoutWizardCheckoutAsMultiplePage.this.revisionButton.getSelection());
                if (CheckoutWizardCheckoutAsMultiplePage.this.revisionButton.getSelection()) {
                    CheckoutWizardCheckoutAsMultiplePage.this.revisionText.selectAll();
                    CheckoutWizardCheckoutAsMultiplePage.this.revisionText.setFocus();
                }
            }
        };
        this.headButton.addSelectionListener((SelectionListener)revisionListener);
        this.revisionButton.addSelectionListener((SelectionListener)revisionListener);
        this.setMessage(Policy.bind("CheckoutWizardCheckoutAsPage.text"));
        this.setControl((Control)outerContainer);
    }

    public void setText(String text) {
        this.textLabel.setText(text);
    }

    private void showLog() {
        HistoryDialog dialog = new HistoryDialog(this.getShell(), this.getCommonParent());
        if (dialog.open() == 1) {
            return;
        }
        ILogEntry[] selectedEntries = dialog.getSelectedLogEntries();
        if (selectedEntries.length == 0) {
            return;
        }
        this.revisionText.setText(Long.toString(selectedEntries[0].getRevision().getNumber()));
        this.revisionButton.setSelection(true);
        this.revisionText.setEnabled(true);
        this.headButton.setSelection(false);
    }

    private ISVNRemoteResource getCommonParent() {
        ISVNRemoteFolder[] remoteFolders = ((CheckoutWizard)this.getWizard()).getRemoteFolders();
        if (remoteFolders.length == 1) {
            return remoteFolders[0];
        }
        ISVNRemoteFolder commonParent = null;
        ISVNRemoteFolder parent = remoteFolders[0];
        while (commonParent == null) {
            if ((parent = parent.getParent()) == null) break;
            int i = 1;
            while (i < remoteFolders.length) {
                if (!remoteFolders[i].getUrl().toString().startsWith(parent.getUrl().toString())) break;
                ++i;
            }
            commonParent = parent;
        }
        return commonParent;
    }

    public SVNRevision getRevision() {
        if (this.headButton.getSelection()) {
            return SVNRevision.HEAD;
        }
        SVNRevision svnRevision = null;
        try {
            svnRevision = SVNRevision.getRevision((String)this.revisionText.getText().trim());
        }
        catch (ParseException parseException) {}
        if (svnRevision == null) {
            return SVNRevision.HEAD;
        }
        return svnRevision;
    }
}

