/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.core.internal;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.server.core.internal.JavaServerPlugin;
import org.eclipse.jst.server.core.internal.Messages;
import org.eclipse.jst.server.core.internal.RuntimeClasspathContainer;
import org.eclipse.jst.server.core.internal.RuntimeClasspathContainerInitializer;
import org.eclipse.jst.server.core.internal.RuntimeClasspathProviderWrapper;
import org.eclipse.jst.server.core.internal.Trace;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerCore;

public class RuntimeClasspathContainerInitializer
extends ClasspathContainerInitializer {
    public void initialize(IPath containerPath, IJavaProject project) throws CoreException {
        if (containerPath.segmentCount() > 0 && containerPath.segment(0).equals("org.eclipse.jst.server.core.container")) {
            RuntimeClasspathProviderWrapper delegate = null;
            IRuntime runtime = null;
            String runtimeId = null;
            if (containerPath.segmentCount() > 2) {
                delegate = JavaServerPlugin.findRuntimeClasspathProvider(containerPath.segment(1));
                runtimeId = containerPath.segment(2);
                if (runtimeId != null) {
                    runtime = ServerCore.findRuntime((String)runtimeId);
                }
            }
            RuntimeClasspathContainer container = new RuntimeClasspathContainer(project.getProject(), containerPath, delegate, runtime, runtimeId);
            JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{container}, null);
        }
    }

    public String getDescription(IPath containerPath, IJavaProject project) {
        return Messages.classpathContainerDescription;
    }

    public boolean canUpdateClasspathContainer(IPath containerPath, IJavaProject project) {
        return true;
    }

    public void requestClasspathContainerUpdate(IPath containerPath, IJavaProject project, IClasspathContainer containerSuggestion) throws CoreException {
        if (containerPath.segmentCount() > 0 && containerPath.segment(0).equals("org.eclipse.jst.server.core.container")) {
            RuntimeClasspathProviderWrapper delegate = null;
            IRuntime runtime = null;
            if (containerPath.segmentCount() > 2) {
                delegate = JavaServerPlugin.findRuntimeClasspathProvider(containerPath.segment(1));
                String runtimeId = containerPath.segment(2);
                if (runtimeId != null) {
                    runtime = ServerCore.findRuntime((String)runtimeId);
                }
                delegate.requestClasspathContainerUpdate(runtime, containerSuggestion.getClasspathEntries());
                this.updateClasspath(runtime, containerPath, containerSuggestion);
            }
        }
    }

    private void updateClasspath(IRuntime runtime, IPath containerPath, IClasspathContainer containerSuggestion) {
        class UpdateClasspathJob
        extends Job {
            final /* synthetic */ RuntimeClasspathContainerInitializer this$0;
            private final /* synthetic */ IPath val$containerPath;
            private final /* synthetic */ IClasspathContainer val$containerSuggestion;

            public UpdateClasspathJob(RuntimeClasspathContainerInitializer runtimeClasspathContainerInitializer, IRuntime iRuntime, IPath iPath, IClasspathContainer iClasspathContainer) {
                super(NLS.bind((String)Messages.updateClasspathContainers, (Object)iRuntime.getName()));
                this.this$0 = runtimeClasspathContainerInitializer;
                this.val$containerPath = iPath;
                this.val$containerSuggestion = iClasspathContainer;
            }

            public boolean belongsTo(Object family) {
                return "org.eclipse.wst.server.core".equals(family);
            }

            public IStatus run(IProgressMonitor monitor) {
                int size;
                IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                ArrayList<IJavaProject> list = new ArrayList<IJavaProject>();
                if (projects != null) {
                    size = projects.length;
                    int i = 0;
                    while (i < size) {
                        if (projects[i].isAccessible()) {
                            try {
                                if (projects[i].isNatureEnabled("org.eclipse.jdt.core.javanature")) {
                                    IJavaProject javaProject = JavaCore.create((IProject)projects[i]);
                                    boolean found = false;
                                    IClasspathEntry[] ce = javaProject.getRawClasspath();
                                    int j = 0;
                                    while (j < ce.length) {
                                        if (ce[j].getEntryKind() == 5 && this.val$containerPath.isPrefixOf(ce[j].getPath())) {
                                            found = true;
                                        }
                                        ++j;
                                    }
                                    Trace.trace(Trace.FINEST, "Classpath change on: " + projects[i] + " " + found);
                                    if (found) {
                                        list.add(javaProject);
                                    }
                                }
                            }
                            catch (Exception e) {
                                Trace.trace(Trace.SEVERE, "Could not update classpath container", e);
                            }
                        }
                        ++i;
                    }
                }
                if ((size = list.size()) > 0) {
                    IJavaProject[] javaProjects = new IJavaProject[size];
                    list.toArray(javaProjects);
                    IClasspathContainer[] containers = new IClasspathContainer[size];
                    int i = 0;
                    while (i < size) {
                        containers[i] = this.val$containerSuggestion;
                        ++i;
                    }
                    try {
                        JavaCore.setClasspathContainer((IPath)this.val$containerPath, (IJavaProject[])javaProjects, (IClasspathContainer[])containers, (IProgressMonitor)monitor);
                    }
                    catch (JavaModelException jme) {
                        return jme.getStatus();
                    }
                }
                return Status.OK_STATUS;
            }
        }
        UpdateClasspathJob job = new UpdateClasspathJob(this, runtime, containerPath, containerSuggestion);
        job.schedule();
    }

    public Object getComparisonID(IPath containerPath, IJavaProject project) {
        if (containerPath == null) {
            return null;
        }
        return containerPath.toPortableString();
    }
}

