/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.java.adapters.jdk;

import java.util.Iterator;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.jem.internal.java.adapters.JavaReflectionAdapterFactory;
import org.eclipse.jem.internal.java.adapters.ReflectionAdaptor;
import org.eclipse.jem.internal.java.adapters.jdk.JavaClassJDKAdaptor;
import org.eclipse.jem.internal.java.adapters.jdk.JavaFieldJDKAdaptor;
import org.eclipse.jem.internal.java.adapters.jdk.JavaMethodJDKAdaptor;

public class JavaJDKAdapterFactory
extends JavaReflectionAdapterFactory {
    protected ClassLoader contextClassLoader;

    public JavaJDKAdapterFactory() {
    }

    public JavaJDKAdapterFactory(ClassLoader aClassLoader) {
        this();
        this.setContextClassLoader(aClassLoader);
    }

    protected ReflectionAdaptor createJavaClassAdaptor(Notifier target) {
        return new JavaClassJDKAdaptor(target, this);
    }

    protected ReflectionAdaptor createJavaFieldAdaptor(Notifier target) {
        return new JavaFieldJDKAdaptor(target, this);
    }

    protected ReflectionAdaptor createJavaMethodAdaptor(Notifier target) {
        return new JavaMethodJDKAdaptor(target, this);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void flushAll() {
        this.isBusyIteratingReflected = true;
        try {
            Iterator i = this.reflected.values().iterator();
            while (i.hasNext()) {
                ((JavaClassJDKAdaptor)i.next()).flushReflectedValuesIfNecessary();
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.finishedIteratingReflected();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.finishedIteratingReflected();
    }

    public void flushReflection(String source) {
        JavaClassJDKAdaptor a = (JavaClassJDKAdaptor)this.reflected.get(source);
        if (a != null) {
            a.flushReflectedValuesIfNecessary();
        }
    }

    public ClassLoader getContextClassLoader() {
        return this.contextClassLoader;
    }

    public void setContextClassLoader(ClassLoader newContextClassLoader) {
        this.contextClassLoader = newContextClassLoader;
    }
}

