/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.ui;

import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.formatter.MultiPassContentFormatter;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.wst.css.ui.internal.contentassist.CSSContentAssistProcessor;
import org.eclipse.wst.css.ui.internal.style.LineStyleProviderForEmbeddedCSS;
import org.eclipse.wst.html.core.internal.HTMLCorePlugin;
import org.eclipse.wst.html.core.internal.format.HTMLFormatProcessorImpl;
import org.eclipse.wst.html.core.internal.text.StructuredTextPartitionerForHTML;
import org.eclipse.wst.html.ui.internal.autoedit.AutoEditStrategyForTabs;
import org.eclipse.wst.html.ui.internal.autoedit.StructuredAutoEditStrategyHTML;
import org.eclipse.wst.html.ui.internal.contentassist.HTMLContentAssistProcessor;
import org.eclipse.wst.html.ui.internal.contentassist.NoRegionContentAssistProcessorForHTML;
import org.eclipse.wst.html.ui.internal.hyperlink.XMLHyperlinkDetector;
import org.eclipse.wst.html.ui.internal.style.LineStyleProviderForHTML;
import org.eclipse.wst.html.ui.internal.taginfo.HTMLInformationProvider;
import org.eclipse.wst.html.ui.internal.taginfo.HTMLTagInfoHoverProcessor;
import org.eclipse.wst.javascript.ui.internal.common.contentassist.JavaScriptContentAssistProcessor;
import org.eclipse.wst.javascript.ui.internal.common.style.LineStyleProviderForJavaScript;
import org.eclipse.wst.javascript.ui.internal.common.taginfo.JavaScriptInformationProvider;
import org.eclipse.wst.javascript.ui.internal.common.taginfo.JavaScriptTagInfoHoverProcessor;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatProcessor;
import org.eclipse.wst.sse.ui.StructuredTextViewerConfiguration;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;
import org.eclipse.wst.sse.ui.internal.format.StructuredFormattingStrategy;
import org.eclipse.wst.sse.ui.internal.provisional.style.LineStyleProvider;
import org.eclipse.wst.sse.ui.internal.taginfo.TextHoverManager;
import org.eclipse.wst.sse.ui.internal.util.EditorUtility;
import org.eclipse.wst.xml.core.internal.text.rules.StructuredTextPartitionerForXML;
import org.eclipse.wst.xml.ui.StructuredTextViewerConfigurationXML;

public class StructuredTextViewerConfigurationHTML
extends StructuredTextViewerConfiguration {
    private String[] fConfiguredContentTypes;
    private LineStyleProvider fLineStyleProviderForEmbeddedCSS;
    private LineStyleProvider fLineStyleProviderForHTML;
    private LineStyleProvider fLineStyleProviderForJavascript;
    private StructuredTextViewerConfiguration fXMLSourceViewerConfiguration;

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        ArrayList<IAutoEditStrategy> allStrategies = new ArrayList<IAutoEditStrategy>(0);
        IAutoEditStrategy[] superStrategies = super.getAutoEditStrategies(sourceViewer, contentType);
        int i = 0;
        while (i < superStrategies.length) {
            allStrategies.add(superStrategies[i]);
            ++i;
        }
        if (contentType == "org.eclipse.wst.html.HTML_DEFAULT" || contentType == "org.eclipse.wst.html.HTML_DECLARATION") {
            allStrategies.add(new StructuredAutoEditStrategyHTML());
        }
        allStrategies.add(new AutoEditStrategyForTabs());
        return allStrategies.toArray(new IAutoEditStrategy[allStrategies.size()]);
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        if (this.fConfiguredContentTypes == null) {
            String[] xmlTypes = StructuredTextPartitionerForXML.getConfiguredContentTypes();
            String[] htmlTypes = StructuredTextPartitionerForHTML.getConfiguredContentTypes();
            this.fConfiguredContentTypes = new String[2 + xmlTypes.length + htmlTypes.length];
            this.fConfiguredContentTypes[0] = "org.eclipse.wst.sse.ST_DEFAULT";
            this.fConfiguredContentTypes[1] = "org.eclipse.wst.sse.UNKNOWN_PARTITION_TYPE";
            int index = 0;
            System.arraycopy(xmlTypes, 0, this.fConfiguredContentTypes, index += 2, xmlTypes.length);
            System.arraycopy(htmlTypes, 0, this.fConfiguredContentTypes, index += xmlTypes.length, htmlTypes.length);
        }
        return this.fConfiguredContentTypes;
    }

    protected IContentAssistProcessor[] getContentAssistProcessors(ISourceViewer sourceViewer, String partitionType) {
        IContentAssistProcessor[] processors = null;
        if (partitionType == "org.eclipse.wst.html.HTML_DEFAULT" || partitionType == "org.eclipse.wst.html.HTML_COMMENT") {
            processors = new IContentAssistProcessor[]{new HTMLContentAssistProcessor()};
        } else if (partitionType == "org.eclipse.wst.html.SCRIPT") {
            processors = new IContentAssistProcessor[]{new JavaScriptContentAssistProcessor()};
        } else if (partitionType == "org.eclipse.wst.css.STYLE") {
            processors = new IContentAssistProcessor[]{new CSSContentAssistProcessor()};
        } else if (partitionType == "org.eclipse.wst.sse.UNKNOWN_PARTITION_TYPE") {
            processors = new IContentAssistProcessor[]{new NoRegionContentAssistProcessorForHTML()};
        }
        return processors;
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        MultiPassContentFormatter formatter = new MultiPassContentFormatter(this.getConfiguredDocumentPartitioning(sourceViewer), "org.eclipse.wst.html.HTML_DEFAULT");
        formatter.setMasterStrategy((IFormattingStrategy)new StructuredFormattingStrategy((IStructuredFormatProcessor)new HTMLFormatProcessorImpl()));
        return formatter;
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (contentType == "org.eclipse.wst.html.HTML_DEFAULT") {
            return this.getXMLSourceViewerConfiguration().getDoubleClickStrategy(sourceViewer, "org.eclipse.wst.xml.XML_DEFAULT");
        }
        return super.getDoubleClickStrategy(sourceViewer, contentType);
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        if (sourceViewer == null || !this.fPreferenceStore.getBoolean("hyperlinksEnabled")) {
            return null;
        }
        ArrayList<IHyperlinkDetector> allDetectors = new ArrayList<IHyperlinkDetector>(0);
        allDetectors.add(new XMLHyperlinkDetector());
        IHyperlinkDetector[] superDetectors = super.getHyperlinkDetectors(sourceViewer);
        int m = 0;
        while (m < superDetectors.length) {
            IHyperlinkDetector detector = superDetectors[m];
            if (!allDetectors.contains(detector)) {
                allDetectors.add(detector);
            }
            ++m;
        }
        return allDetectors.toArray(new IHyperlinkDetector[0]);
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        Vector<String> vector = new Vector<String>();
        Preferences preferences = HTMLCorePlugin.getDefault().getPluginPreferences();
        int indentationWidth = preferences.getInt("indentationSize");
        String indentCharPref = preferences.getString("indentationChar");
        boolean useSpaces = "space".equals(indentCharPref);
        int i = 0;
        while (i <= indentationWidth) {
            int j;
            StringBuffer prefix = new StringBuffer();
            boolean appendTab = false;
            if (useSpaces) {
                j = 0;
                while (j + i < indentationWidth) {
                    prefix.append(' ');
                    ++j;
                }
                if (i != 0) {
                    appendTab = true;
                }
            } else {
                j = 0;
                while (j < i) {
                    prefix.append(' ');
                    ++j;
                }
                if (i != indentationWidth) {
                    appendTab = true;
                }
            }
            if (appendTab) {
                prefix.append('\t');
                vector.add(prefix.toString());
                prefix.deleteCharAt(prefix.length() - 1);
            }
            vector.add(prefix.toString());
            ++i;
        }
        vector.add("");
        return vector.toArray(new String[vector.size()]);
    }

    protected IInformationProvider getInformationProvider(ISourceViewer sourceViewer, String partitionType) {
        HTMLInformationProvider provider = null;
        if (partitionType == "org.eclipse.wst.html.HTML_DEFAULT") {
            provider = new HTMLInformationProvider();
        } else if (partitionType == "org.eclipse.wst.html.SCRIPT") {
            provider = new JavaScriptInformationProvider();
        }
        return provider;
    }

    public LineStyleProvider[] getLineStyleProviders(ISourceViewer sourceViewer, String partitionType) {
        LineStyleProvider[] providers = null;
        if (partitionType == "org.eclipse.wst.html.HTML_DEFAULT" || partitionType == "org.eclipse.wst.html.HTML_COMMENT" || partitionType == "org.eclipse.wst.html.HTML_DECLARATION") {
            providers = new LineStyleProvider[]{this.getLineStyleProviderForHTML()};
        } else if (partitionType == "org.eclipse.wst.html.SCRIPT") {
            providers = new LineStyleProvider[]{this.getLineStyleProviderForJavascript()};
        } else if (partitionType == "org.eclipse.wst.css.STYLE") {
            providers = new LineStyleProvider[]{this.getLineStyleProviderForEmbeddedCSS()};
        }
        return providers;
    }

    private LineStyleProvider getLineStyleProviderForEmbeddedCSS() {
        if (this.fLineStyleProviderForEmbeddedCSS == null) {
            this.fLineStyleProviderForEmbeddedCSS = new LineStyleProviderForEmbeddedCSS();
        }
        return this.fLineStyleProviderForEmbeddedCSS;
    }

    private LineStyleProvider getLineStyleProviderForHTML() {
        if (this.fLineStyleProviderForHTML == null) {
            this.fLineStyleProviderForHTML = new LineStyleProviderForHTML();
        }
        return this.fLineStyleProviderForHTML;
    }

    private LineStyleProvider getLineStyleProviderForJavascript() {
        if (this.fLineStyleProviderForJavascript == null) {
            this.fLineStyleProviderForJavascript = new LineStyleProviderForJavaScript();
        }
        return this.fLineStyleProviderForJavascript;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
        Object textHover = null;
        TextHoverManager manager = SSEUIPlugin.getDefault().getTextHoverManager();
        TextHoverManager.TextHoverDescriptor[] hoverDescs = manager.getTextHovers();
        int i = 0;
        while (i < hoverDescs.length && textHover == null) {
            if (hoverDescs[i].isEnabled() && EditorUtility.computeStateMask((String)hoverDescs[i].getModifierString()) == stateMask) {
                String hoverType = hoverDescs[i].getId();
                if ("combinationHover".equalsIgnoreCase(hoverType)) {
                    if (contentType == "org.eclipse.wst.html.SCRIPT") {
                        textHover = manager.createBestMatchHover((ITextHover)new JavaScriptTagInfoHoverProcessor());
                    } else if (contentType == "org.eclipse.wst.html.HTML_DEFAULT") {
                        textHover = manager.createBestMatchHover((ITextHover)new HTMLTagInfoHoverProcessor());
                    }
                } else if ("documentationHover".equalsIgnoreCase(hoverType)) {
                    if (contentType == "org.eclipse.wst.html.SCRIPT") {
                        textHover = new JavaScriptTagInfoHoverProcessor();
                    } else if (contentType == "org.eclipse.wst.html.HTML_DEFAULT") {
                        textHover = new HTMLTagInfoHoverProcessor();
                    }
                }
            }
            ++i;
        }
        if (textHover == null) {
            textHover = super.getTextHover(sourceViewer, contentType, stateMask);
        }
        return textHover;
    }

    private StructuredTextViewerConfiguration getXMLSourceViewerConfiguration() {
        if (this.fXMLSourceViewerConfiguration == null) {
            this.fXMLSourceViewerConfiguration = new StructuredTextViewerConfigurationXML();
        }
        return this.fXMLSourceViewerConfiguration;
    }
}

