/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.connection.internal.ui.wizards.shared;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.rdb.connection.internal.ui.util.resource.ResourceLoader;
import org.eclipse.wst.rdb.connection.internal.ui.wizards.ConnectionUtils;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;

public class DatabaseAuthenticationWizardPage
extends WizardPage
implements Listener {
    private static final ResourceLoader resource = ResourceLoader.INSTANCE;
    private Label userIdLabel;
    private Label passwordLabel;
    private Combo userIdCombo;
    private Text passwordText;
    private ConnectionInfo connectionInfo = null;

    public DatabaseAuthenticationWizardPage(String pageName) {
        super(pageName);
        this.setTitle(resource.queryString("_UI_PAGE_TITLE_DB_AUTHENTICATION"));
        this.setDescription(resource.queryString("_UI_PAGE_DESCRIPTION_DB_AUTHENTICATION"));
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.userIdLabel = new Label(composite, 0);
        this.userIdLabel.setText(resource.queryString("_UI_LABEL_USER_ID"));
        GridData gd = new GridData();
        gd.verticalAlignment = 1;
        this.userIdLabel.setLayoutData((Object)gd);
        this.userIdCombo = new Combo(composite, 2052);
        gd = new GridData();
        gd.widthHint = 100;
        gd.verticalAlignment = 1;
        gd.horizontalAlignment = 4;
        this.userIdCombo.setLayoutData((Object)gd);
        this.userIdCombo.addListener(24, (Listener)this);
        this.passwordLabel = new Label(composite, 0);
        this.passwordLabel.setText(resource.queryString("_UI_LABEL_PASSWORD"));
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.passwordLabel.setLayoutData((Object)gd);
        this.passwordText = new Text(composite, 2048);
        this.passwordText.setEchoChar('*');
        gd = new GridData();
        gd.widthHint = 100;
        gd.verticalAlignment = 1;
        gd.horizontalAlignment = 4;
        this.passwordText.setLayoutData((Object)gd);
        this.setControl((Control)composite);
    }

    public void setUserID(String uid) {
        if (this.userIdCombo != null) {
            if (uid != null) {
                this.userIdCombo.setText(uid);
            } else {
                this.userIdCombo.setText("");
            }
        }
    }

    public String getUserID() {
        String uid = "";
        if (this.userIdCombo != null) {
            uid = this.userIdCombo.getText();
        }
        return uid;
    }

    public void setPassword(String pwd) {
        if (this.passwordText != null) {
            this.passwordText.setText(pwd);
        }
    }

    public String getPassword() {
        String pwd = "";
        if (this.passwordText != null) {
            pwd = this.passwordText.getText();
        }
        return pwd;
    }

    public void setConnectionInfo(ConnectionInfo connectionInfo) {
        this.connectionInfo = connectionInfo;
        if (this.connectionInfo != null) {
            this.setUserID(this.connectionInfo.getUserName());
        }
    }

    public IWizardPage getNextPage() {
        IWizardPage nextPage = null;
        if (this.connectionInfo != null) {
            this.connectionInfo.setUserName(this.getUserID());
            this.connectionInfo.setPassword(this.getPassword());
            if (ConnectionUtils.openConnectionWithProgress(this.connectionInfo, false, this.getWizard().getContainer())) {
                nextPage = super.getNextPage();
            }
        }
        return nextPage;
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (this.getUserID().equals("")) {
                this.userIdCombo.setFocus();
            } else {
                this.passwordText.setFocus();
            }
        }
    }

    public void handleEvent(Event e) {
        if (this.getUserID().equals("")) {
            this.setMessage(resource.queryString("_UI_ERROR_MESSAGE_USER_ID_REQUIRED"));
            this.setPageComplete(false);
        } else {
            this.setPageComplete(true);
            this.setMessage(null);
        }
    }
}

