/*
 * Decompiled with CFR 0.152.
 */
package gnu.gcj.util;

import gnu.gcj.RawData;
import gnu.gcj.RawDataManaged;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.IdentityHashMap;

class Debug {
    private final PrintStream p;
    private final int maxdepth;
    private final int maxArrayLength;
    private final boolean printStaticFields;
    private int depth;
    private final IdentityHashMap h = new IdentityHashMap();

    Debug(PrintStream writer, int maxdepth, int maxArrayLength, boolean printStaticFields) {
        this.p = writer;
        this.maxdepth = maxdepth;
        this.maxArrayLength = maxArrayLength;
        this.printStaticFields = printStaticFields;
    }

    Debug(PrintStream writer) {
        this(writer, 0, 10, false);
    }

    Debug(int maxdepth, boolean printStaticFields) {
        this(new PrintStream(new FileOutputStream(FileDescriptor.err), true), maxdepth, maxdepth > 0 ? 1000 : 10, printStaticFields);
    }

    Debug(int maxdepth) {
        this(maxdepth, false);
    }

    Debug() {
        this(0, false);
    }

    private final void indent() {
        int i = 0;
        while (i < this.depth) {
            this.p.print("  ");
            ++i;
        }
    }

    private static native Field[] getDeclaredFields(Class var0);

    private static native Object getField(Object var0, Field var1);

    private static native long getAddr(Object var0);

    private Field[] internalGetFields(Class c) {
        HashSet<Field> set = new HashSet<Field>();
        set.addAll(Arrays.asList(Debug.getDeclaredFields(c)));
        Class<?>[] interfaces = c.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            set.addAll(Arrays.asList(this.internalGetFields(interfaces[i])));
            ++i;
        }
        Class superClass = c.getSuperclass();
        if (superClass != null) {
            set.addAll(Arrays.asList(this.internalGetFields(superClass)));
        }
        return set.toArray(new Field[set.size()]);
    }

    private static Class getItsClass(Object O) {
        return O.getClass();
    }

    private void print(Object O) {
        int savedDepth = this.depth++;
        this.h.put(O, O);
        try {
            Class<?> C = Debug.getItsClass(O);
            this.p.print(String.valueOf(C.getName()) + "@");
            this.p.println(Long.toHexString(Debug.getAddr(O)));
            if (C.isArray()) {
                this.indent();
                this.p.println("{");
                this.indent();
                C = C.getComponentType();
                int len = Array.getLength(O);
                int i = 0;
                while (i < len) {
                    Object thing = Array.get(O, i);
                    this.print0(thing, C);
                    this.p.print(", ");
                    if (i > this.maxArrayLength) {
                        this.p.print("...");
                        break;
                    }
                    ++i;
                }
                --this.depth;
                this.p.println();
                this.indent();
                this.p.print("}");
                return;
            }
            this.indent();
            this.p.println("{");
            ++this.depth;
            if (C == Class.class) {
                this.indent();
                this.p.println("class = " + O.toString() + ",");
            } else if (C == Field.class) {
                this.indent();
                this.p.println("<field> = \"" + O.toString() + "\",");
            } else if (C == String.class) {
                this.indent();
                this.p.println("<string> = \"" + O.toString() + "\",");
            }
            Field[] f = this.internalGetFields(C);
            int i = 0;
            while (i < f.length) {
                boolean isStatic;
                Class<?> type = f[i].getType();
                boolean bl = isStatic = (f[i].getModifiers() & 8) != 0;
                if (!isStatic || this.printStaticFields) {
                    this.indent();
                    if (isStatic) {
                        this.p.print("static ");
                    }
                    this.p.print(String.valueOf(type.getName()) + " " + f[i].getName() + " = ");
                    Object thing = Debug.getField(O, f[i]);
                    this.print0(thing, type);
                    this.p.println(",");
                }
                ++i;
            }
            --this.depth;
            this.indent();
            this.p.print("}");
        }
        catch (Throwable throwable) {
            this.p.print("error: 0x" + Long.toHexString(Debug.getAddr(O)) + ";");
            this.depth = savedDepth;
        }
    }

    private void print0(Object thing, Class C) {
        try {
            if (thing == null) {
                this.p.print("null");
                return;
            }
            if (C != RawData.class && C != RawDataManaged.class) {
                if (C.isPrimitive()) {
                    if (Debug.getItsClass(thing) == Character.class) {
                        this.p.print("'" + thing + "'");
                    } else {
                        this.p.print(thing);
                    }
                    return;
                }
                if (Debug.getItsClass(thing) == String.class) {
                    this.p.print("\"" + thing + "\"");
                    return;
                }
                if (this.depth < this.maxdepth && this.h.get(thing) == null) {
                    ++this.depth;
                    this.print(thing);
                    --this.depth;
                    return;
                }
            }
        }
        catch (Throwable throwable) {}
        this.p.print("0x" + Long.toHexString(Debug.getAddr(thing)));
    }

    public void write(Object O) {
        this.depth = 0;
        this.print(O);
        this.p.flush();
    }
}

