/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ShowThumbnailAction
extends AbstractAction
implements Layer.LayerAction {
    private final transient GeoImageLayer layer;

    public ShowThumbnailAction(GeoImageLayer geoImageLayer) {
        super(I18n.tr("Show thumbnails", new Object[0]), ImageProvider.get("dialogs/geoimage/togglegit"));
        this.putValue("ShortDescription", I18n.tr("Show image thumbnails instead of icons.", new Object[0]));
        this.layer = geoImageLayer;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.layer.setUseThumbs(!this.layer.isUseThumbs());
        Main.map.mapView.repaint();
    }

    private static boolean enabled(GeoImageLayer geoImageLayer) {
        return geoImageLayer.data != null && !geoImageLayer.data.isEmpty();
    }

    @Override
    public Component createMenuComponent() {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(this);
        jCheckBoxMenuItem.setEnabled(ShowThumbnailAction.enabled(this.layer));
        jCheckBoxMenuItem.setState(this.layer.isUseThumbs());
        return jCheckBoxMenuItem;
    }

    @Override
    public boolean supportLayers(List<Layer> list) {
        return list.size() == 1 && list.get(0) instanceof GeoImageLayer;
    }
}

