/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.auth;

import java.awt.GraphicsEnvironment;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.EnumMap;
import java.util.Map;
import org.openstreetmap.josm.gui.io.CredentialDialog;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.auth.CredentialsAgent;
import org.openstreetmap.josm.io.auth.CredentialsAgentException;
import org.openstreetmap.josm.io.auth.CredentialsAgentResponse;

public abstract class AbstractCredentialsAgent
implements CredentialsAgent {
    protected Map<Authenticator.RequestorType, PasswordAuthentication> memoryCredentialsCache = new EnumMap<Authenticator.RequestorType, PasswordAuthentication>(Authenticator.RequestorType.class);

    @Override
    public CredentialsAgentResponse getCredentials(final Authenticator.RequestorType requestorType, final String string, boolean bl) throws CredentialsAgentException {
        if (requestorType == null) {
            return null;
        }
        PasswordAuthentication passwordAuthentication = this.lookup(requestorType, string);
        final String string2 = passwordAuthentication == null || passwordAuthentication.getUserName() == null ? "" : passwordAuthentication.getUserName();
        final String string3 = passwordAuthentication == null || passwordAuthentication.getPassword() == null ? "" : String.valueOf(passwordAuthentication.getPassword());
        final CredentialsAgentResponse credentialsAgentResponse = new CredentialsAgentResponse();
        if (!bl && this.memoryCredentialsCache.containsKey((Object)requestorType) && (passwordAuthentication == null || passwordAuthentication.getPassword() == null || passwordAuthentication.getPassword().length == 0)) {
            PasswordAuthentication passwordAuthentication2 = this.memoryCredentialsCache.get((Object)requestorType);
            credentialsAgentResponse.setUsername(passwordAuthentication2.getUserName());
            credentialsAgentResponse.setPassword(passwordAuthentication2.getPassword());
            credentialsAgentResponse.setCanceled(false);
        } else if (bl || string2.isEmpty() || string3.isEmpty()) {
            if (!GraphicsEnvironment.isHeadless()) {
                GuiHelper.runInEDTAndWait(new Runnable(){

                    @Override
                    public void run() {
                        CredentialDialog credentialDialog = requestorType.equals((Object)Authenticator.RequestorType.PROXY) ? CredentialDialog.getHttpProxyCredentialDialog(string2, string3, string, AbstractCredentialsAgent.this.getSaveUsernameAndPasswordCheckboxText()) : CredentialDialog.getOsmApiCredentialDialog(string2, string3, string, AbstractCredentialsAgent.this.getSaveUsernameAndPasswordCheckboxText());
                        credentialDialog.setVisible(true);
                        credentialsAgentResponse.setCanceled(credentialDialog.isCanceled());
                        if (credentialDialog.isCanceled()) {
                            return;
                        }
                        credentialsAgentResponse.setUsername(credentialDialog.getUsername());
                        credentialsAgentResponse.setPassword(credentialDialog.getPassword());
                        credentialsAgentResponse.setSaveCredentials(credentialDialog.isSaveCredentials());
                    }
                });
            }
            if (credentialsAgentResponse.isCanceled() || credentialsAgentResponse.getUsername() == null || credentialsAgentResponse.getPassword() == null) {
                return credentialsAgentResponse;
            }
            if (credentialsAgentResponse.isSaveCredentials()) {
                this.store(requestorType, string, new PasswordAuthentication(credentialsAgentResponse.getUsername(), credentialsAgentResponse.getPassword()));
            } else {
                PasswordAuthentication passwordAuthentication3 = new PasswordAuthentication(credentialsAgentResponse.getUsername(), credentialsAgentResponse.getPassword());
                this.memoryCredentialsCache.put(requestorType, passwordAuthentication3);
            }
        } else {
            credentialsAgentResponse.setUsername(string2);
            credentialsAgentResponse.setPassword(string3.toCharArray());
            credentialsAgentResponse.setCanceled(false);
        }
        return credentialsAgentResponse;
    }

    public abstract String getSaveUsernameAndPasswordCheckboxText();
}

