/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.object;

import com.oracle.truffle.api.object.BooleanLocation;
import com.oracle.truffle.api.object.DoubleLocation;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.IntLocation;
import com.oracle.truffle.api.object.Layout;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.LongLocation;
import com.oracle.truffle.api.object.ObjectLocation;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.object.DynamicObjectImpl;
import com.oracle.truffle.object.LayoutStrategy;
import com.oracle.truffle.object.LocationImpl;
import com.oracle.truffle.object.Locations;
import com.oracle.truffle.object.ShapeImpl;
import java.util.EnumSet;

public abstract class LayoutImpl
extends Layout {
    private static final int INT_TO_DOUBLE_FLAG = 1;
    private static final int INT_TO_LONG_FLAG = 2;
    protected final LayoutStrategy strategy;
    protected final Class<? extends DynamicObject> clazz;
    private final int allowedImplicitCasts;

    protected LayoutImpl(EnumSet<Layout.ImplicitCast> allowedImplicitCasts, Class<? extends DynamicObjectImpl> clazz, LayoutStrategy strategy) {
        this.strategy = strategy;
        this.clazz = clazz;
        this.allowedImplicitCasts = (allowedImplicitCasts.contains((Object)Layout.ImplicitCast.IntToDouble) ? 1 : 0) | (allowedImplicitCasts.contains((Object)Layout.ImplicitCast.IntToLong) ? 2 : 0);
    }

    @Override
    public abstract DynamicObject newInstance(Shape var1);

    @Override
    public Class<? extends DynamicObject> getType() {
        return this.clazz;
    }

    @Override
    public final Shape createShape(ObjectType objectType, Object sharedData) {
        return this.createShape(objectType, sharedData, 0);
    }

    @Override
    public final Shape createShape(ObjectType objectType) {
        return this.createShape(objectType, null);
    }

    public boolean isAllowedIntToDouble() {
        return (this.allowedImplicitCasts & 1) != 0;
    }

    public boolean isAllowedIntToLong() {
        return (this.allowedImplicitCasts & 2) != 0;
    }

    protected abstract boolean hasObjectExtensionArray();

    protected abstract boolean hasPrimitiveExtensionArray();

    protected abstract int getObjectFieldCount();

    protected abstract int getPrimitiveFieldCount();

    protected abstract Location getObjectArrayLocation();

    protected abstract Location getPrimitiveArrayLocation();

    protected abstract int objectFieldIndex(Location var1);

    protected boolean isLocationAssignableFrom(Location destination, Location source) {
        LayoutImpl layout = this;
        if (destination.isFinal() && !source.isFinal()) {
            return false;
        }
        if (destination instanceof IntLocation) {
            return source instanceof IntLocation;
        }
        if (destination instanceof DoubleLocation) {
            return source instanceof DoubleLocation || layout.isAllowedIntToDouble() && source instanceof IntLocation;
        }
        if (destination instanceof LongLocation) {
            return source instanceof LongLocation || layout.isAllowedIntToLong() && source instanceof IntLocation;
        }
        if (destination instanceof BooleanLocation) {
            return source instanceof BooleanLocation;
        }
        if (destination instanceof LocationImpl.TypedObjectLocation) {
            return source instanceof LocationImpl.TypedObjectLocation && ((LocationImpl.TypedObjectLocation)((Object)destination)).getType().isAssignableFrom(((LocationImpl.TypedObjectLocation)((Object)source)).getType());
        }
        if (destination instanceof Locations.ValueLocation) {
            return false;
        }
        assert (destination instanceof ObjectLocation || destination instanceof Locations.DualLocation);
        return true;
    }

    protected Location existingLocationForValue(Object value, Location oldLocation, Shape oldShape) {
        Location newLocation;
        assert (oldShape.getLayout() == this);
        if (oldLocation instanceof IntLocation && value instanceof Integer) {
            newLocation = oldLocation;
        } else if (oldLocation instanceof DoubleLocation && (value instanceof Double || this.isAllowedIntToDouble() && value instanceof Integer)) {
            newLocation = oldLocation;
        } else if (oldLocation instanceof LongLocation && (value instanceof Long || this.isAllowedIntToLong() && value instanceof Integer)) {
            newLocation = oldLocation;
        } else {
            if (oldLocation instanceof Locations.DeclaredLocation) {
                return oldShape.allocator().locationForValue(value, EnumSet.of(LocationModifier.Final, LocationModifier.NonNull));
            }
            if (oldLocation instanceof Locations.ConstantLocation) {
                return LocationImpl.valueEquals(oldLocation.get(null, false), value) ? oldLocation : new Locations.ConstantLocation(value);
            }
            if (oldLocation instanceof LocationImpl.TypedObjectLocation && !((LocationImpl.TypedObjectLocation)((Object)oldLocation)).getType().isAssignableFrom(value.getClass())) {
                newLocation = ((LocationImpl.TypedObjectLocation)((Object)oldLocation)).toUntypedLocation();
            } else if (oldLocation instanceof Locations.DualLocation) {
                newLocation = oldLocation.canStore(value) ? oldLocation : ((ShapeImpl.BaseAllocator)oldShape.allocator()).locationForValueUpcast(value, oldLocation);
            } else if (oldLocation instanceof ObjectLocation) {
                newLocation = oldLocation;
            } else {
                return oldShape.allocator().locationForValue(value, EnumSet.of(LocationModifier.NonNull));
            }
        }
        if (newLocation instanceof LocationImpl.EffectivelyFinalLocation) {
            newLocation = ((LocationImpl.EffectivelyFinalLocation)((Object)newLocation)).toNonFinalLocation();
        }
        return newLocation;
    }

    public boolean isPropertyUpcastOf(Property thiz, Property other) {
        return thiz.getLocation() != null && other.getLocation() != null && other.getKey().equals(thiz.getKey()) && other.getFlags() == thiz.getFlags() && this.isLocationAssignableFrom(thiz.getLocation(), other.getLocation());
    }

    @Override
    public abstract Shape.Allocator createAllocator();

    public LayoutStrategy getStrategy() {
        return this.strategy;
    }
}

