/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.util;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Properties;

public final class Debug {
    public static final int INFO = 1;
    public static final int ERROR = 2;
    public static final int TRACE = 4;
    private static final boolean SET = true;
    private static int flags = 0;
    private static PrintWriter writer = null;

    private Debug() {
    }

    private static void setOutput(String string) {
        if (writer == null) {
            if (string.equals("System.out")) {
                Debug.setOutput(System.out);
            } else if (string.equals("System.err")) {
                Debug.setOutput(System.err);
            } else {
                try {
                    Debug.setOutput(new FileWriter(string));
                }
                catch (IOException iOException) {
                    iOException.printStackTrace(System.err);
                }
            }
        }
    }

    private static void setOutput(OutputStream outputStream) {
        Debug.setOutput(new OutputStreamWriter(outputStream));
    }

    private static void setOutput(Writer writer) {
        if (Debug.writer != null) {
            Debug.writer.close();
        }
        Debug.writer = new PrintWriter((Writer)new BufferedWriter(writer), true);
    }

    private static void setFlags(int n, boolean bl) {
        flags = bl ? (flags |= n) : (flags &= ~n);
    }

    public static boolean isFlagSet(int n) {
        return (flags & n) != 0;
    }

    public static void log(int n, String string) {
        if (Debug.isFlagSet(n) && writer != null) {
            writer.println(string);
        }
    }

    public static void log(int n, String string, Throwable throwable) {
        if (Debug.isFlagSet(n) && writer != null) {
            writer.println(string);
            if (throwable != null) {
                throwable.printStackTrace(writer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        InputStream inputStream = null;
        try {
            try {
                inputStream = Debug.class.getResourceAsStream("Debug.properties");
                Properties properties = new Properties();
                properties.load(inputStream);
                String string = properties.getProperty("debug.info", "false");
                string = string.toLowerCase();
                if (string.equals("true")) {
                    Debug.setFlags(1, true);
                }
                String string2 = properties.getProperty("debug.trace", "false");
                if ((string2 = string2.toLowerCase()).equals("true")) {
                    Debug.setFlags(4, true);
                }
                String string3 = properties.getProperty("debug.error", "false");
                if ((string3 = string3.toLowerCase()).equals("true")) {
                    Debug.setFlags(2, true);
                }
                String string4 = properties.getProperty("debug.output", "System.out");
                Debug.setOutput(string4);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
        }
    }
}

