/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core.supplier;

import junit.framework.TestCase;
import liquibase.change.Change;
import liquibase.change.ColumnConfig;
import liquibase.change.core.AddDefaultValueChange;
import liquibase.change.core.CreateTableChange;
import liquibase.diff.DiffResult;
import liquibase.diff.ObjectDifferences;
import liquibase.sdk.supplier.change.AbstractChangeSupplier;
import liquibase.structure.core.Column;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;
import org.junit.Assert;

public class AddDefaultValueChangeSupplier
extends AbstractChangeSupplier<AddDefaultValueChange> {
    public AddDefaultValueChangeSupplier() {
        super(AddDefaultValueChange.class);
    }

    @Override
    public Change[] prepareDatabase(AddDefaultValueChange change) throws Exception {
        CreateTableChange createTableChange = new CreateTableChange();
        createTableChange.setCatalogName(change.getCatalogName());
        createTableChange.setSchemaName(change.getSchemaName());
        createTableChange.setTableName(change.getTableName());
        createTableChange.addColumn(new ColumnConfig().setName("other_col").setType("int"));
        String type = change.getColumnDataType();
        if (type == null) {
            type = change.getDefaultValueDate() != null ? "datetime" : (change.getDefaultValueBoolean() != null ? "boolean" : (change.getDefaultValueNumeric() != null ? "decimal" : "varchar(255)"));
        }
        createTableChange.addColumn(new ColumnConfig().setName(change.getColumnName()).setType(type));
        return new Change[]{createTableChange};
    }

    @Override
    public void checkDiffResult(DiffResult diffResult, AddDefaultValueChange change) {
        Column example = new Column().setName(change.getColumnName()).setRelation(new Table().setName(change.getTableName()).setSchema(new Schema(change.getCatalogName(), change.getSchemaName())));
        ObjectDifferences diff = diffResult.getChangedObject(example);
        Assert.assertNotNull((Object)diff);
        Assert.assertNotNull((Object)diff.getDifference("defaultValue"));
        TestCase.assertNull((Object)diff.getDifference("defaultValue").getReferenceValue());
        Assert.assertNotNull((Object)diff.getDifference("defaultValue").getComparedValue());
    }
}

