/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model;

import com.rc.retroweaver.runtime.ClassLiteral;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.python.pydev.debug.model.AbstractDebugTarget;
import org.python.pydev.debug.model.AdapterDebug;
import org.python.pydev.debug.model.DeferredWorkbenchAdapter;
import org.python.pydev.debug.model.IVariableLocator;
import org.python.pydev.debug.model.PyVariableContentProviderHack;
import org.python.pydev.debug.model.remote.ChangeVariableCommand;

public class PyVariable
extends PlatformObject
implements IVariable,
IValue,
IVariableLocator {
    protected String name;
    protected String type;
    protected String value;
    protected AbstractDebugTarget target;
    protected boolean isModified;
    protected IVariableLocator locator;
    private static final IVariable[] EMPTY_IVARIABLE_ARRAY = new IVariable[0];

    public PyVariable(AbstractDebugTarget target, String name, String type, String value, IVariableLocator locator) {
        this.value = value;
        this.name = name;
        this.type = type;
        this.target = target;
        this.locator = locator;
        this.isModified = false;
    }

    public String getPyDBLocation() {
        return String.valueOf(this.locator.getPyDBLocation()) + "\t" + this.name;
    }

    public String getDetailText() throws DebugException {
        return this.getValueString();
    }

    public IValue getValue() throws DebugException {
        return this;
    }

    public String getValueString() throws DebugException {
        if (this.value == null) {
            return "";
        }
        if ("StringType".equals(this.type) || "UnicodeType".equals(this.type)) {
            return "\"" + this.value + "\"";
        }
        return this.value;
    }

    public String getName() throws DebugException {
        return this.name;
    }

    public String getModelIdentifier() {
        return this.target.getModelIdentifier();
    }

    public IDebugTarget getDebugTarget() {
        return this.target;
    }

    public ILaunch getLaunch() {
        return this.target.getLaunch();
    }

    public boolean supportsValueModification() {
        return this.locator != null;
    }

    public boolean hasValueChanged() throws DebugException {
        return this.isModified;
    }

    public void setModified(boolean mod) {
        this.isModified = mod;
    }

    public void setValue(String expression) throws DebugException {
        ChangeVariableCommand changeVariableCommand = this.getChangeVariableCommand(this.target, expression);
        this.target.postCommand(changeVariableCommand);
        this.value = expression;
        this.target.fireEvent(new DebugEvent((Object)this, 528));
    }

    public void setValue(IValue value) throws DebugException {
    }

    public boolean verifyValue(String expression) throws DebugException {
        return true;
    }

    public boolean verifyValue(IValue value) throws DebugException {
        return false;
    }

    public Object getAdapter(Class adapter) {
        AdapterDebug.print(this, adapter);
        if (adapter.equals(ClassLiteral.getClass((String)"org/eclipse/debug/core/ILaunch"))) {
            return this.target.getAdapter(adapter);
        }
        if (adapter.equals(ClassLiteral.getClass((String)"org/eclipse/ui/views/properties/IPropertySource")) || adapter.equals(ClassLiteral.getClass((String)"org/eclipse/ui/views/tasklist/ITaskListResourceAdapter")) || adapter.equals(ClassLiteral.getClass((String)"org/eclipse/ui/IContributorResourceAdapter")) || adapter.equals(ClassLiteral.getClass((String)"org/eclipse/ui/IActionFilter")) || adapter.equals(ClassLiteral.getClass((String)"org/eclipse/ui/model/IWorkbenchAdapter")) || adapter.equals(ClassLiteral.getClass((String)"org/eclipse/debug/ui/actions/IToggleBreakpointsTarget")) || adapter.equals(ClassLiteral.getClass((String)"org/eclipse/debug/ui/actions/IRunToLineTarget")) || adapter.equals(ClassLiteral.getClass((String)"org/eclipse/core/resources/IResource")) || adapter.equals(ClassLiteral.getClass((String)"org/eclipse/core/resources/IFile"))) {
            return super.getAdapter(adapter);
        }
        if (adapter.equals(ClassLiteral.getClass((String)"org/eclipse/ui/progress/IDeferredWorkbenchAdapter"))) {
            return new DeferredWorkbenchAdapter(this);
        }
        if (adapter.toString().endsWith("org.eclipse.debug.internal.ui.viewers.model.provisional.IElementContentProvider")) {
            return new PyVariableContentProviderHack();
        }
        AdapterDebug.printDontKnow(this, adapter);
        return super.getAdapter(adapter);
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public IVariable[] getVariables() throws DebugException {
        return EMPTY_IVARIABLE_ARRAY;
    }

    public boolean hasVariables() throws DebugException {
        return false;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.type;
    }

    public ChangeVariableCommand getChangeVariableCommand(AbstractDebugTarget dbg, String expression) {
        return new ChangeVariableCommand(dbg, this.getPyDBLocation(), expression);
    }
}

