/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.examples.pdmodel;

import java.io.FileInputStream;
import java.io.IOException;
import org.pdfbox.exceptions.InvalidPasswordException;
import org.pdfbox.pdfparser.PDFParser;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineNode;

public class PrintBookmarks {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) throws Exception {
        PDDocument document;
        block9: {
            if (args.length != 1) {
                PrintBookmarks.usage();
                return;
            }
            document = null;
            FileInputStream file = null;
            try {
                file = new FileInputStream(args[0]);
                PDFParser parser = new PDFParser(file);
                parser.parse();
                document = parser.getPDDocument();
                if (document.isEncrypted()) {
                    try {
                        document.decrypt("");
                    }
                    catch (InvalidPasswordException e) {
                        System.err.println("Error: Document is encrypted with a password.");
                        System.exit(1);
                    }
                }
                PrintBookmarks meta = new PrintBookmarks();
                PDDocumentOutline outline = document.getDocumentCatalog().getDocumentOutline();
                if (outline != null) {
                    meta.printBookmark(outline, "");
                } else {
                    System.out.println("This document does not contain any bookmarks");
                }
                Object var7_7 = null;
                if (file == null) break block9;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (file != null) {
                    file.close();
                }
                if (document == null) throw throwable;
                document.close();
                throw throwable;
            }
            file.close();
        }
        if (document == null) return;
        document.close();
    }

    private static void usage() {
        System.err.println("Usage: java org.pdfbox.examples.pdmodel.PrintBookmarks <input-pdf>");
    }

    public void printBookmark(PDOutlineNode bookmark, String indentation) throws IOException {
        for (PDOutlineItem current = bookmark.getFirstChild(); current != null; current = current.getNextSibling()) {
            System.out.println(indentation + current.getTitle());
            this.printBookmark(current, indentation + "    ");
        }
    }
}

