/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import java.util.Hashtable;
import java.util.Vector;
import org.icepdf.core.pobjects.Destination;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.pobjects.actions.Action;
import org.icepdf.core.pobjects.fonts.ofont.Encoding;
import org.icepdf.core.util.Library;

public class OutlineItem
extends Dictionary {
    private String title;
    private Destination dest;
    private Action action;
    private Reference parent;
    private Reference prev;
    private Reference next;
    private Reference first;
    private Reference last;
    private int count = -1;
    private boolean loadedSubItems = false;
    private Vector<OutlineItem> subItems = new Vector(Math.max(Math.abs(this.getCount()), 16));

    public OutlineItem(Library library, Hashtable hashtable) {
        super(library, hashtable);
    }

    public boolean isEmpty() {
        return this.getTitle() == null && this.getDest() == null && this.getAction() == null;
    }

    public int getSubItemCount() {
        this.ensureSubItemsLoaded();
        if (this.subItems != null) {
            return this.subItems.size();
        }
        return 0;
    }

    public OutlineItem getSubItem(int n) {
        this.ensureSubItemsLoaded();
        return this.subItems.get(n);
    }

    public Action getAction() {
        Object object;
        if (this.action == null && (object = this.library.getObject(this.entries, "A")) instanceof Hashtable) {
            this.action = new Action(this.library, (Hashtable)object);
        }
        return this.action;
    }

    public Reference getFirst() {
        Object v;
        if (this.first == null && (v = this.entries.get("First")) instanceof Reference) {
            this.first = (Reference)v;
        }
        return this.first;
    }

    public Reference getLast() {
        Object v;
        if (this.last == null && (v = this.entries.get("Last")) instanceof Reference) {
            this.last = (Reference)v;
        }
        return this.last;
    }

    public Reference getNext() {
        Object v;
        if (this.next == null && (v = this.entries.get("Next")) instanceof Reference) {
            this.next = (Reference)v;
        }
        return this.next;
    }

    public Reference getPrev() {
        Object v;
        if (this.prev == null && (v = this.entries.get("Prev")) instanceof Reference) {
            this.prev = (Reference)v;
        }
        return this.prev;
    }

    public Reference getParent() {
        Object v;
        if (this.parent == null && (v = this.entries.get("Parent")) instanceof Reference) {
            this.parent = (Reference)v;
        }
        return this.parent;
    }

    private int getCount() {
        if (this.count < 0) {
            this.count = this.library.getInt(this.entries, "Count");
        }
        return this.count;
    }

    public String getTitle() {
        Object object;
        if (this.title == null && (object = this.library.getObject(this.entries, "Title")) instanceof StringObject) {
            StringObject stringObject = (StringObject)object;
            String string = stringObject.getDecryptedLiteralString(this.library.securityManager);
            if (string != null && string.length() >= 2 && string.charAt(0) == '\u00fe' && string.charAt(1) == '\u00ff') {
                int n;
                StringBuffer stringBuffer = new StringBuffer();
                String string2 = "";
                for (int i = 0; i < string.length(); ++i) {
                    n = string.charAt(i);
                    if (n == 9 || n == 13 || n == 10) continue;
                    string2 = string2 + string.charAt(i);
                }
                byte[] byArray = string2.getBytes();
                for (n = 2; n < byArray.length; n += 2) {
                    try {
                        int n2 = byArray[n] & 0xFF;
                        int n3 = byArray[n + 1] & 0xFF;
                        stringBuffer.append((char)(n2 * 256 + n3));
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.title = stringBuffer.toString();
            } else if (string != null) {
                StringBuffer stringBuffer = new StringBuffer();
                Encoding encoding = Encoding.getPDFDoc();
                for (int i = 0; i < string.length(); ++i) {
                    stringBuffer.append(encoding.get(string.charAt(i)));
                }
                this.title = stringBuffer.toString();
            }
        }
        return this.title;
    }

    public Destination getDest() {
        Object object;
        if (this.dest == null && (object = this.library.getObject(this.entries, "Dest")) != null) {
            this.dest = new Destination(this.library, object);
        }
        return this.dest;
    }

    private void ensureSubItemsLoaded() {
        if (this.loadedSubItems) {
            return;
        }
        this.loadedSubItems = true;
        if (this.getFirst() != null) {
            Hashtable hashtable;
            Reference reference = this.getFirst();
            while (reference != null && (hashtable = (Hashtable)this.library.getObject(reference)) != null) {
                OutlineItem outlineItem = new OutlineItem(this.library, hashtable);
                this.subItems.add(outlineItem);
                Reference reference2 = reference;
                if (!reference2.equals(reference = outlineItem.getNext())) continue;
                break;
            }
        }
    }
}

