/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.entities.mapper.relation;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.entities.EntityConfiguration;
import org.hibernate.envers.entities.PropertyData;
import org.hibernate.envers.entities.mapper.PersistentCollectionChangeData;
import org.hibernate.envers.entities.mapper.PropertyMapper;
import org.hibernate.envers.entities.mapper.id.IdMapper;
import org.hibernate.envers.entities.mapper.relation.lazy.ToOneDelegateSessionImplementor;
import org.hibernate.envers.reader.AuditReaderImplementor;
import org.hibernate.envers.tools.Tools;
import org.hibernate.envers.tools.reflection.ReflectionTools;
import org.hibernate.property.Setter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToOneIdMapper
implements PropertyMapper {
    private final IdMapper delegate;
    private final PropertyData propertyData;
    private final String referencedEntityName;
    private final boolean nonInsertableFake;

    public ToOneIdMapper(IdMapper delegate, PropertyData propertyData, String referencedEntityName, boolean nonInsertableFake) {
        this.delegate = delegate;
        this.propertyData = propertyData;
        this.referencedEntityName = referencedEntityName;
        this.nonInsertableFake = nonInsertableFake;
    }

    @Override
    public boolean mapToMapFromEntity(SessionImplementor session, Map<String, Object> data, Object newObj, Object oldObj) {
        HashMap<String, Object> newData = new HashMap<String, Object>();
        data.put(this.propertyData.getName(), newData);
        this.delegate.mapToMapFromEntity(newData, this.nonInsertableFake ? oldObj : newObj);
        return this.nonInsertableFake ? false : !Tools.entitiesEqual(session, this.referencedEntityName, newObj, oldObj);
    }

    @Override
    public void mapToEntityFromMap(AuditConfiguration verCfg, Object obj, Map data, Object primaryKey, AuditReaderImplementor versionsReader, Number revision) {
        Object value;
        if (obj == null) {
            return;
        }
        Object entityId = this.delegate.mapToIdFromMap((Map)data.get(this.propertyData.getName()));
        if (entityId == null) {
            value = null;
        } else if (versionsReader.getFirstLevelCache().contains(this.referencedEntityName, revision, entityId)) {
            value = versionsReader.getFirstLevelCache().get(this.referencedEntityName, revision, entityId);
        } else {
            EntityConfiguration entCfg = verCfg.getEntCfg().get(this.referencedEntityName);
            if (entCfg == null) {
                entCfg = verCfg.getEntCfg().getNotVersionEntityConfiguration(this.referencedEntityName);
            }
            Class<?> entityClass = ReflectionTools.loadClass(entCfg.getEntityClassName());
            value = versionsReader.getSessionImplementor().getFactory().getEntityPersister(this.referencedEntityName).createProxy((Serializable)entityId, new ToOneDelegateSessionImplementor(versionsReader, entityClass, entityId, revision, verCfg));
        }
        Setter setter = ReflectionTools.getSetter(obj.getClass(), this.propertyData);
        setter.set(obj, value, null);
    }

    @Override
    public List<PersistentCollectionChangeData> mapCollectionChanges(String referencingPropertyName, PersistentCollection newColl, Serializable oldColl, Serializable id) {
        return null;
    }
}

