/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.BitSet;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CRowidAccessor;
import oracle.jdbc.driver.T4CTTIMsg;
import oracle.jdbc.oracore.OracleTypeADT;

class T4CTTIrxd
extends T4CTTIMsg {
    static final byte[] NO_BYTES = new byte[0];
    byte[] buffer;
    byte[] bufferCHAR;
    BitSet bvcColSent = null;
    int nbOfColumns = 0;
    boolean bvcFound = false;
    boolean isFirstCol;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "051228";

    T4CTTIrxd(T4CMAREngine t4CMAREngine) {
        super((byte)7);
        this.setMarshalingEngine(t4CMAREngine);
        this.isFirstCol = true;
    }

    void init() {
        this.isFirstCol = true;
    }

    void setNumberOfColumns(int n) {
        this.nbOfColumns = n;
        this.bvcFound = false;
        this.bvcColSent = new BitSet(this.nbOfColumns);
    }

    void unmarshalBVC(int n) throws SQLException, IOException {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < this.bvcColSent.length(); ++n2) {
            this.bvcColSent.clear(n2);
        }
        n2 = this.nbOfColumns / 8 + (this.nbOfColumns % 8 != 0 ? 1 : 0);
        for (int i = 0; i < n2; ++i) {
            byte by = (byte)(this.meg.unmarshalUB1() & 0xFF);
            for (int j = 0; j < 8; ++j) {
                if ((by & 1 << j) == 0) continue;
                this.bvcColSent.set(i * 8 + j);
                ++n3;
            }
        }
        if (n3 != n) {
            DatabaseError.throwSqlException(-1, "INTERNAL ERROR: oracle.jdbc.driver.T4CTTIrxd.unmarshalBVC: bits missing in vector");
        }
        this.bvcFound = true;
    }

    void unmarshalBVCWithLength() throws SQLException, IOException {
        int n;
        for (n = 0; n < this.bvcColSent.length(); ++n) {
            this.bvcColSent.clear(n);
        }
        n = this.meg.unmarshalUB1() & 0xFF;
        for (int i = 0; i < n; ++i) {
            byte by = (byte)(this.meg.unmarshalUB1() & 0xFF);
            for (int j = 0; j < 8; ++j) {
                if ((by & 1 << j) == 0) continue;
                this.bvcColSent.set(i * 8 + j);
            }
        }
        this.bvcFound = true;
    }

    void marshal(byte[] byArray, char[] cArray, short[] sArray, int n, byte[] byArray2, DBConversion dBConversion, InputStream[] inputStreamArray, byte[][] byArray3, OracleTypeADT[] oracleTypeADTArray, byte[] byArray4, char[] cArray2, short[] sArray2, byte[] byArray5, int n2, int[] nArray, boolean bl, int[] nArray2, int[][] nArray3) throws IOException, SQLException {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        short s;
        int n8;
        int n9;
        int n10;
        short s2;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        this.marshalTTCcode();
        int n17 = sArray[n + 0] & 0xFFFF;
        int n18 = nArray2[0];
        int[] nArray4 = nArray3[0];
        int n19 = 0;
        int n20 = 0;
        for (n16 = 0; n16 < n17; ++n16) {
            if (n19 < n18 && nArray4[n19] == n16) {
                ++n19;
                continue;
            }
            n15 = n + 3 + 10 * n16;
            n14 = sArray[n15 + 0] & 0xFFFF;
            if (byArray5 != null && (byArray5[n16] & 0x20) == 0) {
                if (n14 != 998) continue;
                ++n20;
                continue;
            }
            n13 = ((sArray[n15 + 7] & 0xFFFF) << 16) + (sArray[n15 + 8] & 0xFFFF) + n2;
            n12 = ((sArray[n15 + 5] & 0xFFFF) << 16) + (sArray[n15 + 6] & 0xFFFF) + n2;
            n11 = sArray[n13] & 0xFFFF;
            s2 = sArray[n12];
            if (n14 == 116) {
                this.meg.marshalUB1((short)1);
                this.meg.marshalUB1((short)0);
                continue;
            }
            if (n14 == 8 || n14 == 24 || !bl && nArray != null && nArray.length > n16 && nArray[n16] > 4000) {
                if (n18 >= nArray4.length) {
                    int[] nArray5 = new int[nArray4.length << 1];
                    System.arraycopy(nArray4, 0, nArray5, 0, nArray4.length);
                    nArray4 = nArray5;
                }
                nArray4[n18++] = n16;
                continue;
            }
            if (s2 == -1) {
                if (n14 != 109 && n14 != 8 && n14 != 24) {
                    if (n14 == 998) {
                        ++n20;
                    }
                    this.meg.marshalUB1((short)0);
                    continue;
                }
                if (n14 == 109) {
                    this.meg.marshalDALC(NO_BYTES);
                    this.meg.marshalDALC(NO_BYTES);
                    this.meg.marshalDALC(NO_BYTES);
                    this.meg.marshalUB2(0);
                    this.meg.marshalUB4(0L);
                    this.meg.marshalUB2(1);
                    continue;
                }
            }
            if (n14 == 998) {
                int n21 = (sArray2[6 + n20 * 8 + 4] & 0xFFFF) << 16 & 0xFFFF000 | sArray2[6 + n20 * 8 + 5] & 0xFFFF;
                n10 = (sArray2[6 + n20 * 8 + 6] & 0xFFFF) << 16 & 0xFFFF000 | sArray2[6 + n20 * 8 + 7] & 0xFFFF;
                int n22 = sArray2[6 + n20 * 8] & 0xFFFF;
                n9 = sArray2[6 + n20 * 8 + 1] & 0xFFFF;
                this.meg.marshalUB4(n21);
                for (n8 = 0; n8 < n21; ++n8) {
                    s = n10 + n8 * n9;
                    if (n22 == 9) {
                        n7 = cArray2[s] / 2;
                        n6 = 0;
                        n6 = dBConversion.javaCharsToCHARBytes(cArray2, s + 1, byArray2, 0, n7);
                        this.meg.marshalCLR(byArray2, n6);
                        continue;
                    }
                    n11 = byArray4[s];
                    if (n11 < 1) {
                        this.meg.marshalUB1((short)0);
                        continue;
                    }
                    this.meg.marshalCLR(byArray4, s + 1, n11);
                }
                ++n20;
                continue;
            }
            int n23 = sArray[n15 + 1] & 0xFFFF;
            if (n23 != 0) {
                int n24 = ((sArray[n15 + 3] & 0xFFFF) << 16) + (sArray[n15 + 4] & 0xFFFF) + n23 * n2;
                if (n14 == 6) {
                    ++n24;
                    --n11;
                } else if (n14 == 9) {
                    n24 += 2;
                    n11 -= 2;
                } else if (n14 == 114 || n14 == 113 || n14 == 112) {
                    this.meg.marshalUB2(n11);
                }
                if (n14 == 109 || n14 == 111) {
                    byte[] byArray6;
                    if (byArray3 == null) {
                        DatabaseError.throwSqlException(-1, "INTERNAL ERROR: oracle.jdbc.driver.T4CTTIrxd.marshal: parameterDatum is null");
                    }
                    int n25 = n11 = (byArray6 = byArray3[n16]) == null ? 0 : byArray6.length;
                    if (n14 == 109) {
                        this.meg.marshalDALC(NO_BYTES);
                        this.meg.marshalDALC(NO_BYTES);
                        this.meg.marshalDALC(NO_BYTES);
                        this.meg.marshalUB2(0);
                        this.meg.marshalUB4(n11);
                        this.meg.marshalUB2(1);
                    }
                    if (n11 <= 0) continue;
                    this.meg.marshalCLR(byArray6, 0, n11);
                    continue;
                }
                if (n14 == 104) {
                    long[] lArray = T4CRowidAccessor.stringToRowid(byArray, n24 += 2, 18);
                    n10 = 14;
                    long l = lArray[0];
                    n8 = (int)lArray[1];
                    s = 0;
                    long l2 = lArray[2];
                    int n26 = (int)lArray[3];
                    if (l == 0L && n8 == 0 && l2 == 0L && n26 == 0) {
                        this.meg.marshalUB1((short)0);
                        continue;
                    }
                    this.meg.marshalUB1((short)n10);
                    this.meg.marshalUB4(l);
                    this.meg.marshalUB2(n8);
                    this.meg.marshalUB1(s);
                    this.meg.marshalUB4(l2);
                    this.meg.marshalUB2(n26);
                    continue;
                }
                if (n11 < 1) {
                    this.meg.marshalUB1((short)0);
                    continue;
                }
                this.meg.marshalCLR(byArray, n24, n11);
                continue;
            }
            n5 = sArray[n15 + 9] & 0xFFFF;
            n4 = sArray[n15 + 2] & 0xFFFF;
            n3 = ((sArray[n15 + 3] & 0xFFFF) << 16) + (sArray[n15 + 4] & 0xFFFF) + n4 * n2 + 1;
            if (n14 == 996) {
                char c = cArray[n3 - 1];
                if (this.bufferCHAR == null || this.bufferCHAR.length < c) {
                    this.bufferCHAR = new byte[c];
                }
                for (n10 = 0; n10 < c; ++n10) {
                    this.bufferCHAR[n10] = (byte)((cArray[n3 + n10 / 2] & 0xFF00) >> 8 & 0xFF);
                    if (n10 >= c - '\u0001') continue;
                    this.bufferCHAR[n10 + 1] = (byte)(cArray[n3 + n10 / 2] & 0xFF & 0xFF);
                    ++n10;
                }
                this.meg.marshalCLR(this.bufferCHAR, c);
                if (this.bufferCHAR.length <= 4000) continue;
                this.bufferCHAR = null;
                continue;
            }
            if (n14 == 96) {
                n7 = n11 / 2;
                --n3;
            } else {
                n7 = (n11 - 2) / 2;
            }
            n6 = 0;
            n6 = n5 == 2 ? dBConversion.javaCharsToNCHARBytes(cArray, n3, byArray2, 0, n7) : dBConversion.javaCharsToCHARBytes(cArray, n3, byArray2, 0, n7);
            this.meg.marshalCLR(byArray2, n6);
        }
        if (n18 > 0) {
            for (n16 = 0; n16 < n18; ++n16) {
                InputStream inputStream;
                int n27 = nArray4[n16];
                n15 = n + 3 + 10 * n27;
                n14 = sArray[n15 + 0] & 0xFFFF;
                n13 = ((sArray[n15 + 7] & 0xFFFF) << 16) + (sArray[n15 + 8] & 0xFFFF) + n2;
                n12 = ((sArray[n15 + 5] & 0xFFFF) << 16) + (sArray[n15 + 6] & 0xFFFF) + n2;
                s2 = sArray[n12];
                n11 = sArray[n13] & 0xFFFF;
                n4 = sArray[n15 + 2] & 0xFFFF;
                n3 = ((sArray[n15 + 3] & 0xFFFF) << 16) + (sArray[n15 + 4] & 0xFFFF) + n4 * n2 + 1;
                if (s2 == -1) {
                    this.meg.marshalUB1((short)0);
                    continue;
                }
                if (n14 == 996) {
                    n10 = cArray[n3 - 1];
                    if (this.bufferCHAR == null || this.bufferCHAR.length < n10) {
                        this.bufferCHAR = new byte[n10];
                    }
                    for (int i = 0; i < n10; ++i) {
                        this.bufferCHAR[i] = (byte)((cArray[n3 + i / 2] & 0xFF00) >> 8 & 0xFF);
                        if (i >= n10 - 1) continue;
                        this.bufferCHAR[i + 1] = (byte)(cArray[n3 + i / 2] & 0xFF & 0xFF);
                        ++i;
                    }
                    this.meg.marshalCLR(this.bufferCHAR, n10);
                    if (this.bufferCHAR.length <= 4000) continue;
                    this.bufferCHAR = null;
                    continue;
                }
                if (n14 != 8 && n14 != 24) {
                    if (n14 == 96) {
                        n7 = n11 / 2;
                        --n3;
                    } else {
                        n7 = (n11 - 2) / 2;
                    }
                    n5 = sArray[n15 + 9] & 0xFFFF;
                    n6 = 0;
                    n6 = n5 == 2 ? dBConversion.javaCharsToNCHARBytes(cArray, n3, byArray2, 0, n7) : dBConversion.javaCharsToCHARBytes(cArray, n3, byArray2, 0, n7);
                    this.meg.marshalCLR(byArray2, n6);
                    continue;
                }
                n10 = n27;
                if (inputStreamArray == null || (inputStream = inputStreamArray[n10]) == null) continue;
                n9 = 64;
                if (this.buffer == null) {
                    this.buffer = new byte[n9];
                }
                n8 = 0;
                this.meg.marshalUB1((short)254);
                s = 0;
                while (s == 0) {
                    n8 = inputStream.read(this.buffer, 0, n9);
                    if (n8 < n9) {
                        s = 1;
                    }
                    if (n8 <= 0) continue;
                    this.meg.marshalUB1((short)(n8 & 0xFF));
                    this.meg.marshalB1Array(this.buffer, 0, n8);
                }
                this.meg.marshalSB1((byte)0);
            }
        }
        nArray2[0] = n18;
        nArray3[0] = nArray4;
    }

    boolean unmarshal(Accessor[] accessorArray, int n) throws SQLException, IOException {
        return this.unmarshal(accessorArray, 0, n);
    }

    boolean unmarshal(Accessor[] accessorArray, int n, int n2) throws SQLException, IOException {
        if (n == 0) {
            this.isFirstCol = true;
        }
        for (int i = n; i < n2 && i < accessorArray.length; ++i) {
            if (accessorArray[i] == null) continue;
            if (accessorArray[i].physicalColumnIndex < 0) {
                int n3 = 0;
                for (int j = 0; j < n2 && j < accessorArray.length; ++j) {
                    if (accessorArray[j] == null) continue;
                    accessorArray[j].physicalColumnIndex = n3++;
                    if (accessorArray[j].isUseLess) continue;
                }
            }
            if (this.bvcFound && !accessorArray[i].isUseLess) {
                if (this.bvcColSent.get(accessorArray[i].physicalColumnIndex)) {
                    if (accessorArray[i].unmarshalOneRow()) {
                        return true;
                    }
                    this.isFirstCol = false;
                    continue;
                }
                accessorArray[i].copyRow();
                continue;
            }
            if (accessorArray[i].unmarshalOneRow()) {
                return true;
            }
            this.isFirstCol = false;
        }
        this.bvcFound = false;
        return false;
    }

    boolean unmarshal(Accessor[] accessorArray, int n, int n2, int n3) throws SQLException, IOException {
        return false;
    }
}

