/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer.utils;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.SetOfIntegerSyntax;
import javax.print.attribute.standard.PageRanges;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.Timer;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.simpleviewer.gui.popups.PrintPanel;
import org.jpedal.exception.PdfException;
import org.jpedal.gui.GUIFactory;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class Printer {
    private static int printingThreads = 0;
    int rangeStart = 1;
    int rangeEnd = 1;
    int subset = 8;
    JComboBox scaling = null;
    boolean wasCancelled = false;
    boolean messageShown = false;
    boolean pagesReversed = false;
    Timer updatePrinterProgress = null;
    private ProgressMonitor status = null;
    private String dots = ".";

    public void printPDF(final PdfDecoder pdfDecoder, final GUIFactory gUIFactory) {
        ++printingThreads;
        Thread thread = new Thread(){

            public void run() {
                Object object;
                boolean bl = false;
                try {
                    object = PrinterJob.getPrinterJob();
                    PageFormat pageFormat = ((PrinterJob)object).defaultPage();
                    if (PdfDecoder.debugPrint) {
                        System.out.println("------------------------");
                        System.out.println("Default Page format used=" + pageFormat);
                        System.out.println("Orientation=" + pageFormat.getOrientation());
                        System.out.println("Width=" + pageFormat.getWidth() + " imageableW=" + pageFormat.getImageableWidth());
                        System.out.println("Height=" + pageFormat.getHeight() + " imageableH=" + pageFormat.getImageableHeight());
                        System.out.println("------------------------");
                    }
                    Paper paper = new Paper();
                    paper.setSize(595.0, 842.0);
                    paper.setImageableArea(43.0, 43.0, 509.0, 756.0);
                    pageFormat.setPaper(paper);
                    ((PrinterJob)object).setPageable(pdfDecoder);
                    HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
                    hashPrintRequestAttributeSet.add(new PageRanges(1, pdfDecoder.getPageCount()));
                    PrintPanel printPanel = null;
                    try {
                        printPanel = (PrintPanel)gUIFactory.printDialog(this.getAvailablePrinters(), ((PrinterJob)object).getPrintService().getName());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        printingThreads--;
                        JOptionPane.showMessageDialog(gUIFactory.getFrame(), "No printers setup");
                        return;
                    }
                    bl = printPanel.okClicked();
                    pdfDecoder.repaint();
                    Printer.this.setPrinter((PrinterJob)object, printPanel.getPrinter());
                    int n = 0;
                    Printer.this.subset = 8;
                    if (printPanel.isOddPagesOnly()) {
                        n = 16;
                        Printer.this.subset = 16;
                    } else if (printPanel.isEvenPagesOnly()) {
                        n = 32;
                        Printer.this.subset = 32;
                    }
                    Printer.this.pagesReversed = printPanel.isPagesReversed();
                    if (Printer.this.pagesReversed) {
                        n += 64;
                    }
                    pdfDecoder.setPrintPageMode(n);
                    SetOfIntegerSyntax setOfIntegerSyntax = printPanel.getPrintRange();
                    if (setOfIntegerSyntax == null) {
                        gUIFactory.showMessageDialog("No pages to print");
                    } else {
                        pdfDecoder.setPagePrintRange(setOfIntegerSyntax);
                        int n2 = Printer.this.rangeStart = setOfIntegerSyntax.next(0);
                        Printer.this.rangeEnd = Printer.this.rangeStart;
                        if (setOfIntegerSyntax.contains(Integer.MAX_VALUE)) {
                            Printer.this.rangeEnd = pdfDecoder.getPageCount();
                        } else {
                            while (setOfIntegerSyntax.next(n2) != -1) {
                                ++n2;
                            }
                            Printer.this.rangeEnd = n2;
                        }
                        ((PrinterJob)object).setCopies(printPanel.getCopies());
                        pdfDecoder.setPrintAutoRotateAndCenter(printPanel.isAutoRotateAndCenter());
                        pdfDecoder.setPrintCurrentView(printPanel.isPrintingCurrentView());
                        pdfDecoder.setPrintPageScalingMode(printPanel.getPageScaling());
                        pdfDecoder.setCenterOnScaling(true);
                        pageFormat.setPaper(printPanel.getSelectedPaper());
                        pdfDecoder.setPageFormat(pageFormat);
                        pdfDecoder.setUsePDFPaperSize(printPanel.isPaperSourceByPDFSize());
                    }
                    Printer.this.status = new ProgressMonitor(gUIFactory.getFrame(), "", "", 1, 100);
                    Printer.this.updatePrinterProgress = new Timer(1000, new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            int n = pdfDecoder.getCurrentPrintPage();
                            if (n > 0) {
                                Printer.this.updatePrinterProgess(pdfDecoder, n);
                            }
                            if (n == -1) {
                                (this).Printer.this.updatePrinterProgress.stop();
                                Printer.this.status.close();
                            }
                        }
                    });
                    Printer.this.updatePrinterProgress.setRepeats(true);
                    Printer.this.updatePrinterProgress.start();
                    if (bl) {
                        ((PrinterJob)object).print();
                    }
                }
                catch (PrinterException printerException) {
                    printerException.printStackTrace();
                    LogWriter.writeLog("Exception " + printerException + " printing");
                    gUIFactory.showMessageDialog(printerException.getMessage() + ' ' + printerException + ' ' + ' ' + printerException.getCause());
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Exception " + exception + " printing");
                    exception.printStackTrace();
                    gUIFactory.showMessageDialog("Exception " + exception);
                }
                catch (Error error) {
                    error.printStackTrace();
                    LogWriter.writeLog("Error " + error + " printing");
                    gUIFactory.showMessageDialog("Error " + error);
                }
                if (Printer.this.updatePrinterProgress != null) {
                    Printer.this.updatePrinterProgress.stop();
                    Printer.this.status.close();
                }
                if (!bl && !pdfDecoder.isPageSuccessful()) {
                    object = Messages.getMessage("PdfViewerError.ProblemsEncountered") + pdfDecoder.getPageFailureMessage() + '\n';
                    if (pdfDecoder.getPageFailureMessage().toLowerCase().indexOf("memory") != -1) {
                        object = (String)object + Messages.getMessage("PdfViewerError.RerunJava") + Messages.getMessage("PdfViewerError.RerunJava1") + Messages.getMessage("PdfViewerError.RerunJava2");
                    }
                    gUIFactory.showMessageDialog(object);
                }
                printingThreads--;
                pdfDecoder.invalidate();
                pdfDecoder.updateUI();
                pdfDecoder.repaint();
                if (bl && !Printer.this.wasCancelled) {
                    gUIFactory.showMessageDialog(Messages.getMessage("PdfViewerPrintingFinished"));
                    pdfDecoder.resetCurrentPrintPage();
                }
            }

            private String[] getAvailablePrinters() {
                PrintService[] printServiceArray = PrinterJob.lookupPrintServices();
                int n = printServiceArray.length;
                String[] stringArray = new String[n];
                for (int i = 0; i < n; ++i) {
                    stringArray[i] = printServiceArray[i].getName();
                }
                return stringArray;
            }
        };
        thread.start();
    }

    private void updatePrinterProgess(PdfDecoder pdfDecoder, int n) {
        boolean bl;
        int n2 = this.rangeEnd - this.rangeStart + 1;
        int n3 = n - this.rangeStart;
        int n4 = n2;
        int n5 = n3;
        int n6 = (int)((float)n5 / (float)n4 * 100.0f);
        if (this.status.isCanceled()) {
            pdfDecoder.stopPrinting();
            this.updatePrinterProgress.stop();
            this.status.close();
            this.wasCancelled = true;
            --printingThreads;
            if (!this.messageShown) {
                JOptionPane.showMessageDialog(null, Messages.getMessage("PdfViewerPrint.PrintingCanceled"));
                this.messageShown = true;
            }
            return;
        }
        this.dots = this.dots + '.';
        if (this.dots.length() > 8) {
            this.dots = ".";
        }
        boolean bl2 = bl = n3 <= 0;
        if (this.rangeStart == this.rangeEnd) {
            bl = false;
        }
        if (bl) {
            n2 = this.rangeStart - this.rangeEnd + 1;
        }
        int n7 = (int)((float)n3 / (float)n2 * 100.0f);
        if (!bl && n7 < 1) {
            n7 = 1;
        }
        if (bl) {
            n7 = -n7;
            n3 = -n3;
        }
        if (this.pagesReversed) {
            n7 = 100 - n7;
        }
        this.status.setProgress(n7);
        String string = "";
        if (this.subset == 16) {
            n4 = n4 / 2 + 1;
            n5 /= 2;
        } else if (this.subset == 32) {
            n4 = n4 / 2 + 1;
            n5 /= 2;
        }
        if (n4 == 1) {
            n6 = 50;
            n5 = 1;
            this.status.setProgress(n6);
        }
        string = n5 + " " + Messages.getMessage("PdfViewerPrint.Of") + ' ' + n4 + ": " + n6 + '%' + ' ' + this.dots;
        if (this.pagesReversed) {
            string = n4 - n5 + " " + Messages.getMessage("PdfViewerPrint.Of") + ' ' + n4 + ": " + n7 + '%' + ' ' + this.dots;
            this.status.setNote(Messages.getMessage("PdfViewerPrint.ReversedPrinting") + ' ' + string);
        } else if (bl) {
            this.status.setNote(Messages.getMessage("PdfViewerPrint.ReversedPrinting") + ' ' + string);
        } else {
            this.status.setNote(Messages.getMessage("PdfViewerPrint.Printing") + ' ' + string);
        }
    }

    public boolean isPrinting() {
        return printingThreads > 0;
    }

    private void setPrinter(PrinterJob printerJob, String string) throws PrinterException, PdfException {
        PrintService[] printServiceArray = PrinterJob.lookupPrintServices();
        boolean bl = false;
        int n = printServiceArray.length;
        for (int i = 0; i < n; ++i) {
            if (!printServiceArray[i].getName().equals(string)) continue;
            printerJob.setPrintService(printServiceArray[i]);
            i = n;
            bl = true;
        }
        if (!bl) {
            throw new PdfException("Unknown printer " + string);
        }
    }
}

