/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.table.AbstractTableModel;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.api.autoupdate.UpdateUnitProviderFactory;
import org.netbeans.modules.autoupdate.ui.SettingsTab;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SettingsTableModel
extends AbstractTableModel {
    private static final String[] COLUMN_NAME_KEYS = new String[]{"SettingsTable_ActiveColumn", "SettingsTable_NameColumn"};
    private static final Class[] COLUMN_TYPES = new Class[]{Boolean.class, UpdateUnitProvider.class};
    private List<UpdateUnitProvider> updateProviders;
    private Set<String> originalProviders;
    private SettingsTab settingsTab = null;
    private final Logger logger = Logger.getLogger("org.netbeans.modules.autoupdate.ui.SettingsTableModel");

    public SettingsTableModel() {
        this.refreshModel();
    }

    void setSettingsTab(SettingsTab settingsTab) {
        this.settingsTab = settingsTab;
    }

    SettingsTab getSettingsTab() {
        return this.settingsTab;
    }

    void refreshModel() {
        Set<String> set = this.originalProviders;
        HashSet<String> hashSet = new HashSet<String>();
        final ArrayList<UpdateUnitProvider> arrayList = new ArrayList<UpdateUnitProvider>();
        List list = UpdateUnitProviderFactory.getDefault().getUpdateUnitProviders(false);
        for (UpdateUnitProvider updateUnitProvider : list) {
            if (set != null && !set.contains(updateUnitProvider.getName()) && updateUnitProvider.isEnabled()) {
                arrayList.add(updateUnitProvider);
            }
            hashSet.add(updateUnitProvider.getName());
        }
        if (!arrayList.isEmpty()) {
            this.getSettingsTab().setWaitingState(true);
            Utilities.startAsWorkerThread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        Utilities.presentRefreshProviders(arrayList, SettingsTableModel.this.getSettingsTab().getPluginManager(), true);
                        SettingsTableModel.this.getSettingsTab().getPluginManager().updateUnitsChanged();
                        Object var2_1 = null;
                        SettingsTableModel.this.getSettingsTab().setWaitingState(false);
                    }
                    catch (Throwable throwable) {
                        Object var2_2 = null;
                        SettingsTableModel.this.getSettingsTab().setWaitingState(false);
                        throw throwable;
                    }
                }
            });
        }
        if (set != null && !set.isEmpty() && !hashSet.containsAll(set)) {
            this.getSettingsTab().setNeedRefresh();
        }
        this.updateProviders = new ArrayList<UpdateUnitProvider>(list);
        this.originalProviders = hashSet;
        SettingsTableModel.sortAlphabetically(this.updateProviders);
        this.fireTableDataChanged();
    }

    public void remove(int n) {
        UpdateUnitProvider updateUnitProvider = this.getUpdateUnitProvider(n);
        if (updateUnitProvider != null) {
            UpdateUnitProviderFactory.getDefault().remove(updateUnitProvider);
        }
        this.getSettingsTab().setNeedRefresh();
    }

    public void add(String string, String string2, URL uRL, boolean bl) {
        UpdateUnitProvider updateUnitProvider = UpdateUnitProviderFactory.getDefault().create(string, string2, uRL);
        updateUnitProvider.setEnable(bl);
    }

    public UpdateUnitProvider getUpdateUnitProvider(int n) {
        return n >= 0 && n < this.updateProviders.size() ? this.updateProviders.get(n) : null;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 0;
    }

    @Override
    public int getRowCount() {
        return this.updateProviders.size();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAME_KEYS.length;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        UpdateUnitProvider updateUnitProvider = this.getUpdateUnitProvider(n);
        switch (n2) {
            case 0: {
                boolean bl = updateUnitProvider.isEnabled();
                boolean bl2 = (Boolean)object;
                if (bl == bl2) break;
                updateUnitProvider.setEnable(bl2);
                if (bl2) {
                    this.getSettingsTab().refreshProvider(updateUnitProvider, false);
                    break;
                }
                this.getSettingsTab().setNeedRefresh();
            }
        }
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Object object = null;
        UpdateUnitProvider updateUnitProvider = this.updateProviders.get(n);
        switch (n2) {
            case 0: {
                object = updateUnitProvider.isEnabled();
                break;
            }
            case 1: {
                object = updateUnitProvider;
            }
        }
        return object;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return COLUMN_TYPES[n];
    }

    @Override
    public String getColumnName(int n) {
        return NbBundle.getMessage(SettingsTableModel.class, (String)COLUMN_NAME_KEYS[n]);
    }

    private static void sortAlphabetically(List<UpdateUnitProvider> list) {
        Collections.sort(list, new Comparator<UpdateUnitProvider>(){
            Collator COLL = Collator.getInstance();

            @Override
            public int compare(UpdateUnitProvider updateUnitProvider, UpdateUnitProvider updateUnitProvider2) {
                return this.COLL.compare(updateUnitProvider.getDisplayName(), updateUnitProvider2.getDisplayName());
            }
        });
    }
}

