"""\
Lisp generator functions for wxChoice objects

@copyright: 2002-2004 D. H. aka crazyinsomniac on sourceforge
@copyright: 2014 Carsten Grohmann
@license: MIT (see license.txt) - THIS PROGRAM COMES WITH NO WARRANTY
"""


import common
import wcodegen
from ChoicesCodeHandler import *


class LispChoiceGenerator(wcodegen.LispWidgetCodeWriter):
    tmpl = '(setf %(name)s (%(klass)s_Create %(parent)s %(id)s -1 -1 -1 ' \
           '-1 %(choices_len)s (vector %(choices)s)  %(style)s))\n'

# end of class LispChoiceGenerator


def initialize():
    klass = 'wxChoice'
    common.class_names['EditChoice'] = klass
    common.register('lisp', klass, LispChoiceGenerator(klass),
                    'choices', ChoicesCodeHandler)
