/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.history;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.net.URL;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.AbstractDialog;
import org.parosproxy.paros.model.Model;

@Deprecated
public class BrowserDialog
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    private static final String TITLE = "View in Browser: ";
    private static final Logger logger = Logger.getLogger(BrowserDialog.class);
    private JPanel jContentPane = null;
    private JPanel jPanelBottom = null;
    private JLabel jLabel = null;
    private JButton btnCapture = null;
    private JButton btnStop = null;
    private JButton btnClose = null;
    private Vector<URL> URLs = new Vector();
    private JPanel jPanel = null;

    public BrowserDialog() {
        this.initialize();
    }

    public BrowserDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initialize();
    }

    private void initialize() {
        this.setContentPane(this.getJContentPane());
        this.setDefaultCloseOperation(0);
        this.setTitle(TITLE);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                BrowserDialog.this.stop();
                BrowserDialog.this.setVisible(false);
            }
        });
        this.pack();
        if (Model.getSingleton().getOptionsParam().getViewParam().getWmUiHandlingOption() == 0) {
            this.setSize(640, 480);
        }
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJPanel(), "Center");
            this.jContentPane.add((Component)this.getJPanelBottom(), "South");
        }
        return this.jContentPane;
    }

    private JPanel getJPanelBottom() {
        if (this.jPanelBottom == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(5, 3, 5, 5);
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.gridx = 2;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.insets = new Insets(5, 3, 5, 2);
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridx = 3;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.insets = new Insets(5, 3, 5, 2);
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.gridx = 1;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.insets = new Insets(10, 5, 10, 2);
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.weighty = 1.0;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.gridx = 0;
            this.jLabel = new JLabel();
            this.jLabel.setText(" ");
            this.jLabel.setComponentOrientation(ComponentOrientation.UNKNOWN);
            this.jPanelBottom = new JPanel();
            this.jPanelBottom.setLayout(new GridBagLayout());
            this.jPanelBottom.add((Component)this.jLabel, gridBagConstraints4);
            this.jPanelBottom.add((Component)this.getBtnCapture(), gridBagConstraints3);
            this.jPanelBottom.add((Component)this.getBtnStop(), gridBagConstraints);
            this.jPanelBottom.add((Component)this.getBtnClose(), gridBagConstraints2);
        }
        return this.jPanelBottom;
    }

    private JButton getBtnCapture() {
        if (this.btnCapture == null) {
            this.btnCapture = new JButton();
            this.btnCapture.setText("Capture");
            this.btnCapture.setHorizontalAlignment(0);
            this.btnCapture.setHorizontalTextPosition(11);
            this.btnCapture.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    BrowserDialog.this.capture();
                }
            });
        }
        return this.btnCapture;
    }

    private JButton getBtnStop() {
        if (this.btnStop == null) {
            this.btnStop = new JButton();
            this.btnStop.setText("Stop");
            this.btnStop.setHorizontalAlignment(0);
            this.btnStop.setHorizontalTextPosition(11);
            this.btnStop.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    BrowserDialog.this.URLs.clear();
                    BrowserDialog.this.stop();
                }
            });
        }
        return this.btnStop;
    }

    private void stop() {
        Control.getSingleton().getProxy().setEnableCacheProcessing(false);
    }

    private void capture() {
        try {
            BufferedImage bufferedImage = new Robot().createScreenCapture(new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight() - this.jPanelBottom.getHeight()));
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    String string = file.getName();
                    return string.endsWith(".png");
                }

                @Override
                public String getDescription() {
                    return "*.png";
                }
            });
            jFileChooser.showSaveDialog(this);
            File file = jFileChooser.getSelectedFile();
            if (file != null) {
                ImageIO.write((RenderedImage)bufferedImage, "png", file);
            }
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    private JButton getBtnClose() {
        if (this.btnClose == null) {
            this.btnClose = new JButton();
            this.btnClose.setText("Close");
            this.btnClose.setVisible(false);
            this.btnClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    BrowserDialog.this.stop();
                }
            });
        }
        return this.btnClose;
    }

    public void addURL(URL uRL) {
        this.URLs.add(uRL);
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new CardLayout());
            this.jPanel.setPreferredSize(new Dimension(400, 300));
        }
        return this.jPanel;
    }

    void setURLTitle(String string) {
        this.setTitle(TITLE + string);
    }
}

