/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap;

import java.io.FileNotFoundException;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.varia.NullAppender;
import org.parosproxy.paros.CommandLine;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.model.Model;
import org.zaproxy.zap.HeadlessBootstrap;

public class CommandLineBootstrap
extends HeadlessBootstrap {
    private final Logger logger = Logger.getLogger(CommandLineBootstrap.class);

    public CommandLineBootstrap(CommandLine commandLine) {
        super(commandLine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int start() {
        int n = super.start();
        if (n != 0) {
            return n;
        }
        Logger.getRootLogger().removeAllAppenders();
        Logger.getRootLogger().addAppender((Appender)new NullAppender());
        Logger.getRootLogger().setLevel(Level.OFF);
        try {
            this.initModel();
        }
        catch (Exception exception) {
            if (exception instanceof FileNotFoundException) {
                System.out.println(Constant.messages.getString("start.db.error"));
                System.out.println(exception.getLocalizedMessage());
            }
            throw new RuntimeException(exception);
        }
        Control control = this.initControl(true);
        this.warnAddOnsAndExtensionsNoLongerRunnable();
        try {
            control.getExtensionLoader().hookCommandLineListener(this.getArgs());
            if (this.getArgs().isEnabled("-help") || this.getArgs().isEnabled("-h")) {
                System.out.println(this.getArgs().getHelp());
            } else if (this.getArgs().isReportVersion()) {
                System.out.println(Constant.PROGRAM_VERSION);
            } else if (this.handleCmdLineSessionArgsSynchronously(control)) {
                control.runCommandLine();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            } else {
                n = 1;
            }
        }
        catch (Exception exception) {
            this.logger.error((Object)exception.getMessage(), (Throwable)exception);
            System.out.println(exception.getMessage());
            System.out.println();
            System.out.println(this.getArgs().getHelp());
            n = 1;
        }
        finally {
            control.shutdown(Model.getSingleton().getOptionsParam().getDatabaseParam().isCompactDatabase());
            this.logger.info((Object)(Constant.PROGRAM_TITLE + " terminated."));
        }
        return n;
    }

    @Override
    protected Logger getLogger() {
        return this.logger;
    }
}

