/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.authentication;

import java.awt.EventQueue;
import java.io.IOException;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpSender;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.model.SessionStructure;
import org.zaproxy.zap.session.SessionManagementMethod;
import org.zaproxy.zap.users.User;
import org.zaproxy.zap.utils.Stats;

public class AuthenticationHelper {
    private HttpSender httpSender;
    private SessionManagementMethod sessionManagementMethod;
    private User user;
    private static final Logger log = Logger.getLogger(AuthenticationHelper.class);
    private static final String HISTORY_TAG_AUTHENTICATION = "Authentication";
    public static final String AUTH_SUCCESS_STATS = "stats.auth.success";
    public static final String AUTH_FAILURE_STATS = "stats.auth.failure";

    public AuthenticationHelper(HttpSender httpSender, SessionManagementMethod sessionManagementMethod, User user) {
        this.httpSender = httpSender;
        this.sessionManagementMethod = sessionManagementMethod;
        this.user = user;
    }

    @Deprecated
    public static void notifyOutputAuthSuccessful() {
        AuthenticationHelper.notifyOutputAuthSuccessful(null);
    }

    public static void notifyOutputAuthSuccessful(HttpMessage httpMessage) {
        if (httpMessage != null) {
            try {
                Stats.incCounter(SessionStructure.getHostName(httpMessage), AUTH_SUCCESS_STATS);
            }
            catch (URIException uRIException) {
                // empty catch block
            }
        }
        if (View.isInitialised()) {
            View.getSingleton().getOutputPanel().appendAsync(Constant.messages.getString("authentication.output.success") + "\n");
        }
    }

    public static void notifyOutputAuthFailure(HttpMessage httpMessage) {
        try {
            Stats.incCounter(SessionStructure.getHostName(httpMessage), AUTH_FAILURE_STATS);
        }
        catch (URIException uRIException) {
            // empty catch block
        }
        if (View.isInitialised()) {
            View.getSingleton().getOutputPanel().appendAsync(Constant.messages.getString("authentication.output.failure") + "\n");
        }
    }

    public HttpState getCorrespondingHttpState() {
        if (this.user.getAuthenticatedSession() == null) {
            this.user.setAuthenticatedSession(this.sessionManagementMethod.createEmptyWebSession());
        }
        return this.user.getCorrespondingHttpState();
    }

    public static void addAuthMessageToHistory(HttpMessage httpMessage) {
        try {
            ExtensionHistory extensionHistory;
            final HistoryReference historyReference = new HistoryReference(Model.getSingleton().getSession(), 11, httpMessage);
            historyReference.addTag(HISTORY_TAG_AUTHENTICATION);
            if (View.isInitialised() && (extensionHistory = Control.getSingleton().getExtensionLoader().getExtension(ExtensionHistory.class)) != null) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        extensionHistory.addHistory(historyReference);
                    }
                });
            }
        }
        catch (Exception exception) {
            log.error((Object)"Cannot add authentication message to History tab.", (Throwable)exception);
        }
    }

    public HttpMessage prepareMessage() {
        return AuthenticationHelper.prepareMessage(this.sessionManagementMethod, this.user);
    }

    public static HttpMessage prepareMessage(SessionManagementMethod sessionManagementMethod, User user) {
        HttpMessage httpMessage = new HttpMessage();
        if (user.getAuthenticatedSession() == null) {
            user.setAuthenticatedSession(sessionManagementMethod.createEmptyWebSession());
        }
        httpMessage.setRequestingUser(user);
        return httpMessage;
    }

    public User getRequestingUser() {
        if (this.user.getAuthenticatedSession() == null) {
            this.user.setAuthenticatedSession(this.sessionManagementMethod.createEmptyWebSession());
        }
        return this.user;
    }

    public void sendAndReceive(HttpMessage httpMessage) throws IOException {
        this.httpSender.sendAndReceive(httpMessage);
    }

    public void sendAndReceive(HttpMessage httpMessage, boolean bl) throws IOException {
        this.httpSender.sendAndReceive(httpMessage, bl);
    }

    public HttpSender getHttpSender() {
        return this.httpSender;
    }
}

