/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ascan;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.ScannerParam;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.zaproxy.zap.extension.ascan.ExtensionActiveScan;
import org.zaproxy.zap.utils.ZapNumberSpinner;
import org.zaproxy.zap.view.LayoutHelper;
import org.zaproxy.zap.view.PositiveValuesSlider;

public class OptionsScannerPanel
extends AbstractParamPanel {
    private static final long serialVersionUID = 1L;
    private JPanel panelScanner = null;
    private JSlider sliderHostPerScan = null;
    private JSlider sliderThreadsPerHost = null;
    private JSlider sliderDelayInMs = null;
    private JLabel labelThreadsPerHostValue = null;
    private JLabel labelDelayInMsValue = null;
    private ZapNumberSpinner spinnerMaxResultsList = null;
    private JCheckBox chkInjectPluginIdInHeader = null;
    private JCheckBox chkHandleAntiCrsfTokens = null;
    private JCheckBox chkPromptInAttackMode = null;
    private JCheckBox chkRescanInAttackMode = null;
    private JComboBox<String> defaultAscanPolicy = null;
    private JComboBox<String> defaultAttackPolicy = null;
    private JCheckBox allowAttackModeOnStart = null;
    private ZapNumberSpinner spinnerMaxChartTime = null;
    private ExtensionActiveScan extension;

    public OptionsScannerPanel(ExtensionActiveScan extensionActiveScan) {
        this.extension = extensionActiveScan;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new CardLayout());
        this.setName(Constant.messages.getString("ascan.options.title"));
        this.add(new JScrollPane(this.getPanelScanner()));
    }

    private JPanel getPanelScanner() {
        if (this.panelScanner == null) {
            this.panelScanner = new JPanel();
            this.panelScanner.setLayout(new GridBagLayout());
            this.panelScanner.setName("");
            this.panelScanner.add((Component)new JLabel(Constant.messages.getString("ascan.options.numHosts.label")), LayoutHelper.getGBC(0, 0, 3, 1.0, 0.0, 2));
            this.panelScanner.add((Component)this.getSliderHostPerScan(), LayoutHelper.getGBC(0, 1, 3, 1.0, 0.0, 2, new Insets(2, 2, 2, 2)));
            this.panelScanner.add((Component)new JLabel(Constant.messages.getString("ascan.options.numThreads.label")), LayoutHelper.getGBC(0, 2, 2, 1.0, 0.0, 2, new Insets(2, 2, 2, 2)));
            this.panelScanner.add((Component)this.getLabelThreadsPerHostValue(), LayoutHelper.getGBC(2, 2, 1, 1.0, 0.0, 2, new Insets(2, 2, 2, 2)));
            this.panelScanner.add((Component)this.getSliderThreadsPerHost(), LayoutHelper.getGBC(0, 3, 3, 1.0, 0.0, 2, new Insets(2, 2, 2, 2)));
            this.panelScanner.add((Component)new JLabel(Constant.messages.getString("ascan.options.maxRes.label")), LayoutHelper.getGBC(0, 4, 1, 0.0, 0.0, 2, new Insets(2, 2, 2, 2)));
            this.panelScanner.add((Component)this.getSpinnerMaxResultsList(), LayoutHelper.getGBC(1, 4, 2, 0.0, 0.0, 2, new Insets(2, 2, 2, 2)));
            this.panelScanner.add((Component)new JLabel(Constant.messages.getString("ascan.options.delayInMs.label")), LayoutHelper.getGBC(0, 5, 2, 1.0, 0.0, 2, new Insets(2, 2, 2, 2)));
            this.panelScanner.add((Component)this.getLabelDelayInMsValue(), LayoutHelper.getGBC(2, 5, 1, 1.0, 0.0, 2, new Insets(2, 2, 2, 2)));
            this.panelScanner.add((Component)this.getSliderDelayInMs(), LayoutHelper.getGBC(0, 6, 3, 1.0, 0.0, 2, new Insets(2, 2, 2, 2)));
            this.panelScanner.add((Component)this.getChkInjectPluginIdInHeader(), LayoutHelper.getGBC(0, 7, 3, 1.0, 0.0, 2, new Insets(16, 2, 2, 2)));
            this.panelScanner.add((Component)this.getChkHandleAntiCSRFTokens(), LayoutHelper.getGBC(0, 8, 3, 1.0, 0.0, 2, new Insets(16, 2, 2, 2)));
            this.panelScanner.add((Component)this.getChkPromptInAttackMode(), LayoutHelper.getGBC(0, 9, 3, 1.0, 0.0, 2, new Insets(16, 2, 2, 2)));
            this.panelScanner.add((Component)this.getChkRescanInAttackMode(), LayoutHelper.getGBC(0, 10, 3, 1.0, 0.0, 2, new Insets(16, 2, 2, 2)));
            this.panelScanner.add((Component)new JLabel(Constant.messages.getString("ascan.options.policy.ascan.label")), LayoutHelper.getGBC(0, 11, 1, 0.0, 0.0, 2, new Insets(16, 2, 2, 2)));
            this.panelScanner.add(this.getDefaultAscanPolicyPulldown(), LayoutHelper.getGBC(1, 11, 2, 0.0, 0.0, 2, new Insets(16, 2, 2, 2)));
            this.panelScanner.add((Component)new JLabel(Constant.messages.getString("ascan.options.policy.attack.label")), LayoutHelper.getGBC(0, 12, 1, 0.0, 0.0, 2, new Insets(2, 2, 2, 2)));
            this.panelScanner.add(this.getDefaultAttackPolicyPulldown(), LayoutHelper.getGBC(1, 12, 2, 0.0, 0.0, 2, new Insets(2, 2, 2, 2)));
            this.panelScanner.add((Component)this.getAllowAttackModeOnStart(), LayoutHelper.getGBC(0, 13, 3, 1.0, 0.0, 2, new Insets(16, 2, 2, 2)));
            this.panelScanner.add((Component)new JLabel(Constant.messages.getString("ascan.options.maxChart.label")), LayoutHelper.getGBC(0, 14, 1, 0.0, 0.0, 2, new Insets(2, 2, 2, 2)));
            this.panelScanner.add((Component)this.getSpinnerMaxChartTime(), LayoutHelper.getGBC(1, 14, 2, 0.0, 0.0, 2, new Insets(2, 2, 2, 2)));
            this.panelScanner.add((Component)new JLabel(), LayoutHelper.getGBC(0, 30, 3, 1.0, 1.0, 1));
        }
        return this.panelScanner;
    }

    private JComboBox<String> getDefaultAscanPolicyPulldown() {
        if (this.defaultAscanPolicy == null) {
            this.defaultAscanPolicy = new JComboBox();
        }
        return this.defaultAscanPolicy;
    }

    private JComboBox<String> getDefaultAttackPolicyPulldown() {
        if (this.defaultAttackPolicy == null) {
            this.defaultAttackPolicy = new JComboBox();
        }
        return this.defaultAttackPolicy;
    }

    private void initPolicyPulldowns() {
        this.getDefaultAscanPolicyPulldown().removeAllItems();
        this.getDefaultAttackPolicyPulldown().removeAllItems();
        for (String string : this.extension.getPolicyManager().getAllPolicyNames()) {
            this.getDefaultAscanPolicyPulldown().addItem(string);
            this.getDefaultAttackPolicyPulldown().addItem(string);
        }
    }

    @Override
    public void initParam(Object object) {
        OptionsParam optionsParam = (OptionsParam)object;
        ScannerParam scannerParam = optionsParam.getParamSet(ScannerParam.class);
        this.getSliderHostPerScan().setValue(scannerParam.getHostPerScan());
        this.getSliderThreadsPerHost().setValue(scannerParam.getThreadPerHost());
        this.getSliderDelayInMs().setValue(scannerParam.getDelayInMs());
        this.setLabelDelayInMsValue(scannerParam.getDelayInMs());
        this.getSpinnerMaxResultsList().setValue(scannerParam.getMaxResultsToList());
        this.getChkInjectPluginIdInHeader().setSelected(scannerParam.isInjectPluginIdInHeader());
        this.getChkHandleAntiCSRFTokens().setSelected(scannerParam.getHandleAntiCSRFTokens());
        this.getChkPromptInAttackMode().setSelected(scannerParam.isPromptInAttackMode());
        this.getChkRescanInAttackMode().setSelected(scannerParam.isRescanInAttackMode());
        this.getChkRescanInAttackMode().setEnabled(!this.getChkPromptInAttackMode().isSelected());
        this.initPolicyPulldowns();
        this.getDefaultAscanPolicyPulldown().setSelectedItem(scannerParam.getDefaultPolicy());
        this.getDefaultAttackPolicyPulldown().setSelectedItem(scannerParam.getAttackPolicy());
        this.getAllowAttackModeOnStart().setSelected(scannerParam.isAllowAttackOnStart());
        this.getSpinnerMaxChartTime().setValue(scannerParam.getMaxChartTimeInMins());
    }

    @Override
    public void validateParam(Object object) {
    }

    @Override
    public void saveParam(Object object) throws Exception {
        OptionsParam optionsParam = (OptionsParam)object;
        ScannerParam scannerParam = optionsParam.getParamSet(ScannerParam.class);
        scannerParam.setHostPerScan(this.getSliderHostPerScan().getValue());
        scannerParam.setThreadPerHost(this.getSliderThreadsPerHost().getValue());
        scannerParam.setDelayInMs(this.getDelayInMs());
        scannerParam.setMaxResultsToList(this.getSpinnerMaxResultsList().getValue());
        scannerParam.setInjectPluginIdInHeader(this.getChkInjectPluginIdInHeader().isSelected());
        scannerParam.setHandleAntiCSRFTokens(this.getChkHandleAntiCSRFTokens().isSelected());
        scannerParam.setPromptInAttackMode(this.getChkPromptInAttackMode().isSelected());
        scannerParam.setRescanInAttackMode(this.getChkRescanInAttackMode().isSelected());
        scannerParam.setDefaultPolicy((String)this.getDefaultAscanPolicyPulldown().getSelectedItem());
        scannerParam.setAttackPolicy((String)this.getDefaultAttackPolicyPulldown().getSelectedItem());
        scannerParam.setAllowAttackOnStart(this.getAllowAttackModeOnStart().isSelected());
        scannerParam.setMaxChartTimeInMins(this.getSpinnerMaxChartTime().getValue());
    }

    private JSlider getSliderHostPerScan() {
        if (this.sliderHostPerScan == null) {
            this.sliderHostPerScan = new JSlider();
            this.sliderHostPerScan.setMaximum(5);
            this.sliderHostPerScan.setMinimum(1);
            this.sliderHostPerScan.setMinorTickSpacing(1);
            this.sliderHostPerScan.setPaintTicks(true);
            this.sliderHostPerScan.setPaintLabels(true);
            this.sliderHostPerScan.setName("");
            this.sliderHostPerScan.setMajorTickSpacing(1);
            this.sliderHostPerScan.setSnapToTicks(true);
            this.sliderHostPerScan.setPaintTrack(true);
        }
        return this.sliderHostPerScan;
    }

    private JSlider getSliderThreadsPerHost() {
        if (this.sliderThreadsPerHost == null) {
            this.sliderThreadsPerHost = new PositiveValuesSlider(50);
            this.sliderThreadsPerHost.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    OptionsScannerPanel.this.setLabelThreadsPerHostValue(OptionsScannerPanel.this.getSliderThreadsPerHost().getValue());
                }
            });
        }
        return this.sliderThreadsPerHost;
    }

    private JSlider getSliderDelayInMs() {
        if (this.sliderDelayInMs == null) {
            this.sliderDelayInMs = new JSlider();
            this.sliderDelayInMs.setMaximum(1000);
            this.sliderDelayInMs.setMinimum(0);
            this.sliderDelayInMs.setValue(0);
            this.sliderDelayInMs.setPaintTicks(true);
            this.sliderDelayInMs.setPaintLabels(true);
            this.sliderDelayInMs.setMinorTickSpacing(25);
            this.sliderDelayInMs.setMajorTickSpacing(100);
            this.sliderDelayInMs.setSnapToTicks(true);
            this.sliderDelayInMs.setPaintTrack(true);
            this.sliderDelayInMs.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    OptionsScannerPanel.this.setLabelDelayInMsValue(OptionsScannerPanel.this.getSliderDelayInMs().getValue());
                }
            });
        }
        return this.sliderDelayInMs;
    }

    public int getDelayInMs() {
        return this.sliderDelayInMs.getValue();
    }

    public void setLabelDelayInMsValue(int n) {
        if (this.labelDelayInMsValue == null) {
            this.labelDelayInMsValue = new JLabel();
        }
        String string = (n = (n + 13) / 25 * 25) < 10 ? "   " + n : (n < 100 ? "  " + n : (n < 1000 ? " " + n : Integer.toString(n)));
        this.labelDelayInMsValue.setText(string);
    }

    public JLabel getLabelDelayInMsValue() {
        if (this.labelDelayInMsValue == null) {
            this.setLabelDelayInMsValue(this.getSliderDelayInMs().getValue());
        }
        return this.labelDelayInMsValue;
    }

    private void setLabelThreadsPerHostValue(int n) {
        if (this.labelThreadsPerHostValue == null) {
            this.labelThreadsPerHostValue = new JLabel();
        }
        this.labelThreadsPerHostValue.setText(String.valueOf(n));
    }

    private JLabel getLabelThreadsPerHostValue() {
        if (this.labelThreadsPerHostValue == null) {
            this.setLabelThreadsPerHostValue(this.getSliderThreadsPerHost().getValue());
        }
        return this.labelThreadsPerHostValue;
    }

    private ZapNumberSpinner getSpinnerMaxResultsList() {
        if (this.spinnerMaxResultsList == null) {
            this.spinnerMaxResultsList = new ZapNumberSpinner();
            this.spinnerMaxResultsList.setToolTipText(Constant.messages.getString("ascan.options.maxRes.tooltip"));
        }
        return this.spinnerMaxResultsList;
    }

    private ZapNumberSpinner getSpinnerMaxChartTime() {
        if (this.spinnerMaxChartTime == null) {
            this.spinnerMaxChartTime = new ZapNumberSpinner();
            this.spinnerMaxChartTime.setToolTipText(Constant.messages.getString("ascan.options.maxChart.tooltip"));
        }
        return this.spinnerMaxChartTime;
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.options.ascan";
    }

    private JCheckBox getChkInjectPluginIdInHeader() {
        if (this.chkInjectPluginIdInHeader == null) {
            this.chkInjectPluginIdInHeader = new JCheckBox();
            this.chkInjectPluginIdInHeader.setText(Constant.messages.getString("ascan.options.pluginHeader.label"));
        }
        return this.chkInjectPluginIdInHeader;
    }

    private JCheckBox getChkHandleAntiCSRFTokens() {
        if (this.chkHandleAntiCrsfTokens == null) {
            this.chkHandleAntiCrsfTokens = new JCheckBox();
            this.chkHandleAntiCrsfTokens.setText(Constant.messages.getString("ascan.options.anticsrf.label"));
        }
        return this.chkHandleAntiCrsfTokens;
    }

    private JCheckBox getChkPromptInAttackMode() {
        if (this.chkPromptInAttackMode == null) {
            this.chkPromptInAttackMode = new JCheckBox(Constant.messages.getString("ascan.options.attackPrompt.label"));
            this.chkPromptInAttackMode.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OptionsScannerPanel.this.getChkRescanInAttackMode().setEnabled(!OptionsScannerPanel.this.chkPromptInAttackMode.isSelected());
                }
            });
        }
        return this.chkPromptInAttackMode;
    }

    private JCheckBox getChkRescanInAttackMode() {
        if (this.chkRescanInAttackMode == null) {
            this.chkRescanInAttackMode = new JCheckBox(Constant.messages.getString("ascan.options.attackRescan.label"));
        }
        return this.chkRescanInAttackMode;
    }

    private JCheckBox getAllowAttackModeOnStart() {
        if (this.allowAttackModeOnStart == null) {
            this.allowAttackModeOnStart = new JCheckBox(Constant.messages.getString("ascan.options.attackOnStart.label"));
        }
        return this.allowAttackModeOnStart;
    }
}

