/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.brk;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXTable;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.AbstractPanel;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.brk.BreakpointMessageInterface;
import org.zaproxy.zap.extension.brk.BreakpointsTableModel;
import org.zaproxy.zap.extension.brk.ExtensionBreak;

public class BreakpointsPanel
extends AbstractPanel {
    private static final long serialVersionUID = 1L;
    public static final String PANEL_NAME = "breakpoints";
    private ExtensionBreak extension;
    private JPanel panelCommand = null;
    private JLabel jLabel = null;
    private JScrollPane jScrollPane = null;
    private JXTable breakpointsTable = null;
    private BreakpointsTableModel model = new BreakpointsTableModel();
    private static final String BRK_TABLE = "brk.table";
    private static final String PREF_COLUMN_WIDTH = "column.width";
    private final Preferences preferences;
    private final String prefnzPrefix = this.getClass().getSimpleName() + ".";
    private static Logger log = Logger.getLogger(BreakpointsPanel.class);

    public BreakpointsPanel(ExtensionBreak extensionBreak) {
        this.extension = extensionBreak;
        this.preferences = Preferences.userNodeForPackage(this.getClass());
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new CardLayout());
        this.setSize(474, 251);
        this.setName(Constant.messages.getString("brk.panel.title"));
        this.setIcon(new ImageIcon(BreakpointsPanel.class.getResource("/resource/icon/16/101.png")));
        this.setDefaultAccelerator(KeyStroke.getKeyStroke(66, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 8 | 1, false));
        this.setMnemonic(Constant.messages.getChar("brk.panel.mnemonic"));
        this.add((Component)this.getPanelCommand(), this.getPanelCommand().getName());
    }

    private JPanel getPanelCommand() {
        if (this.panelCommand == null) {
            this.panelCommand = new JPanel();
            this.panelCommand.setLayout(new GridBagLayout());
            this.panelCommand.setName(Constant.messages.getString("brk.panel.title"));
            this.jLabel = this.getJLabel();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints2.anchor = 18;
            this.panelCommand.add((Component)this.getJScrollPane(), gridBagConstraints2);
        }
        return this.panelCommand;
    }

    private JLabel getJLabel() {
        if (this.jLabel == null) {
            this.jLabel = new JLabel();
            this.jLabel.setText(" ");
        }
        return this.jLabel;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView((Component)this.getBreakpoints());
        }
        return this.jScrollPane;
    }

    protected JXTable getBreakpoints() {
        if (this.breakpointsTable == null) {
            this.breakpointsTable = new JXTable((TableModel)this.model);
            this.breakpointsTable.setColumnSelectionAllowed(false);
            this.breakpointsTable.setCellSelectionEnabled(false);
            this.breakpointsTable.setRowSelectionAllowed(true);
            this.breakpointsTable.setColumnControlVisible(true);
            this.breakpointsTable.getColumnModel().getColumn(0).setPreferredWidth(this.restoreColumnWidth(BRK_TABLE, 100));
            this.breakpointsTable.getColumnModel().getColumn(0).addPropertyChangeListener(new ColumnResizedListener(BRK_TABLE));
            this.breakpointsTable.getColumnModel().getColumn(0).setMaxWidth(250);
            this.breakpointsTable.getTableHeader().setReorderingAllowed(false);
            this.breakpointsTable.setName(PANEL_NAME);
            this.breakpointsTable.setDoubleBuffered(true);
            this.breakpointsTable.setSelectionMode(0);
            this.breakpointsTable.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    this.showPopupMenuIfTriggered(mouseEvent);
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    this.showPopupMenuIfTriggered(mouseEvent);
                }

                private void showPopupMenuIfTriggered(MouseEvent mouseEvent) {
                    if (mouseEvent.isPopupTrigger()) {
                        int n = BreakpointsPanel.this.breakpointsTable.rowAtPoint(mouseEvent.getPoint());
                        if (n < 0 || !BreakpointsPanel.this.breakpointsTable.getSelectionModel().isSelectedIndex(n)) {
                            BreakpointsPanel.this.breakpointsTable.getSelectionModel().clearSelection();
                            if (n >= 0) {
                                BreakpointsPanel.this.breakpointsTable.getSelectionModel().setSelectionInterval(n, n);
                            }
                        }
                        View.getSingleton().getPopupMenu().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    }
                }

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() > 1) {
                        BreakpointsPanel.this.extension.editUiSelectedBreakpoint();
                    }
                }
            });
        }
        return this.breakpointsTable;
    }

    public BreakpointMessageInterface getSelectedBreakpoint() {
        int n = this.breakpointsTable.getSelectedRow();
        if (n != -1) {
            return this.model.getBreakpointAtRow(n);
        }
        return null;
    }

    private void selectRowAndEnsureVisible(int n) {
        if (n != -1) {
            this.breakpointsTable.getSelectionModel().setSelectionInterval(n, n);
            this.breakpointsTable.scrollRectToVisible(this.breakpointsTable.getCellRect(n, 0, true));
        }
    }

    private void addBreakpointModel(BreakpointMessageInterface breakpointMessageInterface) {
        this.model.addBreakpoint(breakpointMessageInterface);
        this.selectRowAndEnsureVisible(this.model.getLastAffectedRow());
    }

    void addBreakpoint(final BreakpointMessageInterface breakpointMessageInterface) {
        if (EventQueue.isDispatchThread()) {
            this.addBreakpointModel(breakpointMessageInterface);
            return;
        }
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    BreakpointsPanel.this.addBreakpointModel(breakpointMessageInterface);
                }
            });
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    private void editBreakpointModel(BreakpointMessageInterface breakpointMessageInterface, BreakpointMessageInterface breakpointMessageInterface2) {
        this.model.editBreakpoint(breakpointMessageInterface, breakpointMessageInterface2);
        this.selectRowAndEnsureVisible(this.model.getLastAffectedRow());
    }

    void editBreakpoint(final BreakpointMessageInterface breakpointMessageInterface, final BreakpointMessageInterface breakpointMessageInterface2) {
        if (EventQueue.isDispatchThread()) {
            this.editBreakpointModel(breakpointMessageInterface, breakpointMessageInterface2);
            return;
        }
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    BreakpointsPanel.this.editBreakpointModel(breakpointMessageInterface, breakpointMessageInterface2);
                }
            });
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    private void removeBreakpointModel(BreakpointMessageInterface breakpointMessageInterface) {
        this.model.removeBreakpoint(breakpointMessageInterface);
    }

    public void removeBreakpoint(final BreakpointMessageInterface breakpointMessageInterface) {
        if (EventQueue.isDispatchThread()) {
            this.removeBreakpointModel(breakpointMessageInterface);
            return;
        }
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    BreakpointsPanel.this.removeBreakpointModel(breakpointMessageInterface);
                }
            });
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    private void saveColumnWidth(String string, int n) {
        if (n > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Saving preference " + this.prefnzPrefix + string + "." + PREF_COLUMN_WIDTH + "=" + n));
            }
            this.preferences.put(this.prefnzPrefix + string + "." + PREF_COLUMN_WIDTH, Integer.toString(n));
            try {
                this.preferences.flush();
            }
            catch (BackingStoreException backingStoreException) {
                log.error((Object)"Error while saving the preferences", (Throwable)backingStoreException);
            }
        }
    }

    private int restoreColumnWidth(String string, int n) {
        int n2 = n;
        String string2 = this.preferences.get(this.prefnzPrefix + string + "." + PREF_COLUMN_WIDTH, null);
        if (string2 != null) {
            int n3 = 0;
            try {
                n3 = Integer.parseInt(string2.trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n3 > 0) {
                n2 = n3;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Restoring preference " + this.prefnzPrefix + string + "." + PREF_COLUMN_WIDTH + "=" + n3));
                }
            }
        }
        return n2;
    }

    private final class ColumnResizedListener
    implements PropertyChangeListener {
        private final String prefix;

        public ColumnResizedListener(String string) {
            assert (string != null);
            this.prefix = string;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            TableColumn tableColumn = (TableColumn)propertyChangeEvent.getSource();
            if (tableColumn != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(BreakpointsPanel.this.prefnzPrefix + this.prefix + "." + BreakpointsPanel.PREF_COLUMN_WIDTH + "=" + tableColumn.getWidth()));
                }
                BreakpointsPanel.this.saveColumnWidth(this.prefix, tableColumn.getWidth());
            }
        }
    }
}

