/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.encoder2;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.encoder.Encoder;
import org.parosproxy.paros.view.AbstractFrame;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.encoder2.EncodeDecodeParam;
import org.zaproxy.zap.utils.FontUtils;
import org.zaproxy.zap.utils.ZapTextArea;

public class EncodeDecodeDialog
extends AbstractFrame {
    private static final long serialVersionUID = 1L;
    public static final String ENCODE_DECODE_FIELD = "EncodeDecodeInputField";
    public static final String ENCODE_DECODE_RESULTFIELD = "EncodeDecodeResultField";
    private static final Logger log = Logger.getLogger(EncodeDecodeDialog.class);
    private JTabbedPane jTabbed = null;
    private JPanel jPanel = null;
    private ZapTextArea inputField = null;
    private ZapTextArea base64EncodeField = null;
    private ZapTextArea base64DecodeField = null;
    private ZapTextArea urlEncodeField = null;
    private ZapTextArea urlDecodeField = null;
    private ZapTextArea asciiHexEncodeField = null;
    private ZapTextArea asciiHexDecodeField = null;
    private ZapTextArea HTMLEncodeField = null;
    private ZapTextArea HTMLDecodeField = null;
    private ZapTextArea JavaScriptEncodeField = null;
    private ZapTextArea JavaScriptDecodeField = null;
    private ZapTextArea sha1HashField = null;
    private ZapTextArea md5HashField = null;
    private ZapTextArea illegalUTF82ByteField = null;
    private ZapTextArea illegalUTF83ByteField = null;
    private ZapTextArea illegalUTF84ByteField = null;
    private Encoder encoder = null;

    public EncodeDecodeDialog() throws HeadlessException {
        this.initialize();
    }

    private void initialize() {
        this.setAlwaysOnTop(false);
        this.setContentPane(this.getJTabbed());
        this.setTitle(Constant.messages.getString("enc2.title"));
    }

    private void addField(JPanel jPanel, int n, JComponent jComponent, String string) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(jComponent);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setBorder(BorderFactory.createTitledBorder(null, string, 0, 0, FontUtils.getFont(FontUtils.Size.standard), Color.black));
        jPanel.add((Component)jScrollPane, gridBagConstraints);
    }

    private JPanel getJTabbed() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setPreferredSize(new Dimension(800, 600));
            this.jPanel.setLayout(new GridBagLayout());
            this.jTabbed = new JTabbedPane();
            this.jTabbed.setPreferredSize(new Dimension(800, 500));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new GridBagLayout());
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new GridBagLayout());
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new GridBagLayout());
            this.addField(jPanel, 1, this.getBase64EncodeField(), Constant.messages.getString("enc2.label.b64Enc"));
            this.addField(jPanel, 2, this.getUrlEncodeField(), Constant.messages.getString("enc2.label.urlEnc"));
            this.addField(jPanel, 3, this.getAsciiHexEncodeField(), Constant.messages.getString("enc2.label.asciiEnc"));
            this.addField(jPanel, 4, this.getHTMLEncodeField(), Constant.messages.getString("enc2.label.HTMLEnc"));
            this.addField(jPanel, 5, this.getJavaScriptEncodeField(), Constant.messages.getString("enc2.label.JavaScriptEnc"));
            this.addField(jPanel2, 1, this.getBase64DecodeField(), Constant.messages.getString("enc2.label.b64Dec"));
            this.addField(jPanel2, 2, this.getUrlDecodeField(), Constant.messages.getString("enc2.label.urlDec"));
            this.addField(jPanel2, 3, this.getAsciiHexDecodeField(), Constant.messages.getString("enc2.label.asciiDec"));
            this.addField(jPanel2, 4, this.getHTMLDecodeField(), Constant.messages.getString("enc2.label.HTMLDec"));
            this.addField(jPanel2, 5, this.getJavaScriptDecodeField(), Constant.messages.getString("enc2.label.JavaScriptDec"));
            this.addField(jPanel3, 1, this.getSha1HashField(), Constant.messages.getString("enc2.label.sha1Hash"));
            this.addField(jPanel3, 2, this.getMd5HashField(), Constant.messages.getString("enc2.label.md5Hash"));
            this.addField(jPanel4, 1, this.getIllegalUTF82ByteField(), Constant.messages.getString("enc2.label.illegalUTF8.2byte"));
            this.addField(jPanel4, 2, this.getIllegalUTF83ByteField(), Constant.messages.getString("enc2.label.illegalUTF8.3byte"));
            this.addField(jPanel4, 3, this.getIllegalUTF84ByteField(), Constant.messages.getString("enc2.label.illegalUTF8.4byte"));
            this.jTabbed.addTab(Constant.messages.getString("enc2.tab.encode"), jPanel);
            this.jTabbed.addTab(Constant.messages.getString("enc2.tab.decode"), jPanel2);
            this.jTabbed.addTab(Constant.messages.getString("enc2.tab.hash"), jPanel3);
            this.jTabbed.addTab(Constant.messages.getString("enc2.tab.illegalUTF8"), jPanel4);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.insets = new Insets(1, 1, 1, 1);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.25;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 2;
            gridBagConstraints2.insets = new Insets(1, 1, 1, 1);
            gridBagConstraints2.anchor = 18;
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.setViewportView(this.getInputField());
            jScrollPane.setHorizontalScrollBarPolicy(31);
            jScrollPane.setBorder(BorderFactory.createTitledBorder(null, Constant.messages.getString("enc2.label.text"), 0, 0, FontUtils.getFont(FontUtils.Size.standard), Color.black));
            this.jPanel.add((Component)jScrollPane, gridBagConstraints);
            this.jPanel.add((Component)this.jTabbed, gridBagConstraints2);
            jPanel2.requestFocus();
        }
        return this.jPanel;
    }

    private ZapTextArea newField(boolean bl) {
        ZapTextArea zapTextArea = new ZapTextArea();
        zapTextArea.setLineWrap(true);
        zapTextArea.setBorder(BorderFactory.createEtchedBorder());
        zapTextArea.setEditable(bl);
        zapTextArea.setName(ENCODE_DECODE_RESULTFIELD);
        zapTextArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    View.getSingleton().getPopupMenu().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        return zapTextArea;
    }

    private ZapTextArea getInputField() {
        if (this.inputField == null) {
            this.inputField = this.newField(true);
            this.inputField.setName(ENCODE_DECODE_FIELD);
            this.inputField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    EncodeDecodeDialog.this.updateEncodeDecodeFields();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    EncodeDecodeDialog.this.updateEncodeDecodeFields();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                }
            });
            this.inputField.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                        View.getSingleton().getPopupMenu().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            });
        }
        return this.inputField;
    }

    private ZapTextArea getBase64EncodeField() {
        if (this.base64EncodeField == null) {
            this.base64EncodeField = this.newField(false);
        }
        return this.base64EncodeField;
    }

    private ZapTextArea getBase64DecodeField() {
        if (this.base64DecodeField == null) {
            this.base64DecodeField = this.newField(false);
        }
        return this.base64DecodeField;
    }

    private ZapTextArea getUrlEncodeField() {
        if (this.urlEncodeField == null) {
            this.urlEncodeField = this.newField(false);
        }
        return this.urlEncodeField;
    }

    private ZapTextArea getUrlDecodeField() {
        if (this.urlDecodeField == null) {
            this.urlDecodeField = this.newField(false);
        }
        return this.urlDecodeField;
    }

    private ZapTextArea getAsciiHexEncodeField() {
        if (this.asciiHexEncodeField == null) {
            this.asciiHexEncodeField = this.newField(false);
        }
        return this.asciiHexEncodeField;
    }

    private ZapTextArea getAsciiHexDecodeField() {
        if (this.asciiHexDecodeField == null) {
            this.asciiHexDecodeField = this.newField(false);
        }
        return this.asciiHexDecodeField;
    }

    private ZapTextArea getHTMLEncodeField() {
        if (this.HTMLEncodeField == null) {
            this.HTMLEncodeField = this.newField(false);
        }
        return this.HTMLEncodeField;
    }

    private ZapTextArea getHTMLDecodeField() {
        if (this.HTMLDecodeField == null) {
            this.HTMLDecodeField = this.newField(false);
        }
        return this.HTMLDecodeField;
    }

    private ZapTextArea getJavaScriptEncodeField() {
        if (this.JavaScriptEncodeField == null) {
            this.JavaScriptEncodeField = this.newField(false);
        }
        return this.JavaScriptEncodeField;
    }

    private ZapTextArea getJavaScriptDecodeField() {
        if (this.JavaScriptDecodeField == null) {
            this.JavaScriptDecodeField = this.newField(false);
        }
        return this.JavaScriptDecodeField;
    }

    private ZapTextArea getSha1HashField() {
        if (this.sha1HashField == null) {
            this.sha1HashField = this.newField(false);
        }
        return this.sha1HashField;
    }

    private ZapTextArea getMd5HashField() {
        if (this.md5HashField == null) {
            this.md5HashField = this.newField(false);
        }
        return this.md5HashField;
    }

    private ZapTextArea getIllegalUTF82ByteField() {
        if (this.illegalUTF82ByteField == null) {
            this.illegalUTF82ByteField = this.newField(false);
        }
        return this.illegalUTF82ByteField;
    }

    private ZapTextArea getIllegalUTF83ByteField() {
        if (this.illegalUTF83ByteField == null) {
            this.illegalUTF83ByteField = this.newField(false);
        }
        return this.illegalUTF83ByteField;
    }

    private ZapTextArea getIllegalUTF84ByteField() {
        if (this.illegalUTF84ByteField == null) {
            this.illegalUTF84ByteField = this.newField(false);
        }
        return this.illegalUTF84ByteField;
    }

    private Encoder getEncoder() {
        if (this.encoder == null) {
            this.encoder = new Encoder();
        }
        return this.encoder;
    }

    public String decodeHexString(String string) {
        String string2 = "";
        String string3 = null;
        if (string != null && string.length() > 0) {
            int n = string.length() / 2;
            byte[] byArray = new byte[n];
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                string3 = string.substring(n2, n2 + 2);
                n2 += 2;
                byArray[i] = (byte)(Integer.parseInt(string3, 16) & 0xFF);
            }
            string2 = new String(byArray);
        }
        return string2;
    }

    public String decodeHTMLString(String string) {
        return StringEscapeUtils.unescapeHtml(string);
    }

    public String decodeJavaScriptString(String string) {
        return StringEscapeUtils.unescapeJavaScript(string);
    }

    private void updateEncodeDecodeFields() {
        try {
            this.base64EncodeField.setText(this.getEncoder().getBase64Encode(this.getInputField().getText()));
        }
        catch (NullPointerException nullPointerException) {
            log.error((Object)nullPointerException.getMessage(), (Throwable)nullPointerException);
        }
        catch (IOException iOException) {
            log.error((Object)iOException.getMessage(), (Throwable)iOException);
        }
        try {
            this.base64DecodeField.setText(this.getEncoder().getBase64Decode(this.getInputField().getText()));
            this.base64DecodeField.setEnabled(this.base64DecodeField.getText().length() > 0);
        }
        catch (IOException iOException) {
            this.base64DecodeField.setText(iOException.getMessage());
            this.base64DecodeField.setEnabled(false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.base64DecodeField.setText(illegalArgumentException.getMessage());
            this.base64DecodeField.setEnabled(false);
        }
        this.urlEncodeField.setText(this.getEncoder().getURLEncode(this.getInputField().getText()));
        try {
            this.urlDecodeField.setText(this.getEncoder().getURLDecode(this.getInputField().getText()));
        }
        catch (Exception exception) {
            this.urlDecodeField.setText("");
        }
        this.urlDecodeField.setEnabled(this.urlDecodeField.getText().length() > 0);
        this.asciiHexEncodeField.setText(this.getEncoder().getHexString(this.getInputField().getText().getBytes()));
        try {
            this.asciiHexDecodeField.setText(this.decodeHexString(this.getInputField().getText()));
        }
        catch (Exception exception) {
            this.asciiHexDecodeField.setText("");
        }
        this.asciiHexDecodeField.setEnabled(this.asciiHexDecodeField.getText().length() > 0);
        this.HTMLEncodeField.setText(this.getEncoder().getHTMLString(this.getInputField().getText()));
        try {
            this.HTMLDecodeField.setText(this.decodeHTMLString(this.getInputField().getText()));
        }
        catch (Exception exception) {
            this.HTMLDecodeField.setText("");
        }
        this.HTMLDecodeField.setEnabled(this.HTMLDecodeField.getText().length() > 0);
        this.JavaScriptEncodeField.setText(this.getEncoder().getJavaScriptString(this.getInputField().getText()));
        try {
            this.JavaScriptDecodeField.setText(this.decodeJavaScriptString(this.getInputField().getText()));
        }
        catch (Exception exception) {
            this.JavaScriptDecodeField.setText("");
        }
        this.JavaScriptDecodeField.setEnabled(this.JavaScriptDecodeField.getText().length() > 0);
        try {
            this.sha1HashField.setText(this.getEncoder().getHexString(this.getEncoder().getHashSHA1(this.getInputField().getText().getBytes())));
        }
        catch (Exception exception) {
            this.sha1HashField.setText("");
        }
        try {
            this.md5HashField.setText(this.getEncoder().getHexString(this.getEncoder().getHashMD5(this.getInputField().getText().getBytes())));
        }
        catch (Exception exception) {
            this.md5HashField.setText("");
        }
        try {
            this.illegalUTF82ByteField.setText(this.getEncoder().getIllegalUTF8Encode(this.getInputField().getText(), 2));
        }
        catch (Exception exception) {
            this.illegalUTF82ByteField.setText("");
        }
        try {
            this.illegalUTF83ByteField.setText(this.getEncoder().getIllegalUTF8Encode(this.getInputField().getText(), 3));
        }
        catch (Exception exception) {
            this.illegalUTF83ByteField.setText("");
        }
        try {
            this.illegalUTF84ByteField.setText(this.getEncoder().getIllegalUTF8Encode(this.getInputField().getText(), 4));
        }
        catch (Exception exception) {
            this.illegalUTF84ByteField.setText("");
        }
    }

    public void setInputField(String string) {
        this.getInputField().setText(string);
        this.updateEncodeDecodeFields();
    }

    public void updateOptions(EncodeDecodeParam encodeDecodeParam) {
        this.getEncoder().setBase64Charset(encodeDecodeParam.getBase64Charset());
        this.getEncoder().setBase64DoBreakLines(encodeDecodeParam.isBase64DoBreakLines());
        this.updateEncodeDecodeFields();
    }
}

