/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.search;

import edu.umass.cs.benchlab.har.HarEntries;
import edu.umass.cs.benchlab.har.HarLog;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.RecordHistory;
import org.parosproxy.paros.db.TableHistory;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiOther;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseConversionUtils;
import org.zaproxy.zap.extension.api.ApiResponseList;
import org.zaproxy.zap.extension.api.ApiResponseSet;
import org.zaproxy.zap.extension.api.ApiView;
import org.zaproxy.zap.extension.search.ExtensionSearch;
import org.zaproxy.zap.extension.search.SearchListenner;
import org.zaproxy.zap.extension.search.SearchResult;
import org.zaproxy.zap.utils.HarUtils;

public class SearchAPI
extends ApiImplementor {
    private static Logger log = Logger.getLogger(SearchAPI.class);
    private static final String PREFIX = "search";
    private static final String VIEW_URLS_BY_URL_REGEX = "urlsByUrlRegex";
    private static final String VIEW_URLS_BY_REQUEST_REGEX = "urlsByRequestRegex";
    private static final String VIEW_URLS_BY_RESPONSE_REGEX = "urlsByResponseRegex";
    private static final String VIEW_URLS_BY_HEADER_REGEX = "urlsByHeaderRegex";
    private static final String VIEW_MESSAGES_BY_URL_REGEX = "messagesByUrlRegex";
    private static final String VIEW_MESSAGES_BY_REQUEST_REGEX = "messagesByRequestRegex";
    private static final String VIEW_MESSAGES_BY_RESPONSE_REGEX = "messagesByResponseRegex";
    private static final String VIEW_MESSAGES_BY_HEADER_REGEX = "messagesByHeaderRegex";
    private static final String OTHER_HAR_BY_URL_REGEX = "harByUrlRegex";
    private static final String OTHER_HAR_BY_REQUEST_REGEX = "harByRequestRegex";
    private static final String OTHER_HAR_BY_RESPONSE_REGEX = "harByResponseRegex";
    private static final String OTHER_HAR_BY_HEADER_REGEX = "harByHeaderRegex";
    private static final String PARAM_BASE_URL = "baseurl";
    private static final String PARAM_COUNT = "count";
    private static final String PARAM_REGEX = "regex";
    private static final String PARAM_START = "start";
    private ExtensionSearch extension;

    public SearchAPI(ExtensionSearch extensionSearch) {
        this.extension = extensionSearch;
        String[] stringArray = new String[]{PARAM_REGEX};
        String[] stringArray2 = new String[]{PARAM_BASE_URL, PARAM_START, PARAM_COUNT};
        this.addApiView(new ApiView(VIEW_URLS_BY_URL_REGEX, stringArray, stringArray2));
        this.addApiView(new ApiView(VIEW_URLS_BY_REQUEST_REGEX, stringArray, stringArray2));
        this.addApiView(new ApiView(VIEW_URLS_BY_RESPONSE_REGEX, stringArray, stringArray2));
        this.addApiView(new ApiView(VIEW_URLS_BY_HEADER_REGEX, stringArray, stringArray2));
        this.addApiView(new ApiView(VIEW_MESSAGES_BY_URL_REGEX, stringArray, stringArray2));
        this.addApiView(new ApiView(VIEW_MESSAGES_BY_REQUEST_REGEX, stringArray, stringArray2));
        this.addApiView(new ApiView(VIEW_MESSAGES_BY_RESPONSE_REGEX, stringArray, stringArray2));
        this.addApiView(new ApiView(VIEW_MESSAGES_BY_HEADER_REGEX, stringArray, stringArray2));
        this.addApiOthers(new ApiOther(OTHER_HAR_BY_URL_REGEX, stringArray, stringArray2));
        this.addApiOthers(new ApiOther(OTHER_HAR_BY_REQUEST_REGEX, stringArray, stringArray2));
        this.addApiOthers(new ApiOther(OTHER_HAR_BY_RESPONSE_REGEX, stringArray, stringArray2));
        this.addApiOthers(new ApiOther(OTHER_HAR_BY_HEADER_REGEX, stringArray, stringArray2));
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    @Override
    public ApiResponse handleApiView(final String string, JSONObject jSONObject) throws ApiException {
        SearchViewResponseType searchViewResponseType;
        ExtensionSearch.Type type;
        final ApiResponseList apiResponseList = new ApiResponseList(string);
        switch (string) {
            case "urlsByUrlRegex": {
                type = ExtensionSearch.Type.URL;
                searchViewResponseType = SearchViewResponseType.URL;
                break;
            }
            case "messagesByUrlRegex": {
                type = ExtensionSearch.Type.URL;
                searchViewResponseType = SearchViewResponseType.MESSAGE;
                break;
            }
            case "urlsByRequestRegex": {
                type = ExtensionSearch.Type.Request;
                searchViewResponseType = SearchViewResponseType.URL;
                break;
            }
            case "messagesByRequestRegex": {
                type = ExtensionSearch.Type.Request;
                searchViewResponseType = SearchViewResponseType.MESSAGE;
                break;
            }
            case "urlsByResponseRegex": {
                type = ExtensionSearch.Type.Response;
                searchViewResponseType = SearchViewResponseType.URL;
                break;
            }
            case "messagesByResponseRegex": {
                type = ExtensionSearch.Type.Response;
                searchViewResponseType = SearchViewResponseType.MESSAGE;
                break;
            }
            case "urlsByHeaderRegex": {
                type = ExtensionSearch.Type.Header;
                searchViewResponseType = SearchViewResponseType.URL;
                break;
            }
            case "messagesByHeaderRegex": {
                type = ExtensionSearch.Type.Header;
                searchViewResponseType = SearchViewResponseType.MESSAGE;
                break;
            }
            default: {
                throw new ApiException(ApiException.Type.BAD_VIEW);
            }
        }
        SearchAPI.validateRegex(jSONObject);
        try {
            Object object = SearchViewResponseType.MESSAGE == searchViewResponseType ? new SearchResultsProcessor(){

                @Override
                public void processRecordHistory(RecordHistory recordHistory) {
                    apiResponseList.addItem(ApiResponseConversionUtils.httpMessageToSet(recordHistory.getHistoryId(), recordHistory.getHttpMessage()));
                }
            } : new SearchResultsProcessor(){

                @Override
                public void processRecordHistory(RecordHistory recordHistory) {
                    HttpMessage httpMessage = recordHistory.getHttpMessage();
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("id", String.valueOf(recordHistory.getHistoryId()));
                    hashMap.put("type", String.valueOf(recordHistory.getHistoryType()));
                    hashMap.put("method", httpMessage.getRequestHeader().getMethod());
                    hashMap.put("url", httpMessage.getRequestHeader().getURI().toString());
                    hashMap.put("code", String.valueOf(httpMessage.getResponseHeader().getStatusCode()));
                    hashMap.put("time", String.valueOf(httpMessage.getTimeElapsedMillis()));
                    apiResponseList.addItem(new ApiResponseSet(string, hashMap));
                }
            };
            this.search(jSONObject, type, (SearchResultsProcessor)object);
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            throw new ApiException(ApiException.Type.INTERNAL_ERROR, exception.getMessage());
        }
        return apiResponseList;
    }

    private static void validateRegex(JSONObject jSONObject) throws ApiException {
        try {
            Pattern.compile(jSONObject.getString(PARAM_REGEX));
        }
        catch (NullPointerException | PatternSyntaxException runtimeException) {
            throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_REGEX, runtimeException);
        }
    }

    @Override
    public HttpMessage handleApiOther(HttpMessage httpMessage, String string, JSONObject jSONObject) throws ApiException {
        ExtensionSearch.Type type;
        byte[] byArray = new byte[]{};
        switch (string) {
            case "harByUrlRegex": {
                type = ExtensionSearch.Type.URL;
                break;
            }
            case "harByRequestRegex": {
                type = ExtensionSearch.Type.Request;
                break;
            }
            case "harByResponseRegex": {
                type = ExtensionSearch.Type.Response;
                break;
            }
            case "harByHeaderRegex": {
                type = ExtensionSearch.Type.Header;
                break;
            }
            default: {
                throw new ApiException(ApiException.Type.BAD_OTHER);
            }
        }
        SearchAPI.validateRegex(jSONObject);
        try {
            String string2 = new HarEntries();
            this.search(jSONObject, type, new SearchResultsProcessor((HarEntries)string2){
                final /* synthetic */ HarEntries val$entries;
                {
                    this.val$entries = harEntries;
                }

                @Override
                public void processRecordHistory(RecordHistory recordHistory) {
                    this.val$entries.addEntry(HarUtils.createHarEntry(recordHistory.getHttpMessage()));
                }
            });
            HarLog harLog = HarUtils.createZapHarLog();
            harLog.setEntries((HarEntries)string2);
            byArray = HarUtils.harLogToByteArray(harLog);
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            ApiException apiException = new ApiException(ApiException.Type.INTERNAL_ERROR, exception.getMessage());
            byArray = apiException.toString(API.Format.JSON, this.incErrorDetails()).getBytes(StandardCharsets.UTF_8);
        }
        try {
            httpMessage.setResponseHeader(API.getDefaultResponseHeader("application/json; charset=UTF-8", byArray.length));
        }
        catch (HttpMalformedHeaderException httpMalformedHeaderException) {
            log.error((Object)("Failed to create response header: " + httpMalformedHeaderException.getMessage()), (Throwable)httpMalformedHeaderException);
        }
        httpMessage.setResponseBody(byArray);
        return httpMessage;
    }

    private boolean incErrorDetails() {
        return Model.getSingleton().getOptionsParam().getApiParam().isIncErrorDetails();
    }

    private void search(JSONObject jSONObject, ExtensionSearch.Type type, SearchResultsProcessor searchResultsProcessor) throws InterruptedException {
        ApiSearchListener apiSearchListener = new ApiSearchListener();
        this.extension.search(jSONObject.getString(PARAM_REGEX), apiSearchListener, type, false, false, this.getParam(jSONObject, PARAM_BASE_URL, null), this.getParam(jSONObject, PARAM_START, -1), this.getParam(jSONObject, PARAM_COUNT, -1), false);
        while (!apiSearchListener.isSearchComplete()) {
            Thread.sleep(100L);
        }
        TableHistory tableHistory = Model.getSingleton().getDb().getTableHistory();
        for (Integer n : apiSearchListener.getHistoryReferencesIds()) {
            try {
                searchResultsProcessor.processRecordHistory(tableHistory.read(n));
            }
            catch (DatabaseException | HttpMalformedHeaderException exception) {
                log.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    private static class ApiSearchListener
    implements SearchListenner {
        private boolean searchComplete = false;
        private List<Integer> historyReferencesIds = new LinkedList<Integer>();

        @Override
        public void addSearchResult(SearchResult searchResult) {
            this.historyReferencesIds.add(searchResult.getMessage().getHistoryRef().getHistoryId());
        }

        @Override
        public void searchComplete() {
            this.searchComplete = true;
        }

        public boolean isSearchComplete() {
            return this.searchComplete;
        }

        public List<Integer> getHistoryReferencesIds() {
            return this.historyReferencesIds;
        }
    }

    private static interface SearchResultsProcessor {
        public void processRecordHistory(RecordHistory var1);
    }

    private static enum SearchViewResponseType {
        URL,
        MESSAGE;

    }
}

