/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.model;

import org.parosproxy.paros.Constant;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.model.HttpMessageLocation;
import org.zaproxy.zap.model.MessageLocation;
import org.zaproxy.zap.model.TextHttpMessageLocation;

public class DefaultTextHttpMessageLocation
implements TextHttpMessageLocation {
    private final HttpMessageLocation.Location location;
    private final int start;
    private final int end;
    private final String value;

    public DefaultTextHttpMessageLocation(HttpMessageLocation.Location location, int n) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location must not be null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Parameter position must be greater or equal to zero.");
        }
        this.location = location;
        this.start = n;
        this.end = n;
        this.value = "";
    }

    public DefaultTextHttpMessageLocation(HttpMessageLocation.Location location, int n, int n2, String string) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location must not be null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Parameter start must be greater or equal to zero.");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Parameter end must be greater or equal to zero.");
        }
        if (n > n2) {
            throw new IllegalArgumentException("Parameter end must be greater than start.");
        }
        if (string == null) {
            throw new IllegalArgumentException("Parameter value must not be null.");
        }
        this.location = location;
        this.start = n;
        this.end = n2;
        this.value = string;
    }

    @Override
    public HttpMessageLocation.Location getLocation() {
        return this.location;
    }

    public Class<HttpMessage> getTargetMessageClass() {
        return HttpMessage.class;
    }

    @Override
    public String getDescription() {
        StringBuffer stringBuffer = new StringBuffer(25);
        switch (this.location) {
            case REQUEST_HEADER: 
            case RESPONSE_HEADER: {
                stringBuffer.append(Constant.messages.getString("messagelocation.http.text.location.header"));
                break;
            }
            case REQUEST_BODY: 
            case RESPONSE_BODY: {
                stringBuffer.append(Constant.messages.getString("messagelocation.http.text.location.body"));
                break;
            }
            default: {
                stringBuffer.append(Constant.messages.getString("messagelocation.http.text.location.unknown"));
            }
        }
        stringBuffer.append(" [").append(this.start);
        if (this.start != this.end) {
            stringBuffer.append(", ").append(this.end);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    @Override
    public boolean overlaps(MessageLocation messageLocation) {
        if (!(messageLocation instanceof HttpMessageLocation)) {
            return true;
        }
        HttpMessageLocation httpMessageLocation = (HttpMessageLocation)messageLocation;
        if (this.location != httpMessageLocation.getLocation()) {
            return false;
        }
        if (!(httpMessageLocation instanceof TextHttpMessageLocation)) {
            return true;
        }
        TextHttpMessageLocation textHttpMessageLocation = (TextHttpMessageLocation)httpMessageLocation;
        if (this.start == textHttpMessageLocation.getStart()) {
            return this.start == this.end ? this.end == textHttpMessageLocation.getEnd() : false;
        }
        if (this.start < textHttpMessageLocation.getStart()) {
            return this.end > textHttpMessageLocation.getStart();
        }
        return this.start < textHttpMessageLocation.getEnd();
    }

    @Override
    public int compareTo(MessageLocation messageLocation) {
        if (!(messageLocation instanceof HttpMessageLocation)) {
            return 1;
        }
        HttpMessageLocation httpMessageLocation = (HttpMessageLocation)messageLocation;
        if (this.location != httpMessageLocation.getLocation()) {
            if (this.location.ordinal() > httpMessageLocation.getLocation().ordinal()) {
                return 1;
            }
            if (this.location.ordinal() < httpMessageLocation.getLocation().ordinal()) {
                return -1;
            }
        }
        if (!(httpMessageLocation instanceof TextHttpMessageLocation)) {
            return 1;
        }
        TextHttpMessageLocation textHttpMessageLocation = (TextHttpMessageLocation)httpMessageLocation;
        if (this.start > textHttpMessageLocation.getStart()) {
            return 1;
        }
        if (this.start < textHttpMessageLocation.getStart()) {
            return -1;
        }
        if (this.end > textHttpMessageLocation.getEnd()) {
            return 1;
        }
        if (this.end < textHttpMessageLocation.getEnd()) {
            return -1;
        }
        int n = this.value.compareTo(httpMessageLocation.getValue());
        if (n != 0) {
            return n;
        }
        return httpMessageLocation instanceof DefaultTextHttpMessageLocation ? 0 : 1;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.end;
        n = 31 * n + (this.location == null ? 0 : this.location.hashCode());
        n = 31 * n + this.start;
        n = 31 * n + (this.value == null ? 0 : this.value.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DefaultTextHttpMessageLocation defaultTextHttpMessageLocation = (DefaultTextHttpMessageLocation)object;
        if (this.end != defaultTextHttpMessageLocation.end) {
            return false;
        }
        if (this.location != defaultTextHttpMessageLocation.location) {
            return false;
        }
        if (this.start != defaultTextHttpMessageLocation.start) {
            return false;
        }
        return !(this.value == null ? defaultTextHttpMessageLocation.value != null : !this.value.equals(defaultTextHttpMessageLocation.value));
    }
}

