/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.log4j.Logger;
import org.zaproxy.zap.spider.SpiderParam;
import org.zaproxy.zap.spider.URLResolver;

public final class URLCanonicalizer {
    private static final Logger log = Logger.getLogger(URLCanonicalizer.class);
    private static final Set<String> IRRELEVANT_PARAMETERS = new HashSet<String>(3);
    private static final Pattern patternResourceIdentifierUnquoted;
    private static final Pattern patternResourceMultipleIdentifier;
    private static final Pattern patternResourceMultipleIdentifierDetail;

    private URLCanonicalizer() {
    }

    public static String getCanonicalURL(String string) {
        return URLCanonicalizer.getCanonicalURL(string, null);
    }

    public static String getCanonicalURL(String string, String string2) {
        try {
            int n;
            String string3;
            URI uRI;
            String string4 = URLResolver.resolveUrl(string2 == null ? "" : string2, string);
            log.debug((Object)("Resolved URL: " + string4));
            try {
                uRI = new URI(string4);
            }
            catch (Exception exception) {
                uRI = new URI(URIUtil.encodeQuery((String)string4));
            }
            if (uRI.getScheme() == null) {
                throw new MalformedURLException("Protocol could not be reliably evaluated from uri: " + uRI + " and base url: " + string2);
            }
            if (uRI.getRawAuthority() == null) {
                log.debug((Object)("Ignoring URI with no authority (host[\":\"port]): " + uRI));
                return null;
            }
            if (uRI.getHost() == null) {
                throw new MalformedURLException("Host could not be reliably evaluated from: " + uRI);
            }
            String string5 = uRI.normalize().getRawPath();
            int n2 = string5.indexOf("//");
            while (n2 >= 0) {
                string5 = string5.replace("//", "/");
                n2 = string5.indexOf("//");
            }
            while (string5.startsWith("/../")) {
                string5 = string5.substring(3);
            }
            string5 = string5.trim();
            SortedSet<QueryParameter> sortedSet = URLCanonicalizer.createSortedParameters(uRI.getRawQuery());
            String string6 = URLCanonicalizer.canonicalize(sortedSet);
            String string7 = string3 = string6.isEmpty() ? "" : "?" + string6;
            if (string5.length() == 0) {
                string5 = "/" + string5;
            }
            if ((n = uRI.getPort()) == 80) {
                n = -1;
            }
            String string8 = uRI.getScheme().toLowerCase();
            String string9 = uRI.getHost().toLowerCase();
            String string10 = URLCanonicalizer.normalizePath(string5) + string3;
            URL uRL = new URL(string8, string9, n, string10);
            return uRL.toExternalForm();
        }
        catch (Exception exception) {
            log.warn((Object)("Error while Processing URL in the spidering process (on base " + string2 + "): " + exception.getMessage()));
            return null;
        }
    }

    public static String buildCleanedParametersURIRepresentation(org.apache.commons.httpclient.URI uRI, SpiderParam.HandleParametersOption handleParametersOption, boolean bl) throws URIException {
        if (handleParametersOption.equals((Object)SpiderParam.HandleParametersOption.USE_ALL)) {
            return uRI.toString();
        }
        if (handleParametersOption.equals((Object)SpiderParam.HandleParametersOption.IGNORE_COMPLETELY)) {
            return URLCanonicalizer.createBaseUriWithCleanedPath(uRI, handleParametersOption, bl);
        }
        if (handleParametersOption.equals((Object)SpiderParam.HandleParametersOption.IGNORE_VALUE)) {
            StringBuilder stringBuilder = new StringBuilder(URLCanonicalizer.createBaseUriWithCleanedPath(uRI, handleParametersOption, bl));
            String string = URLCanonicalizer.getCleanedQuery(uRI.getEscapedQuery());
            if (string.length() > 0) {
                stringBuilder.append('?').append(string);
            }
            return stringBuilder.toString();
        }
        return uRI.toString();
    }

    private static String createBaseUriWithCleanedPath(org.apache.commons.httpclient.URI uRI, SpiderParam.HandleParametersOption handleParametersOption, boolean bl) throws URIException {
        StringBuilder stringBuilder = new StringBuilder(URLCanonicalizer.createBaseUri(uRI));
        stringBuilder.append(URLCanonicalizer.getCleanedPath(uRI.getEscapedPath(), handleParametersOption, bl));
        return stringBuilder.toString();
    }

    private static String createBaseUri(org.apache.commons.httpclient.URI uRI) throws URIException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(uRI.getScheme()).append("://").append(uRI.getHost());
        if (uRI.getPort() != -1) {
            stringBuilder.append(':').append(uRI.getPort());
        }
        return stringBuilder.toString();
    }

    private static String getCleanedPath(String string, SpiderParam.HandleParametersOption handleParametersOption, boolean bl) {
        if (string == null) {
            return "";
        }
        String string2 = bl ? URLCanonicalizer.cleanODataPath(string, handleParametersOption) : string;
        return string2;
    }

    private static String getCleanedQuery(String string) {
        SortedSet<QueryParameter> sortedSet = URLCanonicalizer.createSortedParameters(string);
        HashSet<String> hashSet = new HashSet<String>();
        StringBuilder stringBuilder = new StringBuilder();
        if (sortedSet != null && !sortedSet.isEmpty()) {
            for (QueryParameter queryParameter : sortedSet) {
                String string2 = queryParameter.getName();
                if (hashSet.contains(string2)) continue;
                hashSet.add(string2);
                if (IRRELEVANT_PARAMETERS.contains(string2) || string2.startsWith("utm_")) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('&');
                }
                stringBuilder.append(string2);
            }
        }
        return stringBuilder.toString();
    }

    private static String cleanODataPath(String string, SpiderParam.HandleParametersOption handleParametersOption) {
        String string2 = string;
        if (SpiderParam.HandleParametersOption.USE_ALL.equals((Object)handleParametersOption)) {
            string2 = string;
        } else {
            Matcher matcher = patternResourceIdentifierUnquoted.matcher(string);
            if (matcher.find()) {
                String string3 = matcher.group(1);
                String string4 = matcher.group(2);
                String string5 = string3 + "(" + string4 + ")";
                int n = string.indexOf(string5);
                int n2 = n + string5.length();
                String string6 = string.substring(0, n);
                String string7 = string.substring(n2);
                if (SpiderParam.HandleParametersOption.IGNORE_COMPLETELY.equals((Object)handleParametersOption) || SpiderParam.HandleParametersOption.IGNORE_VALUE.equals((Object)handleParametersOption)) {
                    StringBuilder stringBuilder = new StringBuilder(string6);
                    stringBuilder.append(string3).append("()").append(string7);
                    string2 = stringBuilder.toString();
                }
            } else {
                matcher = patternResourceMultipleIdentifier.matcher(string);
                if (matcher.find()) {
                    String string8 = matcher.group(1);
                    int n = string.indexOf(string8);
                    int n3 = n + string8.length();
                    String string9 = string.substring(0, n);
                    String string10 = string.substring(n3);
                    if (SpiderParam.HandleParametersOption.IGNORE_COMPLETELY.equals((Object)handleParametersOption)) {
                        string2 = string9 + string10;
                    } else {
                        StringBuilder stringBuilder = new StringBuilder(string9);
                        matcher = patternResourceMultipleIdentifierDetail.matcher(string8);
                        int n4 = 1;
                        while (matcher.find()) {
                            if (n4 > 1) {
                                stringBuilder.append(',');
                            }
                            String string11 = matcher.group(1);
                            stringBuilder.append(string11);
                            ++n4;
                        }
                        stringBuilder.append(string10);
                        string2 = stringBuilder.toString();
                    }
                }
            }
        }
        return string2;
    }

    private static SortedSet<QueryParameter> createSortedParameters(String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        String[] stringArray = string.split("&");
        TreeSet<QueryParameter> treeSet = new TreeSet<QueryParameter>();
        block4: for (String string2 : stringArray) {
            if (string2.length() == 0) continue;
            String[] stringArray2 = string2.split("=", 2);
            switch (stringArray2.length) {
                case 1: {
                    if (string2.charAt(0) == '=') {
                        treeSet.add(new QueryParameter("", stringArray2[0]));
                        continue block4;
                    }
                    treeSet.add(new QueryParameter(stringArray2[0], ""));
                    continue block4;
                }
                case 2: {
                    treeSet.add(new QueryParameter(stringArray2[0], stringArray2[1]));
                }
            }
        }
        return treeSet;
    }

    private static String canonicalize(SortedSet<QueryParameter> sortedSet) {
        if (sortedSet == null || sortedSet.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(100);
        for (QueryParameter queryParameter : sortedSet) {
            String string = queryParameter.getName().toLowerCase();
            if (IRRELEVANT_PARAMETERS.contains(string) || string.startsWith("utm_")) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append('&');
            }
            stringBuilder.append(queryParameter.getName());
            if (queryParameter.getValue().isEmpty()) continue;
            stringBuilder.append('=');
            stringBuilder.append(queryParameter.getValue());
        }
        return stringBuilder.toString();
    }

    private static String normalizePath(String string) {
        return string.replace("%7E", "~").replace(" ", "%20");
    }

    static {
        IRRELEVANT_PARAMETERS.add("jsessionid");
        IRRELEVANT_PARAMETERS.add("phpsessid");
        IRRELEVANT_PARAMETERS.add("aspsessionid");
        patternResourceIdentifierUnquoted = Pattern.compile("/([\\w%]*)\\(([\\w']*)\\)");
        patternResourceMultipleIdentifier = Pattern.compile("/[\\w%]*\\((.*)\\)");
        patternResourceMultipleIdentifierDetail = Pattern.compile("([\\w%]*)=([\\w']*)");
    }

    private static class QueryParameter
    implements Comparable<QueryParameter> {
        private final String name;
        private final String value;

        public QueryParameter(String string, String string2) {
            if (string == null) {
                throw new IllegalArgumentException("Parameter name must not be null.");
            }
            if (string2 == null) {
                throw new IllegalArgumentException("Parameter value must not be null.");
            }
            this.name = string;
            this.value = string2;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        @Override
        public int compareTo(QueryParameter queryParameter) {
            if (queryParameter == null) {
                return 1;
            }
            int n = this.name.compareTo(queryParameter.name);
            if (n != 0) {
                return n;
            }
            return this.value.compareTo(queryParameter.value);
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.name.hashCode();
            n = 31 * n + this.value.hashCode();
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            QueryParameter queryParameter = (QueryParameter)object;
            if (!this.name.equals(queryParameter.name)) {
                return false;
            }
            return this.value.equals(queryParameter.value);
        }
    }
}

