/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.messagecontainer.http;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;

public class PersistedHttpMessagesList
extends AbstractList<HttpMessage> {
    private static final Logger LOGGER = Logger.getLogger(PersistedHttpMessagesList.class);
    private final List<HistoryReference> historyReferences;

    public PersistedHttpMessagesList(List<HistoryReference> list) {
        this.historyReferences = list == null || list.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<HistoryReference>(list));
    }

    @Override
    public HttpMessage get(int n) {
        try {
            return this.historyReferences.get(n).getHttpMessage();
        }
        catch (DatabaseException | HttpMalformedHeaderException exception) {
            LOGGER.error((Object)("Failed to get the message from DB: " + exception.getMessage()), (Throwable)exception);
            return null;
        }
    }

    @Override
    public int size() {
        return this.historyReferences.size();
    }
}

