/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css.converters;

import com.sun.javafx.Utils;
import com.sun.javafx.css.ParsedValue;
import com.sun.javafx.css.StyleConverter;
import com.sun.javafx.css.converters.StringConverter;
import java.net.MalformedURLException;
import java.net.URL;
import javafx.scene.text.Font;

public final class URLConverter
extends StyleConverter<ParsedValue[], String> {
    public static URLConverter getInstance() {
        return Holder.INSTANCE;
    }

    private URLConverter() {
    }

    @Override
    public String convert(ParsedValue<ParsedValue[], String> parsedValue, Font font) {
        String string = null;
        try {
            ParsedValue[] parsedValueArray = parsedValue.getValue();
            Object object = StringConverter.getInstance().convert(parsedValueArray[0], font);
            object = ((String)object).startsWith("url(") ? Utils.stripQuotes(((String)object).substring(4, ((String)object).length() - 1)) : Utils.stripQuotes((String)object);
            URL uRL = (URL)parsedValueArray[1].getValue();
            URL uRL2 = null;
            if (uRL == null) {
                try {
                    uRL2 = new URL((String)object);
                }
                catch (MalformedURLException malformedURLException) {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    uRL2 = classLoader.getResource((String)object);
                }
            } else {
                uRL2 = new URL(uRL, (String)object);
            }
            if (uRL2 != null) {
                string = uRL2.toExternalForm();
            }
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("caught " + malformedURLException + " in 'URLType.convert'");
        }
        return string;
    }

    public String toString() {
        return "URLType";
    }

    private static class Holder {
        static URLConverter INSTANCE = new URLConverter();
        static SequenceConverter SEQUENCE_INSTANCE = new SequenceConverter();

        private Holder() {
        }
    }

    public static final class SequenceConverter
    extends StyleConverter<ParsedValue<ParsedValue[], String>[], String[]> {
        public static SequenceConverter getInstance() {
            return Holder.SEQUENCE_INSTANCE;
        }

        private SequenceConverter() {
        }

        @Override
        public String[] convert(ParsedValue<ParsedValue<ParsedValue[], String>[], String[]> parsedValue, Font font) {
            ParsedValue<ParsedValue[], String>[] parsedValueArray = parsedValue.getValue();
            String[] stringArray = new String[parsedValueArray.length];
            for (int i = 0; i < parsedValueArray.length; ++i) {
                stringArray[i] = URLConverter.getInstance().convert((ParsedValue)parsedValueArray[i], font);
            }
            return stringArray;
        }

        public String toString() {
            return "URLSeqType";
        }
    }
}

