/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.webapp;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.PatternMatcher;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.JarResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.webapp.AbstractConfiguration;
import org.eclipse.jetty.webapp.WebAppClassLoader;
import org.eclipse.jetty.webapp.WebAppContext;

public class WebInfConfiguration
extends AbstractConfiguration {
    private static final Logger LOG = Log.getLogger(WebInfConfiguration.class);
    public static final String TEMPDIR_CONFIGURED = "org.eclipse.jetty.tmpdirConfigured";
    public static final String CONTAINER_JAR_PATTERN = "org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern";
    public static final String WEBINF_JAR_PATTERN = "org.eclipse.jetty.server.webapp.WebInfIncludeJarPattern";
    public static final String RESOURCE_DIRS = "org.eclipse.jetty.resources";
    protected Resource _preUnpackBaseResource;

    @Override
    public void preConfigure(final WebAppContext context) throws Exception {
        this.resolveTempDirectory(context);
        this.unpack(context);
        String tmp = (String)context.getAttribute(WEBINF_JAR_PATTERN);
        Pattern webInfPattern = tmp == null ? null : Pattern.compile(tmp);
        tmp = (String)context.getAttribute(CONTAINER_JAR_PATTERN);
        Pattern containerPattern = tmp == null ? null : Pattern.compile(tmp);
        PatternMatcher containerJarNameMatcher = new PatternMatcher(){

            @Override
            public void matched(URI uri) throws Exception {
                context.getMetaData().addContainerResource(Resource.newResource(uri));
            }
        };
        ClassLoader loader = null;
        if (context.getClassLoader() != null) {
            loader = context.getClassLoader().getParent();
        }
        while (loader != null && loader instanceof URLClassLoader) {
            URL[] urls = ((URLClassLoader)loader).getURLs();
            if (urls != null) {
                URI[] containerUris = new URI[urls.length];
                int i = 0;
                for (URL u : urls) {
                    try {
                        containerUris[i] = u.toURI();
                    }
                    catch (URISyntaxException e) {
                        containerUris[i] = new URI(u.toString().replaceAll(" ", "%20"));
                    }
                    ++i;
                }
                containerJarNameMatcher.match(containerPattern, containerUris, false);
            }
            loader = loader.getParent();
        }
        PatternMatcher webInfJarNameMatcher = new PatternMatcher(){

            @Override
            public void matched(URI uri) throws Exception {
                context.getMetaData().addWebInfJar(Resource.newResource(uri));
            }
        };
        List<Resource> jars = this.findJars(context);
        URI[] uris = null;
        if (jars != null) {
            uris = new URI[jars.size()];
            int i = 0;
            for (Resource r : jars) {
                uris[i++] = r.getURI();
            }
        }
        webInfJarNameMatcher.match(webInfPattern, uris, true);
        context.getMetaData().setWebInfClassesDirs(this.findClassDirs(context));
    }

    @Override
    public void configure(WebAppContext context) throws Exception {
        Set resources;
        if (context.isStarted()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cannot configure webapp " + context + " after it is started", new Object[0]);
            }
            return;
        }
        Resource web_inf = context.getWebInf();
        if (web_inf != null && web_inf.isDirectory() && context.getClassLoader() instanceof WebAppClassLoader) {
            Resource lib;
            Resource classes = web_inf.addPath("classes/");
            if (classes.exists()) {
                ((WebAppClassLoader)context.getClassLoader()).addClassPath(classes);
            }
            if ((lib = web_inf.addPath("lib/")).exists() || lib.isDirectory()) {
                ((WebAppClassLoader)context.getClassLoader()).addJars(lib);
            }
        }
        if ((resources = (Set)context.getAttribute(RESOURCE_DIRS)) != null && !resources.isEmpty()) {
            Resource[] collection = new Resource[resources.size() + 1];
            int i = 0;
            collection[i++] = context.getBaseResource();
            for (Resource resource : resources) {
                collection[i++] = resource;
            }
            context.setBaseResource(new ResourceCollection(collection));
        }
    }

    @Override
    public void deconfigure(WebAppContext context) throws Exception {
        Boolean tmpdirConfigured;
        if (!context.isPersistTempDirectory()) {
            IO.delete(context.getTempDirectory());
        }
        if ((tmpdirConfigured = (Boolean)context.getAttribute(TEMPDIR_CONFIGURED)) != null && !tmpdirConfigured.booleanValue()) {
            context.setTempDirectory(null);
        }
        context.setBaseResource(this._preUnpackBaseResource);
    }

    @Override
    public void cloneConfigure(WebAppContext template, WebAppContext context) throws Exception {
        File tmpDir = File.createTempFile(WebInfConfiguration.getCanonicalNameForWebAppTmpDir(context), "", template.getTempDirectory().getParentFile());
        if (tmpDir.exists()) {
            IO.delete(tmpDir);
        }
        tmpDir.mkdir();
        tmpDir.deleteOnExit();
        context.setTempDirectory(tmpDir);
    }

    public void resolveTempDirectory(WebAppContext context) throws Exception {
        File work;
        File tmpDir = context.getTempDirectory();
        if (tmpDir != null) {
            this.configureTempDirectory(tmpDir, context);
            context.setAttribute(TEMPDIR_CONFIGURED, Boolean.TRUE);
            return;
        }
        File servletTmpDir = this.asFile(context.getAttribute("javax.servlet.context.tempdir"));
        if (servletTmpDir != null) {
            tmpDir = servletTmpDir;
            this.configureTempDirectory(tmpDir, context);
            context.setAttribute("javax.servlet.context.tempdir", tmpDir);
            context.setTempDirectory(tmpDir);
            return;
        }
        File baseTemp = this.asFile(context.getAttribute("org.eclipse.jetty.webapp.basetempdir"));
        if (baseTemp != null && baseTemp.isDirectory() && baseTemp.canWrite()) {
            this.makeTempDirectory(baseTemp, context);
            return;
        }
        File jettyBase = this.asFile(System.getProperty("jetty.base"));
        if (jettyBase != null && (work = new File(jettyBase, "work")).exists() && work.isDirectory() && work.canWrite()) {
            context.setPersistTempDirectory(true);
            this.makeTempDirectory(work, context);
            return;
        }
        this.makeTempDirectory(new File(System.getProperty("java.io.tmpdir")), context);
    }

    private File asFile(Object fileattr) {
        if (fileattr == null) {
            return null;
        }
        if (fileattr instanceof File) {
            return (File)fileattr;
        }
        if (fileattr instanceof String) {
            return new File((String)fileattr);
        }
        return null;
    }

    public void makeTempDirectory(File parent, WebAppContext context) throws Exception {
        if (!(parent != null && parent.exists() && parent.canWrite() && parent.isDirectory())) {
            throw new IllegalStateException("Parent for temp dir not configured correctly: " + (parent == null ? "null" : "writeable=" + parent.canWrite()));
        }
        String temp = WebInfConfiguration.getCanonicalNameForWebAppTmpDir(context);
        File tmpDir = null;
        if (context.isPersistTempDirectory()) {
            tmpDir = new File(parent, temp);
        } else {
            tmpDir = File.createTempFile(temp, ".dir", parent);
            tmpDir.delete();
            tmpDir.mkdirs();
        }
        this.configureTempDirectory(tmpDir, context);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Set temp dir " + tmpDir, new Object[0]);
        }
        context.setTempDirectory(tmpDir);
    }

    public void configureTempDirectory(File dir, WebAppContext context) {
        if (dir == null) {
            throw new IllegalArgumentException("Null temp dir");
        }
        if (dir.exists() && !context.isPersistTempDirectory() && !IO.delete(dir)) {
            throw new IllegalStateException("Failed to delete temp dir " + dir);
        }
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!context.isPersistTempDirectory()) {
            dir.deleteOnExit();
        }
        if (!dir.canWrite() || !dir.isDirectory()) {
            throw new IllegalStateException("Temp dir " + dir + " not useable: writeable=" + dir.canWrite() + ", dir=" + dir.isDirectory());
        }
    }

    public void unpack(WebAppContext context) throws IOException {
        Resource web_app = context.getBaseResource();
        this._preUnpackBaseResource = context.getBaseResource();
        if (web_app == null) {
            Resource jarWebApp;
            String war = context.getWar();
            web_app = war != null && war.length() > 0 ? context.newResource(war) : context.getBaseResource();
            if (web_app == null) {
                throw new IllegalStateException("No resourceBase or war set for context");
            }
            if (web_app.getAlias() != null) {
                LOG.debug(web_app + " anti-aliased to " + web_app.getAlias(), new Object[0]);
                web_app = context.newResource(web_app.getAlias());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Try webapp=" + web_app + ", exists=" + web_app.exists() + ", directory=" + web_app.isDirectory() + " file=" + web_app.getFile(), new Object[0]);
            }
            if (web_app.exists() && !web_app.isDirectory() && !web_app.toString().startsWith("jar:") && (jarWebApp = JarResource.newJarResource(web_app)).exists() && jarWebApp.isDirectory()) {
                web_app = jarWebApp;
            }
            if (web_app.exists() && (context.isCopyWebDir() && web_app.getFile() != null && web_app.getFile().isDirectory() || context.isExtractWAR() && web_app.getFile() != null && !web_app.getFile().isDirectory() || context.isExtractWAR() && web_app.getFile() == null || !web_app.isDirectory())) {
                File sibling;
                File warfile;
                File extractedWebAppDir = null;
                if (war != null && (warfile = Resource.newResource(war).getFile()) != null && warfile.getName().toLowerCase(Locale.ENGLISH).endsWith(".war") && (sibling = new File(warfile.getParent(), warfile.getName().substring(0, warfile.getName().length() - 4))).exists() && sibling.isDirectory() && sibling.canWrite()) {
                    extractedWebAppDir = sibling;
                }
                if (extractedWebAppDir == null) {
                    extractedWebAppDir = new File(context.getTempDirectory(), "webapp");
                }
                if (web_app.getFile() != null && web_app.getFile().isDirectory()) {
                    LOG.debug("Copy " + web_app + " to " + extractedWebAppDir, new Object[0]);
                    web_app.copyTo(extractedWebAppDir);
                } else {
                    Resource jar_web_app;
                    File extractionLock = new File(context.getTempDirectory(), ".extract_lock");
                    if (!extractedWebAppDir.exists()) {
                        extractionLock.createNewFile();
                        extractedWebAppDir.mkdir();
                        LOG.debug("Extract " + web_app + " to " + extractedWebAppDir, new Object[0]);
                        jar_web_app = JarResource.newJarResource(web_app);
                        jar_web_app.copyTo(extractedWebAppDir);
                        extractionLock.delete();
                    } else if (web_app.lastModified() > extractedWebAppDir.lastModified() || extractionLock.exists()) {
                        extractionLock.createNewFile();
                        IO.delete(extractedWebAppDir);
                        extractedWebAppDir.mkdir();
                        LOG.debug("Extract " + web_app + " to " + extractedWebAppDir, new Object[0]);
                        jar_web_app = JarResource.newJarResource(web_app);
                        jar_web_app.copyTo(extractedWebAppDir);
                        extractionLock.delete();
                    }
                }
                web_app = Resource.newResource(extractedWebAppDir.getCanonicalPath());
            }
            if (!web_app.exists() || !web_app.isDirectory()) {
                LOG.warn("Web application not found " + war, new Object[0]);
                throw new FileNotFoundException(war);
            }
            context.setBaseResource(web_app);
            if (LOG.isDebugEnabled()) {
                LOG.debug("webapp=" + web_app, new Object[0]);
            }
        }
        if (context.isCopyWebInf() && !context.isCopyWebDir()) {
            Resource web_inf_classes;
            Resource web_inf = web_app.addPath("WEB-INF/");
            File extractedWebInfDir = new File(context.getTempDirectory(), "webinf");
            if (extractedWebInfDir.exists()) {
                IO.delete(extractedWebInfDir);
            }
            extractedWebInfDir.mkdir();
            Resource web_inf_lib = web_inf.addPath("lib/");
            File webInfDir = new File(extractedWebInfDir, "WEB-INF");
            webInfDir.mkdir();
            if (web_inf_lib.exists()) {
                File webInfLibDir = new File(webInfDir, "lib");
                if (webInfLibDir.exists()) {
                    IO.delete(webInfLibDir);
                }
                webInfLibDir.mkdir();
                LOG.debug("Copying WEB-INF/lib " + web_inf_lib + " to " + webInfLibDir, new Object[0]);
                web_inf_lib.copyTo(webInfLibDir);
            }
            if ((web_inf_classes = web_inf.addPath("classes/")).exists()) {
                File webInfClassesDir = new File(webInfDir, "classes");
                if (webInfClassesDir.exists()) {
                    IO.delete(webInfClassesDir);
                }
                webInfClassesDir.mkdir();
                LOG.debug("Copying WEB-INF/classes from " + web_inf_classes + " to " + webInfClassesDir.getAbsolutePath(), new Object[0]);
                web_inf_classes.copyTo(webInfClassesDir);
            }
            web_inf = Resource.newResource(extractedWebInfDir.getCanonicalPath());
            ResourceCollection rc = new ResourceCollection(web_inf, web_app);
            if (LOG.isDebugEnabled()) {
                LOG.debug("context.resourcebase = " + rc, new Object[0]);
            }
            context.setBaseResource(rc);
        }
    }

    public static String getCanonicalNameForWebAppTmpDir(WebAppContext context) {
        int i;
        Connector[] connectors;
        StringBuffer canonicalName = new StringBuffer();
        canonicalName.append("jetty-");
        Server server = context.getServer();
        if (server != null && (connectors = context.getServer().getConnectors()).length > 0) {
            String host = null;
            int port = 0;
            if (connectors != null && connectors[0] instanceof NetworkConnector) {
                NetworkConnector connector = (NetworkConnector)connectors[0];
                host = connector.getHost();
                port = connector.getLocalPort();
                if (port < 0) {
                    port = connector.getPort();
                }
            }
            if (host == null) {
                host = "0.0.0.0";
            }
            canonicalName.append(host);
            canonicalName.append("-");
            canonicalName.append(port);
            canonicalName.append("-");
        }
        try {
            String tmp;
            Resource resource = context.getBaseResource();
            if (resource == null) {
                if (context.getWar() == null || context.getWar().length() == 0) {
                    throw new IllegalStateException("No resourceBase or war set for context");
                }
                resource = context.newResource(context.getWar());
            }
            if ((tmp = URIUtil.decodePath(resource.getURL().getPath())).endsWith("/")) {
                tmp = tmp.substring(0, tmp.length() - 1);
            }
            if (tmp.endsWith("!")) {
                tmp = tmp.substring(0, tmp.length() - 1);
            }
            i = tmp.lastIndexOf("/");
            canonicalName.append(tmp.substring(i + 1, tmp.length()));
            canonicalName.append("-");
        }
        catch (Exception e) {
            LOG.warn("Can't generate resourceBase as part of webapp tmp dir name: " + e, new Object[0]);
            LOG.debug(e);
        }
        String contextPath = context.getContextPath();
        contextPath = contextPath.replace('/', '_');
        contextPath = contextPath.replace('\\', '_');
        canonicalName.append(contextPath);
        canonicalName.append("-");
        String[] vhosts = context.getVirtualHosts();
        if (vhosts == null || vhosts.length <= 0) {
            canonicalName.append("any");
        } else {
            canonicalName.append(vhosts[0]);
        }
        for (i = 0; i < canonicalName.length(); ++i) {
            char c = canonicalName.charAt(i);
            if (Character.isJavaIdentifierPart(c) || "-.".indexOf(c) >= 0) continue;
            canonicalName.setCharAt(i, '.');
        }
        canonicalName.append("-");
        return canonicalName.toString();
    }

    protected List<Resource> findClassDirs(WebAppContext context) throws Exception {
        List<Resource> extraClassDirs;
        if (context == null) {
            return null;
        }
        ArrayList<Resource> classDirs = new ArrayList<Resource>();
        Resource webInfClasses = this.findWebInfClassesDir(context);
        if (webInfClasses != null) {
            classDirs.add(webInfClasses);
        }
        if ((extraClassDirs = this.findExtraClasspathDirs(context)) != null) {
            classDirs.addAll(extraClassDirs);
        }
        return classDirs;
    }

    protected List<Resource> findJars(WebAppContext context) throws Exception {
        List<Resource> extraClasspathJars;
        ArrayList<Resource> jarResources = new ArrayList<Resource>();
        List<Resource> webInfLibJars = this.findWebInfLibJars(context);
        if (webInfLibJars != null) {
            jarResources.addAll(webInfLibJars);
        }
        if ((extraClasspathJars = this.findExtraClasspathJars(context)) != null) {
            jarResources.addAll(extraClasspathJars);
        }
        return jarResources;
    }

    protected List<Resource> findWebInfLibJars(WebAppContext context) throws Exception {
        Resource web_inf = context.getWebInf();
        if (web_inf == null || !web_inf.exists()) {
            return null;
        }
        ArrayList<Resource> jarResources = new ArrayList<Resource>();
        Resource web_inf_lib = web_inf.addPath("/lib");
        if (web_inf_lib.exists() && web_inf_lib.isDirectory()) {
            String[] files = web_inf_lib.list();
            for (int f = 0; files != null && f < files.length; ++f) {
                try {
                    String extension;
                    Resource file = web_inf_lib.addPath(files[f]);
                    String fnlc = file.getName().toLowerCase(Locale.ENGLISH);
                    int dot = fnlc.lastIndexOf(46);
                    String string = extension = dot < 0 ? null : fnlc.substring(dot);
                    if (extension == null || !extension.equals(".jar") && !extension.equals(".zip")) continue;
                    jarResources.add(file);
                    continue;
                }
                catch (Exception ex) {
                    LOG.warn("EXCEPTION ", ex);
                }
            }
        }
        return jarResources;
    }

    protected List<Resource> findExtraClasspathJars(WebAppContext context) throws Exception {
        if (context == null || context.getExtraClasspath() == null) {
            return null;
        }
        ArrayList<Resource> jarResources = new ArrayList<Resource>();
        StringTokenizer tokenizer = new StringTokenizer(context.getExtraClasspath(), ",;");
        while (tokenizer.hasMoreTokens()) {
            Resource resource = context.newResource(tokenizer.nextToken().trim());
            String fnlc = resource.getName().toLowerCase(Locale.ENGLISH);
            int dot = fnlc.lastIndexOf(46);
            String extension = dot < 0 ? null : fnlc.substring(dot);
            if (extension == null || !extension.equals(".jar") && !extension.equals(".zip")) continue;
            jarResources.add(resource);
        }
        return jarResources;
    }

    protected Resource findWebInfClassesDir(WebAppContext context) throws Exception {
        Resource classes;
        if (context == null) {
            return null;
        }
        Resource web_inf = context.getWebInf();
        if (web_inf != null && web_inf.isDirectory() && (classes = web_inf.addPath("classes/")).exists()) {
            return classes;
        }
        return null;
    }

    protected List<Resource> findExtraClasspathDirs(WebAppContext context) throws Exception {
        if (context == null || context.getExtraClasspath() == null) {
            return null;
        }
        ArrayList<Resource> dirResources = new ArrayList<Resource>();
        StringTokenizer tokenizer = new StringTokenizer(context.getExtraClasspath(), ",;");
        while (tokenizer.hasMoreTokens()) {
            Resource resource = context.newResource(tokenizer.nextToken().trim());
            if (!resource.exists() || !resource.isDirectory()) continue;
            dirResources.add(resource);
        }
        return dirResources;
    }
}

