/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.annotation;

import java.lang.reflect.Method;
import java.util.concurrent.Executor;
import org.springframework.aop.interceptor.AsyncExecutionInterceptor;
import org.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.scheduling.annotation.Async;

public class AnnotationAsyncExecutionInterceptor
extends AsyncExecutionInterceptor {
    public AnnotationAsyncExecutionInterceptor(Executor defaultExecutor) {
        super(defaultExecutor);
    }

    public AnnotationAsyncExecutionInterceptor(Executor defaultExecutor, AsyncUncaughtExceptionHandler exceptionHandler) {
        super(defaultExecutor, exceptionHandler);
    }

    protected String getExecutorQualifier(Method method) {
        Async async = AnnotationUtils.findAnnotation(method, Async.class);
        if (async == null) {
            async = AnnotationUtils.findAnnotation(method.getDeclaringClass(), Async.class);
        }
        return async != null ? async.value() : null;
    }
}

