/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.net.URISyntaxException;
import java.util.HashMap;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.AsyncProducerCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.EndpointAware;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Producer;
import org.apache.camel.ServicePoolAware;
import org.apache.camel.Traceable;
import org.apache.camel.impl.InterceptSendToEndpoint;
import org.apache.camel.impl.ProducerCache;
import org.apache.camel.spi.IdAware;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.AsyncProcessorConverterHelper;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.EndpointHelper;
import org.apache.camel.util.EventHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendProcessor
extends ServiceSupport
implements AsyncProcessor,
Traceable,
EndpointAware,
IdAware {
    protected static final Logger LOG = LoggerFactory.getLogger(SendProcessor.class);
    protected final CamelContext camelContext;
    protected final ExchangePattern pattern;
    protected ProducerCache producerCache;
    protected AsyncProcessor producer;
    protected Endpoint destination;
    protected ExchangePattern destinationExchangePattern;
    protected String id;
    protected volatile long counter;

    public SendProcessor(Endpoint destination) {
        this(destination, null);
    }

    public SendProcessor(Endpoint destination, ExchangePattern pattern) {
        ObjectHelper.notNull(destination, "destination");
        this.destination = destination;
        this.camelContext = destination.getCamelContext();
        this.pattern = pattern;
        try {
            this.destinationExchangePattern = null;
            this.destinationExchangePattern = EndpointHelper.resolveExchangePatternFromUrl(destination.getEndpointUri());
        }
        catch (URISyntaxException e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
        ObjectHelper.notNull(this.camelContext, "camelContext");
    }

    public String toString() {
        return "sendTo(" + this.destination + (this.pattern != null ? " " + (Object)((Object)this.pattern) : "") + ")";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Deprecated
    public void setDestination(Endpoint destination) {
    }

    @Override
    public String getTraceLabel() {
        return URISupport.sanitizeUri(this.destination.getEndpointUri());
    }

    @Override
    public Endpoint getEndpoint() {
        return this.destination;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(Exchange exchange, final AsyncCallback callback) {
        if (!this.isStarted()) {
            exchange.setException(new IllegalStateException("SendProcessor has not been started: " + this));
            callback.done(true);
            return true;
        }
        final ExchangePattern existingPattern = exchange.getPattern();
        ++this.counter;
        if (this.producer != null) {
            final StopWatch watch = new StopWatch();
            final Exchange target = this.configureExchange(exchange, this.pattern);
            EventHelper.notifyExchangeSending(exchange.getContext(), target, this.destination);
            LOG.debug(">>>> {} {}", (Object)this.destination, (Object)exchange);
            boolean sync = true;
            try {
                sync = this.producer.process(exchange, new AsyncCallback(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void done(boolean doneSync) {
                        try {
                            target.setPattern(existingPattern);
                            long timeTaken = watch.stop();
                            EventHelper.notifyExchangeSent(target.getContext(), target, SendProcessor.this.destination, timeTaken);
                        }
                        finally {
                            callback.done(doneSync);
                        }
                    }
                });
            }
            catch (Throwable throwable) {
                exchange.setException(throwable);
                callback.done(sync);
            }
            return sync;
        }
        return this.producerCache.doInAsyncProducer(this.destination, exchange, this.pattern, callback, new AsyncProducerCallback(){

            @Override
            public boolean doInAsyncProducer(Producer producer, AsyncProcessor asyncProducer, Exchange exchange, ExchangePattern pattern, final AsyncCallback callback) {
                final Exchange target = SendProcessor.this.configureExchange(exchange, pattern);
                LOG.debug(">>>> {} {}", (Object)SendProcessor.this.destination, (Object)exchange);
                return asyncProducer.process(target, new AsyncCallback(){

                    @Override
                    public void done(boolean doneSync) {
                        target.setPattern(existingPattern);
                        callback.done(doneSync);
                    }
                });
            }
        });
    }

    public Endpoint getDestination() {
        return this.destination;
    }

    public ExchangePattern getPattern() {
        return this.pattern;
    }

    protected Exchange configureExchange(Exchange exchange, ExchangePattern pattern) {
        if (this.destinationExchangePattern != null) {
            exchange.setPattern(this.destinationExchangePattern);
        } else if (pattern != null) {
            exchange.setPattern(pattern);
        }
        exchange.setProperty("CamelToEndpoint", this.destination.getEndpointUri());
        return exchange;
    }

    public long getCounter() {
        return this.counter;
    }

    public void reset() {
        this.counter = 0L;
    }

    @Override
    protected void doStart() throws Exception {
        if (this.producerCache == null) {
            this.producerCache = new ProducerCache((Object)this, this.camelContext, new HashMap<String, Producer>(1));
        }
        ServiceHelper.startService(this.producerCache);
        Endpoint lookup = this.camelContext.hasEndpoint(this.destination.getEndpointKey());
        if (lookup instanceof InterceptSendToEndpoint) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Intercepted sending to {} -> {}", (Object)URISupport.sanitizeUri(this.destination.getEndpointUri()), (Object)URISupport.sanitizeUri(lookup.getEndpointUri()));
            }
            this.destination = lookup;
        }
        ServiceHelper.startService(this.destination);
        Producer producer = this.producerCache.acquireProducer(this.destination);
        if (producer instanceof ServicePoolAware || !producer.isSingleton()) {
            this.producerCache.releaseProducer(this.destination, producer);
        } else {
            this.producer = AsyncProcessorConverterHelper.convert(producer);
        }
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.producerCache, this.producer);
    }

    @Override
    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices(this.producerCache, this.producer);
    }
}

