/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.wizards;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.ui.wizards.RubyClassSelectionDialog;

public class RubyNewClassWizardPage
extends WizardPage {
    private Text containerText;
    private Text classText;
    private Text superclassText;
    private ISelection selection;

    public RubyNewClassWizardPage(ISelection iSelection) {
        super("wizardPage");
        this.setTitle("New Ruby Class");
        this.setDescription("This wizard creates a new Ruby file with *.rb extension.");
        this.selection = iSelection;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 3;
        gridLayout.verticalSpacing = 9;
        Label label = new Label(composite2, 0);
        label.setText("&Container:");
        this.containerText = new Text(composite2, 2052);
        GridData gridData = new GridData(768);
        this.containerText.setLayoutData((Object)gridData);
        this.containerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                RubyNewClassWizardPage.this.dialogChanged();
            }
        });
        Button button = new Button(composite2, 8);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                RubyNewClassWizardPage.this.handleBrowse();
            }
        });
        label = new Label(composite2, 0);
        label.setText("&Superclass:");
        this.superclassText = new Text(composite2, 2052);
        gridData = new GridData(768);
        this.superclassText.setLayoutData((Object)gridData);
        this.superclassText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                RubyNewClassWizardPage.this.dialogChanged();
            }
        });
        button = new Button(composite2, 8);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                RubyNewClassWizardPage.this.handleSuperClassBrowse();
            }
        });
        label = new Label(composite2, 0);
        label.setText("Class &name:");
        this.classText = new Text(composite2, 2052);
        gridData = new GridData(768);
        this.classText.setLayoutData((Object)gridData);
        this.classText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                RubyNewClassWizardPage.this.dialogChanged();
            }
        });
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)composite2);
    }

    private void initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)this.selection;
            if (iStructuredSelection.size() > 1) {
                return;
            }
            Object object = iStructuredSelection.getFirstElement();
            if (object instanceof IResource) {
                IContainer iContainer = object instanceof IContainer ? (IContainer)object : ((IResource)object).getParent();
                this.containerText.setText(iContainer.getFullPath().toString());
            }
        }
        this.classText.setText("MyNewClass");
        this.superclassText.setText("Object");
    }

    private void handleSuperClassBrowse() {
        RubyClassSelectionDialog rubyClassSelectionDialog = new RubyClassSelectionDialog(this.getShell());
        if (rubyClassSelectionDialog.open() == 0) {
            this.superclassText.setText(((IRubyElement)rubyClassSelectionDialog.getFirstResult()).getElementName());
        }
    }

    private void handleBrowse() {
        Object[] objectArray;
        ContainerSelectionDialog containerSelectionDialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, "Select new file container");
        if (containerSelectionDialog.open() == 0 && (objectArray = containerSelectionDialog.getResult()).length == 1) {
            this.containerText.setText(((Path)objectArray[0]).toString());
        }
    }

    private void dialogChanged() {
        IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.getContainerName()));
        String string = this.getClassName();
        String string2 = this.getSuperclassName();
        if (this.getContainerName().length() == 0) {
            this.updateStatus("File container must be specified");
            return;
        }
        if (iResource == null || (iResource.getType() & 6) == 0) {
            this.updateStatus("File container must exist");
            return;
        }
        if (!iResource.isAccessible()) {
            this.updateStatus("Project must be writable");
            return;
        }
        if (string.length() == 0) {
            this.updateStatus("Class name must be specified");
            return;
        }
        if (!this.isConstant(string)) {
            this.updateStatus("Class name must be a constant. It must begin with a capital letter, and contain only letters, digits, or underscores.");
            return;
        }
        if (string2 != null && string2.length() > 0 && !this.isConstant(string2)) {
            this.updateStatus("Superclass name must be a constant. It must begin with a capital letter, and contain only letters, digits, or underscores.");
            return;
        }
        this.updateStatus(null);
    }

    private boolean isConstant(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        if (!Character.isLowerCase(string.charAt(0)) && !Character.isLetter(string.charAt(0))) {
            return false;
        }
        int n = string.indexOf("::");
        if (n != -1) {
            return this.isConstant(string.substring(0, n)) && this.isConstant(string.substring(n + 2));
        }
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (!Character.isLetterOrDigit(c) && c != '_') {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private void updateStatus(String string) {
        this.setErrorMessage(string);
        this.setPageComplete(string == null);
    }

    public String getContainerName() {
        return this.containerText.getText();
    }

    public String getClassName() {
        return this.classText.getText();
    }

    public String getSuperclassName() {
        return this.superclassText.getText();
    }
}

