/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.resources;

import java.io.InputStream;
import java.util.Date;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.tigris.subversion.subclipse.core.ISVNRemoteFile;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.Policy;
import org.tigris.subversion.subclipse.core.resources.RemoteFolder;
import org.tigris.subversion.subclipse.core.resources.RemoteResource;
import org.tigris.subversion.subclipse.core.resources.RemoteResourceStatus;
import org.tigris.subversion.svnclientadapter.ISVNAnnotations;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class RemoteFile
extends RemoteResource
implements ISVNRemoteFile {
    public RemoteFile(IResource local, byte[] bytes) {
        super(local, bytes);
    }

    public RemoteFile(RemoteFolder parent, ISVNRepositoryLocation repository, SVNUrl url, SVNRevision revision, SVNRevision.Number lastChangedRevision, Date date, String author) {
        super(parent, repository, url, revision, lastChangedRevision, date, author);
    }

    public RemoteFile(ISVNRepositoryLocation repository, SVNUrl url, SVNRevision revision) {
        super(repository, url, revision);
    }

    public RemoteFile(RemoteResourceStatus remoteStatusInfo) {
        this(null, remoteStatusInfo.getRepository(), remoteStatusInfo.getUrl(), (SVNRevision)remoteStatusInfo.getRepositoryRevision(), remoteStatusInfo.getLastChangedRevision(), remoteStatusInfo.getLastChangedDate(), remoteStatusInfo.getLastCommitAuthor());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void fetchContents(IProgressMonitor aMonitor) throws TeamException {
        IProgressMonitor monitor = Policy.monitorFor(aMonitor);
        monitor.beginTask(Policy.bind("RemoteFile.getContents"), 100);
        try {
            ISVNClientAdapter svnClient = this.repository.getSVNClient();
            try {
                InputStream inputStream = svnClient.getContent(this.url, this.getRevision());
                super.setContents(inputStream, monitor);
            }
            catch (SVNClientException e) {
                throw new TeamException("Failed in RemoteFile.getContents()", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        monitor.done();
    }

    public ISVNRemoteResource[] members(IProgressMonitor progress) {
        return new ISVNRemoteResource[0];
    }

    public boolean isContainer() {
        return false;
    }

    public boolean isFolder() {
        return false;
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (!(target instanceof RemoteFile)) {
            return false;
        }
        RemoteFile remote = (RemoteFile)target;
        return super.equals(target) && remote.getLastChangedRevision() == this.getLastChangedRevision();
    }

    public ISVNAnnotations getAnnotations(SVNRevision fromRevision, SVNRevision toRevision) throws TeamException {
        try {
            return this.repository.getSVNClient().annotate(this.url, fromRevision, toRevision);
        }
        catch (SVNClientException e) {
            throw new TeamException("Failed in remoteFile.getAnnotations()", (Throwable)e);
        }
    }
}

