/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.server.extensions.internal.actions;

import java.sql.Connection;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IVirtualNode;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinition;
import org.eclipse.wst.rdb.internal.core.rte.ICatalogObject;
import org.eclipse.wst.rdb.internal.models.sql.constraints.Assertion;
import org.eclipse.wst.rdb.internal.models.sql.constraints.Index;
import org.eclipse.wst.rdb.internal.models.sql.constraints.TableConstraint;
import org.eclipse.wst.rdb.internal.models.sql.datatypes.DistinctUserDefinedType;
import org.eclipse.wst.rdb.internal.models.sql.routines.Routine;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.internal.models.sql.schema.Schema;
import org.eclipse.wst.rdb.internal.models.sql.schema.Sequence;
import org.eclipse.wst.rdb.internal.models.sql.tables.Table;
import org.eclipse.wst.rdb.internal.models.sql.tables.Trigger;
import org.eclipse.wst.rdb.server.extensions.internal.ServerExtensionsPlugin;
import org.eclipse.wst.rdb.server.extensions.internal.editorlaunch.LaunchEditor;
import org.eclipse.wst.rdb.server.extensions.internal.templates.SQLTemplate;
import org.eclipse.wst.rdb.server.extensions.internal.templates.TemplateRegistry;
import org.eclipse.wst.rdb.server.extensions.internal.util.Utility;

public abstract class Action
implements IViewActionDelegate {
    protected IStructuredSelection selection = null;
    protected Object selectedObj;
    protected Connection connection = null;
    protected Database database = null;
    protected Schema schema = null;
    protected Table table = null;
    protected DatabaseDefinition dbDef = null;
    protected LaunchEditor editLaunch = null;

    public abstract void run(IAction var1);

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)selection;
        }
    }

    public void init(IViewPart view) {
    }

    public void openSQLTemplate() {
        SQLTemplate template = TemplateRegistry.getInstance().getTemplate(this.selectedObj, this.dbDef.getProduct());
        if (template == null) {
            template = TemplateRegistry.getInstance().getTemplate(this.selectedObj, "default");
        }
        if (template == null) {
            this.getEditorLaunch().launchSQLEditor("", Utility.getConnectionInfo(this.database), ServerExtensionsPlugin.getString("DEFAULT_TITLE"));
        } else {
            String ddl = template.getDdl();
            if (this.schema != null) {
                ddl = ddl.replaceAll("<schema>", this.schema.getName());
            }
            if (this.table != null) {
                ddl = ddl.replaceAll("<table>", this.table.getName());
            }
            this.getEditorLaunch().launchSQLEditor(ddl, Utility.getConnectionInfo(this.database), template.getTitle());
        }
    }

    protected LaunchEditor getEditorLaunch() {
        if (this.editLaunch == null) {
            this.editLaunch = new LaunchEditor();
        }
        return this.editLaunch;
    }

    protected void init() {
        this.table = null;
        this.schema = null;
        this.database = null;
        this.connection = null;
        this.dbDef = null;
        if (this.selection == null || this.selection.isEmpty() || this.selection.size() == 0) {
            return;
        }
        Object obj = this.selectedObj = this.selection.getFirstElement();
        while (obj instanceof IVirtualNode) {
            obj = ((IVirtualNode)obj).getParent();
        }
        if (obj instanceof Table) {
            this.table = (Table)obj;
            this.schema = this.table.getSchema();
            this.database = this.schema.getDatabase();
        } else if (obj instanceof Schema) {
            this.schema = (Schema)obj;
            this.database = this.schema.getDatabase();
        } else if (obj instanceof Routine) {
            this.schema = ((Routine)obj).getSchema();
            this.database = this.schema.getDatabase();
        } else if (obj instanceof DistinctUserDefinedType) {
            this.schema = ((DistinctUserDefinedType)obj).getSchema();
            this.database = this.schema.getDatabase();
        } else if (obj instanceof Sequence) {
            this.schema = ((Sequence)obj).getSchema();
            this.database = this.schema.getDatabase();
        } else if (obj instanceof Trigger) {
            this.schema = ((Trigger)obj).getSchema();
            this.database = this.schema.getDatabase();
        } else if (obj instanceof Index) {
            this.schema = ((Index)obj).getSchema();
            this.database = this.schema.getDatabase();
        } else if (obj instanceof TableConstraint) {
            this.schema = ((Table)((TableConstraint)obj).getContainer()).getSchema();
            this.database = this.schema.getDatabase();
        } else if (obj instanceof Assertion) {
            this.schema = ((Assertion)obj).getSchema();
            this.database = this.schema.getDatabase();
        } else if (obj instanceof ICatalogObject) {
            ICatalogObject catalogObject = (ICatalogObject)obj;
            this.database = catalogObject.getCatalogDatabase();
        } else {
            return;
        }
        this.connection = Utility.getConnectionInfo(this.database).getSharedConnection();
        this.dbDef = Utility.getDBDef(this.database);
    }
}

