/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.contenttype;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.xml.core.internal.contenttype.ByteReader;
import org.eclipse.wst.xml.core.internal.contenttype.HeadParserToken;
import org.eclipse.wst.xml.core.internal.contenttype.XMLHeadTokenizer;

public class XMLDeclDetector {
    private static final int MAX_BUF_SIZE = 8192;
    private static final int MAX_MARK_SIZE = 8192;
    protected boolean fHeaderParsed;
    private boolean fIsXML;
    protected Reader fReader;
    private XMLHeadTokenizer fTokenizer;

    private boolean canHandleAsUnicodeStream(String tokenType) {
        boolean canHandleAsUnicodeStream = false;
        if (tokenType == "UTF83ByteBOM") {
            canHandleAsUnicodeStream = true;
        } else if (tokenType == "UTF16BE") {
            canHandleAsUnicodeStream = true;
        } else if (tokenType == "UTF16LE") {
            canHandleAsUnicodeStream = true;
        }
        return canHandleAsUnicodeStream;
    }

    private final void ensureInputSet() {
        if (this.fReader == null) {
            throw new IllegalStateException("input must be set before use");
        }
    }

    private XMLHeadTokenizer getTokenizer() {
        if (this.fTokenizer == null) {
            this.fTokenizer = new XMLHeadTokenizer();
        }
        return this.fTokenizer;
    }

    public boolean isXML() throws IOException {
        this.ensureInputSet();
        if (!this.fHeaderParsed) {
            this.parseInput();
        }
        return this.fIsXML;
    }

    private void parseInput() throws IOException {
        XMLHeadTokenizer tokenizer = this.getTokenizer();
        tokenizer.reset(this.fReader);
        HeadParserToken token = null;
        String tokenType = null;
        do {
            if (this.canHandleAsUnicodeStream(tokenType = (token = tokenizer.getNextToken()).getType())) {
                this.fReader.reset();
                this.fIsXML = true;
                continue;
            }
            if (tokenType != "XMLDelEncoding") continue;
            this.fIsXML = true;
        } while (tokenizer.hasMoreTokens());
    }

    private void resetAll() {
        this.fReader = null;
        this.fHeaderParsed = false;
        this.fIsXML = false;
    }

    public void set(IFile iFile) throws CoreException {
        this.resetAll();
        InputStream inputStream = iFile.getContents(true);
        BufferedInputStream resettableStream = new BufferedInputStream(inputStream, 8192);
        ((InputStream)resettableStream).mark(8192);
        this.set(resettableStream);
    }

    public void set(InputStream inputStream) {
        this.resetAll();
        this.fReader = new ByteReader(inputStream);
        try {
            this.fReader.mark(8192);
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public void set(Reader reader) {
        this.resetAll();
        this.fReader = reader;
        if (!this.fReader.markSupported()) {
            this.fReader = new BufferedReader(this.fReader);
        }
        try {
            this.fReader.mark(8192);
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }
}

