/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.commands;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.wst.xsd.ui.internal.actions.MoveAction;
import org.eclipse.wst.xsd.ui.internal.actions.MoveAttributeAction;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDBaseAdapter;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDBaseAttributeAdapter;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDElementDeclarationAdapter;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.BaseFieldEditPart;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.CompartmentEditPart;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.ComplexTypeEditPart;
import org.eclipse.wst.xsd.ui.internal.common.commands.BaseCommand;
import org.eclipse.wst.xsd.ui.internal.design.editparts.AttributeGroupDefinitionEditPart;
import org.eclipse.wst.xsd.ui.internal.design.editparts.ConnectableEditPart;
import org.eclipse.wst.xsd.ui.internal.design.editparts.ModelGroupDefinitionReferenceEditPart;
import org.eclipse.wst.xsd.ui.internal.design.editparts.ModelGroupEditPart;
import org.eclipse.wst.xsd.ui.internal.design.editparts.TargetConnectionSpacingFigureEditPart;
import org.eclipse.wst.xsd.ui.internal.design.editparts.XSDAttributesForAnnotationEditPart;
import org.eclipse.wst.xsd.ui.internal.design.editparts.XSDBaseFieldEditPart;
import org.eclipse.wst.xsd.ui.internal.design.editparts.XSDGroupsForAnnotationEditPart;
import org.eclipse.wst.xsd.ui.internal.design.figures.GenericGroupFigure;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDModelGroup;

public class DragAndDropCommand
extends BaseCommand {
    protected EditPartViewer viewer;
    protected ChangeBoundsRequest request;
    protected BaseFieldEditPart previousChildRefEditPart;
    protected BaseFieldEditPart nextChildRefEditPart;
    public ModelGroupEditPart parentEditPart;
    protected AttributeGroupDefinitionEditPart parentAttributeGroupEditPart;
    protected XSDConcreteComponent parentComponent;
    public Point location;
    protected MoveAction action;
    protected MoveAttributeAction moveAttributeAction;
    protected boolean canExecute;
    protected boolean isElementToDrag;
    EditPart target;
    XSDBaseFieldEditPart selected;
    List modelGroupsList = new ArrayList();
    List targetSpacesList = new ArrayList();
    List attributeGroupsList = new ArrayList();
    XSDConcreteComponent previousRefComponent = null;
    XSDConcreteComponent nextRefComponent = null;
    ComplexTypeEditPart complexTypeEditPart;

    public DragAndDropCommand(EditPartViewer viewer, ChangeBoundsRequest request) {
        this.viewer = viewer;
        this.request = request;
        this.setup();
    }

    protected void setup() {
        this.location = this.request.getLocation();
        this.target = this.viewer.findObjectAt(this.location);
        if (this.viewer instanceof ScrollingGraphicalViewer) {
            ScrollingGraphicalViewer sgv = (ScrollingGraphicalViewer)this.viewer;
            Point p = ((FigureCanvas)sgv.getControl()).getViewport().getViewLocation();
            this.location.y += p.y;
            this.location.x += p.x;
        }
        List list = this.request.getEditParts();
        this.canExecute = false;
        if (list.size() == 1 && this.target instanceof BaseFieldEditPart) {
            List editPartsList = this.request.getEditParts();
            ArrayList<Notifier> concreteComponentList = new ArrayList<Notifier>(editPartsList.size());
            Iterator i = editPartsList.iterator();
            while (i.hasNext()) {
                EditPart editPart = (EditPart)i.next();
                concreteComponentList.add(((XSDBaseAdapter)editPart.getModel()).getTarget());
            }
            Object itemToDrag = list.get(0);
            if (itemToDrag instanceof XSDBaseFieldEditPart) {
                this.selected = (XSDBaseFieldEditPart)itemToDrag;
                if (this.selected.getModel() instanceof XSDElementDeclarationAdapter) {
                    this.isElementToDrag = true;
                } else if (this.selected.getModel() instanceof XSDBaseAttributeAdapter) {
                    this.isElementToDrag = false;
                } else {
                    return;
                }
                if (!this.isElementToDrag) {
                    XSDAttributeGroupDefinition attributeGroup = null;
                    this.attributeGroupsList.clear();
                    this.targetSpacesList.clear();
                    this.parentAttributeGroupEditPart = null;
                    this.calculateAttributeGroupList();
                    EditPart compartment = this.target.getParent();
                    this.parentEditPart = null;
                    if (compartment != null) {
                        List l = compartment.getChildren();
                        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
                        int index = 0;
                        BaseFieldEditPart childGraphNodeEditPart = null;
                        Iterator i2 = l.iterator();
                        while (i2.hasNext()) {
                            EditPart child = (EditPart)i2.next();
                            if (child instanceof BaseFieldEditPart) {
                                this.previousChildRefEditPart = childGraphNodeEditPart;
                                childGraphNodeEditPart = (BaseFieldEditPart)child;
                                rectangle = childGraphNodeEditPart.getFigure().getBounds();
                                if (this.location.y < rectangle.getCenter().y) {
                                    this.nextChildRefEditPart = childGraphNodeEditPart;
                                    TargetConnectionSpacingFigureEditPart tSpace = (TargetConnectionSpacingFigureEditPart)this.targetSpacesList.get(index);
                                    if (tSpace.getParent() instanceof AttributeGroupDefinitionEditPart) {
                                        this.parentAttributeGroupEditPart = (AttributeGroupDefinitionEditPart)tSpace.getParent();
                                        attributeGroup = this.parentAttributeGroupEditPart.getXSDAttributeGroupDefinition().getResolvedAttributeGroupDefinition();
                                        this.parentComponent = attributeGroup;
                                        break;
                                    }
                                    if (!(tSpace.getParent() instanceof XSDAttributesForAnnotationEditPart)) break;
                                    this.parentComponent = (XSDConcreteComponent)((XSDBaseAdapter)this.complexTypeEditPart.getModel()).getTarget();
                                    break;
                                }
                            }
                            ++index;
                        }
                    }
                    this.calculatePreviousAndNextEditParts();
                    this.moveAttributeAction = new MoveAttributeAction(this.parentComponent, concreteComponentList, this.previousRefComponent, this.nextRefComponent);
                    this.canExecute = this.moveAttributeAction.canMove();
                } else if (this.isElementToDrag) {
                    XSDModelGroup targetModelGroup = null;
                    this.modelGroupsList.clear();
                    this.targetSpacesList.clear();
                    this.calculateModelGroupList();
                    ArrayList<XSDModelGroup> modelGroups = new ArrayList<XSDModelGroup>(this.modelGroupsList.size());
                    Iterator i3 = this.modelGroupsList.iterator();
                    while (i3.hasNext()) {
                        ModelGroupEditPart editPart = (ModelGroupEditPart)i3.next();
                        modelGroups.add(editPart.getXSDModelGroup());
                    }
                    EditPart compartment = this.target.getParent();
                    this.parentEditPart = null;
                    if (compartment != null) {
                        List l = compartment.getChildren();
                        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
                        int index = 0;
                        BaseFieldEditPart childGraphNodeEditPart = null;
                        Iterator i4 = l.iterator();
                        while (i4.hasNext()) {
                            EditPart child = (EditPart)i4.next();
                            if (child instanceof BaseFieldEditPart) {
                                this.previousChildRefEditPart = childGraphNodeEditPart;
                                childGraphNodeEditPart = (BaseFieldEditPart)child;
                                rectangle = childGraphNodeEditPart.getFigure().getBounds();
                                if (this.location.y < rectangle.getCenter().y) {
                                    this.nextChildRefEditPart = childGraphNodeEditPart;
                                    TargetConnectionSpacingFigureEditPart tSpace = (TargetConnectionSpacingFigureEditPart)this.targetSpacesList.get(index);
                                    this.parentEditPart = (ModelGroupEditPart)tSpace.getParent();
                                    targetModelGroup = this.parentEditPart.getXSDModelGroup();
                                    break;
                                }
                            }
                            ++index;
                        }
                    }
                    this.calculatePreviousAndNextEditParts();
                    this.action = new MoveAction(targetModelGroup, concreteComponentList, this.previousRefComponent, this.nextRefComponent);
                    this.canExecute = this.action.canMove();
                }
            }
        }
    }

    protected void calculatePreviousAndNextEditParts() {
        if (this.nextChildRefEditPart != null && this.nextChildRefEditPart.getModel() instanceof XSDBaseAdapter) {
            this.nextRefComponent = (XSDConcreteComponent)((XSDBaseAdapter)this.nextChildRefEditPart.getModel()).getTarget();
        }
        if (this.previousChildRefEditPart != null && this.previousChildRefEditPart.getModel() instanceof XSDBaseAdapter) {
            this.previousRefComponent = (XSDConcreteComponent)((XSDBaseAdapter)this.previousChildRefEditPart.getModel()).getTarget();
        }
    }

    protected void calculateAttributeGroupList() {
        EditPart editPart = this.target;
        while (editPart != null) {
            if (editPart instanceof ComplexTypeEditPart) {
                this.complexTypeEditPart = (ComplexTypeEditPart)editPart;
                List list = editPart.getChildren();
                Iterator i = list.iterator();
                while (i.hasNext()) {
                    Object child = i.next();
                    if (!(child instanceof CompartmentEditPart)) continue;
                    List compartmentList = ((CompartmentEditPart)child).getChildren();
                    Iterator it = compartmentList.iterator();
                    while (it.hasNext()) {
                        Object obj = it.next();
                        if (!(obj instanceof XSDAttributesForAnnotationEditPart)) continue;
                        XSDAttributesForAnnotationEditPart groups = (XSDAttributesForAnnotationEditPart)obj;
                        List groupList = groups.getChildren();
                        Iterator iter = groupList.iterator();
                        while (iter.hasNext()) {
                            Object groupChild = iter.next();
                            if (groupChild instanceof TargetConnectionSpacingFigureEditPart) {
                                this.targetSpacesList.add(groupChild);
                                continue;
                            }
                            if (!(groupChild instanceof AttributeGroupDefinitionEditPart)) continue;
                            AttributeGroupDefinitionEditPart attributeGroupEditPart = (AttributeGroupDefinitionEditPart)groupChild;
                            this.attributeGroupsList.add(attributeGroupEditPart);
                            this.attributeGroupsList.addAll(this.getAttributeGroupEditParts(attributeGroupEditPart));
                        }
                    }
                }
            }
            editPart = editPart.getParent();
        }
    }

    protected void calculateModelGroupList() {
        EditPart editPart = this.target;
        while (editPart != null) {
            if (editPart instanceof ModelGroupEditPart) {
                ModelGroupEditPart modelGroupEditPart = (ModelGroupEditPart)editPart;
                this.modelGroupsList.addAll(this.getModelGroupEditParts(modelGroupEditPart));
            } else if (editPart instanceof ComplexTypeEditPart || editPart instanceof ModelGroupDefinitionReferenceEditPart) {
                List list = editPart.getChildren();
                Iterator i = list.iterator();
                while (i.hasNext()) {
                    Object child = i.next();
                    if (!(child instanceof CompartmentEditPart)) continue;
                    List compartmentList = ((CompartmentEditPart)child).getChildren();
                    Iterator it = compartmentList.iterator();
                    while (it.hasNext()) {
                        Object obj = it.next();
                        if (!(obj instanceof XSDGroupsForAnnotationEditPart)) continue;
                        XSDGroupsForAnnotationEditPart groups = (XSDGroupsForAnnotationEditPart)obj;
                        List groupList = groups.getChildren();
                        Iterator iter = groupList.iterator();
                        while (iter.hasNext()) {
                            Object groupChild = iter.next();
                            if (!(groupChild instanceof ModelGroupEditPart)) continue;
                            ModelGroupEditPart modelGroupEditPart = (ModelGroupEditPart)groupChild;
                            this.modelGroupsList.add(modelGroupEditPart);
                            this.modelGroupsList.addAll(this.getModelGroupEditParts(modelGroupEditPart));
                        }
                    }
                }
            }
            editPart = editPart.getParent();
        }
    }

    protected List getAttributeGroupEditParts(AttributeGroupDefinitionEditPart attributeGroupEditPart) {
        ArrayList<AttributeGroupDefinitionEditPart> groupList = new ArrayList<AttributeGroupDefinitionEditPart>();
        List list = attributeGroupEditPart.getChildren();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            Object object = i.next();
            if (object instanceof TargetConnectionSpacingFigureEditPart) {
                this.targetSpacesList.add(object);
                continue;
            }
            if (!(object instanceof AttributeGroupDefinitionEditPart)) continue;
            AttributeGroupDefinitionEditPart groupRef = (AttributeGroupDefinitionEditPart)object;
            List groupRefChildren = groupRef.getChildren();
            Iterator it = groupRefChildren.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (o instanceof TargetConnectionSpacingFigureEditPart) {
                    this.targetSpacesList.add(o);
                    continue;
                }
                if (!(o instanceof AttributeGroupDefinitionEditPart)) continue;
                AttributeGroupDefinitionEditPart aGroup = (AttributeGroupDefinitionEditPart)o;
                groupList.add(aGroup);
                groupList.addAll(this.getAttributeGroupEditParts(aGroup));
            }
        }
        return groupList;
    }

    protected List getModelGroupEditParts(ModelGroupEditPart modelGroupEditPart) {
        ArrayList<ModelGroupEditPart> modelGroupList = new ArrayList<ModelGroupEditPart>();
        List list = modelGroupEditPart.getChildren();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            Object object = i.next();
            if (object instanceof TargetConnectionSpacingFigureEditPart) {
                this.targetSpacesList.add(object);
                continue;
            }
            if (object instanceof ModelGroupDefinitionReferenceEditPart) {
                ModelGroupDefinitionReferenceEditPart groupRef = (ModelGroupDefinitionReferenceEditPart)object;
                List groupRefChildren = groupRef.getChildren();
                Iterator it = groupRefChildren.iterator();
                while (it.hasNext()) {
                    Object o = it.next();
                    if (!(o instanceof ModelGroupEditPart)) continue;
                    ModelGroupEditPart aGroup = (ModelGroupEditPart)o;
                    modelGroupList.add(aGroup);
                    modelGroupList.addAll(this.getModelGroupEditParts(aGroup));
                }
                continue;
            }
            if (!(object instanceof ModelGroupEditPart)) continue;
            ModelGroupEditPart aGroup = (ModelGroupEditPart)object;
            modelGroupList.add(aGroup);
            modelGroupList.addAll(this.getModelGroupEditParts(aGroup));
        }
        return modelGroupList;
    }

    public void execute() {
        if (this.canExecute) {
            if (this.isElementToDrag) {
                this.action.run();
            } else {
                this.moveAttributeAction.run();
            }
        }
    }

    public void redo() {
    }

    public void undo() {
    }

    public boolean canExecute() {
        return this.canExecute;
    }

    public PointList getConnectionPoints(Rectangle draggedFigureBounds) {
        PointList pointList = null;
        if (this.isElementToDrag) {
            if (this.parentEditPart != null && this.nextChildRefEditPart != null) {
                pointList = this.getConnectionPoints(this.parentEditPart, this.nextChildRefEditPart, draggedFigureBounds);
            }
        } else if (this.parentAttributeGroupEditPart != null && this.nextChildRefEditPart != null) {
            pointList = this.getConnectionPoints(this.parentAttributeGroupEditPart, this.nextChildRefEditPart, draggedFigureBounds);
        }
        return pointList != null ? pointList : new PointList();
    }

    public PointList getConnectionPoints(ConnectableEditPart parentEditPart, BaseFieldEditPart childRefEditPart, Rectangle draggedFigureBounds) {
        PointList pointList = new PointList();
        int[] data = new int[1];
        Point a = this.getConnectionPoint(parentEditPart, childRefEditPart, data);
        if (a != null) {
            int draggedFigureBoundsY = draggedFigureBounds.y + draggedFigureBounds.height / 2;
            pointList.addPoint(a);
            if (data[0] == 0) {
                int x = a.x + (draggedFigureBounds.x - a.x) / 2;
                pointList.addPoint(new Point(x, a.y));
                pointList.addPoint(new Point(x, draggedFigureBoundsY));
                pointList.addPoint(new Point(draggedFigureBounds.x, draggedFigureBoundsY));
            } else {
                pointList.addPoint(new Point(a.x, draggedFigureBoundsY));
                pointList.addPoint(new Point(draggedFigureBounds.x, draggedFigureBoundsY));
            }
        }
        return pointList;
    }

    protected Point getConnectionPoint(ConnectableEditPart parentEditPart, BaseFieldEditPart childRefEditPart, int[] data) {
        Point point = null;
        List childList = parentEditPart.getChildren();
        if (parentEditPart.getFigure() instanceof GenericGroupFigure && childList.size() > 0) {
            point = new Point();
            Rectangle r = this.getConnectedEditPartConnectionBounds(parentEditPart);
            point.x = r.x + r.width;
            point.y = r.y + r.height / 2;
        }
        return point;
    }

    protected Rectangle getConnectedEditPartConnectionBounds(ConnectableEditPart editPart) {
        return ((GenericGroupFigure)editPart.getFigure()).getIconFigure().getBounds();
    }
}

